/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.kano.joscar.rvcmd.SegmentedFilename;
import net.kano.joscar.rvproto.ft.FileTransferHeader;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Checksummer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FailureEventException;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingFileTransfer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Initiator;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.IncomingFileTransferPlumber;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.IncomingFileTransferPlumberImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferredFile;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.Transferrer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ChecksummingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.CorruptTransferEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.EventPost;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.FileCompleteEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ResumeChecksumFailedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.TransferredFileInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.TransferringFileEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.UnknownErrorEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.TransferSucceededInfo;

public class ReceiveFileController
extends TransferController {
    private static final Logger LOGGER = Logger.getLogger(ReceiveFileController.class.getName());
    private IncomingFileTransferPlumber plumber = null;

    public void setPlumber(IncomingFileTransferPlumber plumber) {
        this.plumber = plumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferInThread(RvConnection rvtransfer) throws IOException, FailureEventException {
        RvSessionConnectionInfo conninfo = rvtransfer.getRvSessionInfo();
        IncomingFileTransfer itransfer = (IncomingFileTransfer)rvtransfer;
        if (this.plumber == null) {
            this.plumber = new IncomingFileTransferPlumberImpl(itransfer, this);
        }
        ArrayList<TransferredFile> files = new ArrayList<TransferredFile>();
        EventPost eventpost = itransfer.getEventPost();
        long icbmId = conninfo.getRvSession().getRvSessionId();
        boolean finished = false;
        boolean stop = false;
        while (!stop && !this.shouldStop()) {
            FileTransferHeader doneHeader;
            boolean failed;
            long toDownload;
            FileTransferHeader outHeader;
            long sentid;
            LOGGER.fine("Waiting for next FT packet");
            FileTransferHeader sendheader = this.plumber.readHeader();
            if (sendheader == null) {
                LOGGER.info("Couldn't read FT header");
                break;
            }
            assert (sendheader.getHeaderType() == 257);
            long desiredChecksum = sendheader.getChecksum();
            if (rvtransfer.getRvSessionInfo().getInitiator() == Initiator.ME && (sentid = sendheader.getIcbmMessageId()) != icbmId) {
                LOGGER.info("Other end sent " + sentid + " but we're looking for " + icbmId);
                break;
            }
            this.setConnected();
            SegmentedFilename segName = sendheader.getFilename();
            TransferredFile destFile = this.plumber.getNativeFile(segName, sendheader.getMacFileInfo());
            files.add(destFile);
            boolean attemptResume = this.plumber.shouldAttemptResume(destFile);
            FileChannel fileChannel = destFile.getChannel();
            if (attemptResume) {
                outHeader = new FileTransferHeader(sendheader);
                outHeader.setHeaderType(517);
                outHeader.setIcbmMessageId(icbmId);
                long len = destFile.getSize();
                outHeader.setBytesReceived(len);
                Checksummer summer = this.plumber.getChecksummer(destFile, len);
                eventpost.fireEvent(new ChecksummingEvent(destFile, summer));
                outHeader.setReceivedChecksum(summer.compute());
                outHeader.setCompression(0);
                outHeader.setEncryption(0);
                this.plumber.sendHeader(outHeader);
                FileTransferHeader resumeResponse = this.plumber.readHeader();
                if (resumeResponse == null) {
                    LOGGER.info("Didn't receive resume response; connection closed");
                    break;
                }
                assert (resumeResponse.getHeaderType() == 262) : resumeResponse.getHeaderType();
                long bytesReceived = resumeResponse.getBytesReceived();
                assert (bytesReceived <= len) : "sender is trying to trick us: " + bytesReceived + " > " + len;
                if (bytesReceived != len) {
                    eventpost.fireEvent(new ResumeChecksumFailedEvent(destFile));
                }
                fileChannel.position(bytesReceived);
                fileChannel.truncate(bytesReceived);
                toDownload = resumeResponse.getFileSize() - bytesReceived;
                FileTransferHeader finalResponse = new FileTransferHeader(resumeResponse);
                finalResponse.setHeaderType(519);
                this.plumber.sendHeader(finalResponse);
            } else {
                outHeader = new FileTransferHeader(sendheader);
                outHeader.setIcbmMessageId(icbmId);
                fileChannel.truncate(0L);
                outHeader.setHeaderType(514);
                outHeader.setBytesReceived(0L);
                outHeader.setReceivedChecksum(0L);
                outHeader.setCompression(0);
                outHeader.setEncryption(0);
                outHeader.setFlags(0);
                this.plumber.sendHeader(outHeader);
                toDownload = sendheader.getFileSize();
            }
            long startedAt = fileChannel.position();
            Transferrer receiver = this.plumber.createTransferrer(destFile, startedAt, toDownload);
            TransferredFileInfo info = new TransferredFileInfo(destFile, startedAt + toDownload, startedAt);
            eventpost.fireEvent(new TransferringFileEvent(info, receiver));
            long downloaded = receiver.transfer();
            if (downloaded != toDownload) {
                LOGGER.fine("Didn't download correct number of bytes: downloaded " + downloaded + ", wanted " + toDownload);
                break;
            }
            long sumLength = startedAt + downloaded;
            Checksummer summer = this.plumber.getChecksummer(destFile, sumLength);
            eventpost.fireEvent(new ChecksummingEvent(destFile, summer));
            long calculatedSum = summer.compute();
            destFile.close();
            boolean bl = failed = calculatedSum != desiredChecksum;
            if (!failed) {
                eventpost.fireEvent(new FileCompleteEvent(info));
            }
            try {
                doneHeader = new FileTransferHeader(sendheader);
                doneHeader.setHeaderType(516);
                doneHeader.setFlags(doneHeader.getFlags() | 1);
                doneHeader.setIcbmMessageId(icbmId);
                doneHeader.setFilesLeft(doneHeader.getFilesLeft() - 1);
                if (doneHeader.getFilesLeft() == 0) {
                    doneHeader.setPartsLeft(doneHeader.getPartsLeft() - 1);
                }
                doneHeader.setBytesReceived(startedAt + downloaded);
                doneHeader.setReceivedChecksum(calculatedSum);
                this.plumber.sendHeader(doneHeader);
            }
            finally {
                if (failed) {
                    this.fireFailed(new CorruptTransferEvent(info));
                    stop = true;
                }
            }
            int filesLeft = doneHeader.getFilesLeft();
            int partsLeft = doneHeader.getPartsLeft();
            if (filesLeft == 0 && partsLeft == 0) {
                finished = true;
                break;
            }
            LOGGER.info("Waiting for " + filesLeft + " files and " + partsLeft + " parts");
        }
        if (finished) {
            this.fireSucceeded(new TransferSucceededInfo(files));
        } else {
            this.fireFailed(new UnknownErrorEvent());
        }
    }
}

