/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.proxy;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapStore;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.proxy.MapProxySupport;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.ValidationUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class MapProxyImpl<K, V>
extends MapProxySupport
implements IMap<K, V>,
InitializingObject {
    public MapProxyImpl(String name, MapService mapService, NodeEngine nodeEngine) {
        super(name, mapService, nodeEngine);
    }

    @Override
    public V get(Object k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        return (V)this.toObject(this.getInternal(key));
    }

    @Override
    public V put(K k, V v) {
        return this.put(k, v, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V put(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        Data result = this.putInternal(key, value, ttl, timeunit);
        return (V)this.toObject(result);
    }

    @Override
    public boolean tryPut(K k, V v, long timeout, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        return this.tryPutInternal(key, value, timeout, timeunit);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.putIfAbsent(k, v, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V putIfAbsent(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        Data result = this.putIfAbsentInternal(key, value, ttl, timeunit);
        return (V)this.toObject(result);
    }

    @Override
    public void putTransient(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        this.putTransientInternal(key, value, ttl, timeunit);
    }

    @Override
    public boolean replace(K k, V o, V v) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (o == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        Data oldValue = this.toData(o);
        Data value = this.toData(v);
        return this.replaceInternal(key, oldValue, value);
    }

    @Override
    public V replace(K k, V v) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        return (V)this.toObject(this.replaceInternal(key, value));
    }

    @Override
    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void set(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        this.setInternal(key, value, ttl, timeunit);
    }

    @Override
    public V remove(Object k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        Data result = this.removeInternal(key);
        return (V)this.toObject(result);
    }

    @Override
    public boolean remove(Object k, Object v) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        Data value = this.toData(v);
        return this.removeInternal(key, value);
    }

    @Override
    public void delete(Object k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        this.deleteInternal(key);
    }

    @Override
    public boolean containsKey(Object k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        return this.containsKeyInternal(key);
    }

    @Override
    public boolean containsValue(Object v) {
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data value = this.toData(v);
        return this.containsValueInternal(value);
    }

    @Override
    public void lock(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = this.toData(key, this.partitionStrategy);
        this.lockSupport.lock(nodeEngine, k);
    }

    @Override
    public void lock(Object key, long leaseTime, TimeUnit timeUnit) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        ValidationUtil.shouldBePositive(leaseTime, "leaseTime");
        Data k = this.toData(key, this.partitionStrategy);
        this.lockSupport.lock(this.getNodeEngine(), k, timeUnit.toMillis(leaseTime));
    }

    @Override
    public void unlock(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = this.toData(key, this.partitionStrategy);
        this.lockSupport.unlock(nodeEngine, k);
    }

    @Override
    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data k = this.toData(key, this.partitionStrategy);
        return this.tryRemoveInternal(k, timeout, timeunit);
    }

    @Override
    public Future<V> getAsync(K k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        NodeEngine nodeEngine = this.getNodeEngine();
        return new DelegatingFuture(this.getAsyncInternal(key), nodeEngine.getSerializationService());
    }

    @Override
    public boolean isLocked(K k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = this.toData(k, this.partitionStrategy);
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.lockSupport.isLocked(nodeEngine, key);
    }

    @Override
    public Future putAsync(K key, V value) {
        return this.putAsync((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS);
    }

    public ICompletableFuture putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (value == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data k = this.toData(key, this.partitionStrategy);
        Data v = this.toData(value);
        return new DelegatingFuture(this.putAsyncInternal(k, v, ttl, timeunit), this.getNodeEngine().getSerializationService());
    }

    public ICompletableFuture removeAsync(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data k = this.toData(key, this.partitionStrategy);
        return new DelegatingFuture(this.removeAsyncInternal(k), this.getNodeEngine().getSerializationService());
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        HashSet<Data> ks = new HashSet<Data>(keys.size());
        for (K key : keys) {
            if (key == null) {
                throw new NullPointerException("Null key is not allowed!");
            }
            Data k = this.toData(key, this.partitionStrategy);
            ks.add(k);
        }
        return this.getAllObjectInternal(ks);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAllInternal(m);
    }

    @Override
    public boolean tryLock(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = this.toData(key, this.partitionStrategy);
        return this.lockSupport.tryLock(nodeEngine, k);
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = this.toData(key, this.partitionStrategy);
        return this.lockSupport.tryLock(nodeEngine, k, time, timeunit);
    }

    @Override
    public void forceUnlock(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = this.toData(key, this.partitionStrategy);
        this.lockSupport.forceUnlock(nodeEngine, k);
    }

    @Override
    public String addInterceptor(MapInterceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("Interceptor should not be null!");
        }
        return this.addMapInterceptorInternal(interceptor);
    }

    @Override
    public void removeInterceptor(String id) {
        if (id == null) {
            throw new NullPointerException("Interceptor id should not be null!");
        }
        this.removeMapInterceptorInternal(id);
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.addLocalEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        Data keyData = this.toData(key, this.partitionStrategy);
        return this.addLocalEntryListenerInternal(listener, predicate, keyData, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        return this.addEntryListenerInternal(listener, null, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        return this.addEntryListenerInternal(listener, this.toData(key, this.partitionStrategy), includeValue);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.addEntryListenerInternal(listener, predicate, this.toData(key, this.partitionStrategy), includeValue);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.addEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public boolean removeEntryListener(String id) {
        if (id == null) {
            throw new NullPointerException("Listener id should not be null!");
        }
        return this.removeEntryListenerInternal(id);
    }

    @Override
    public EntryView<K, V> getEntryView(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        SimpleEntryView entryViewInternal = (SimpleEntryView)this.getEntryViewInternal(this.toData(key, this.partitionStrategy));
        if (entryViewInternal == null) {
            return null;
        }
        Data value = (Data)entryViewInternal.getValue();
        entryViewInternal.setKey(key);
        entryViewInternal.setValue(this.toObject(value));
        return entryViewInternal;
    }

    @Override
    public boolean evict(Object key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        return this.evictInternal(this.toData(key, this.partitionStrategy));
    }

    @Override
    public void evictAll() {
        this.evictAllInternal();
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        MapStore store = this.getMapStore();
        if (store == null) {
            throw new NullPointerException("First you should configure a map store");
        }
        Set keys = store.loadAllKeys();
        if (keys == null || keys.isEmpty()) {
            return;
        }
        this.loadAll(keys, replaceExistingValues);
    }

    @Override
    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        if (this.getMapStore() == null) {
            throw new NullPointerException("First you should configure a map store");
        }
        if (keys == null) {
            throw new NullPointerException("Parameter keys should not be null.");
        }
        if (keys.isEmpty()) {
            return;
        }
        List<Data> dataKeys = this.convertKeysToData(keys);
        this.loadAllInternal(dataKeys, replaceExistingValues);
    }

    @Override
    public void clear() {
        this.clearInternal();
    }

    public void clearMapOnly() {
        this.clearInternal();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet(TruePredicate.INSTANCE);
    }

    @Override
    public Collection<V> values() {
        return this.values(TruePredicate.INSTANCE);
    }

    @Override
    public Set entrySet() {
        return this.entrySet(TruePredicate.INSTANCE);
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.query(predicate, IterationType.KEY, false);
    }

    @Override
    public Set entrySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.query(predicate, IterationType.ENTRY, false);
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.query(predicate, IterationType.VALUE, false);
    }

    @Override
    public Set<K> localKeySet() {
        return this.localKeySet(TruePredicate.INSTANCE);
    }

    @Override
    public Set<K> localKeySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.queryLocal(predicate, IterationType.KEY, false);
    }

    @Override
    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data result = this.executeOnKeyInternal(this.toData(key, this.partitionStrategy), entryProcessor);
        return this.toObject(result);
    }

    @Override
    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        if (keys == null || keys.size() == 0) {
            throw new NullPointerException("Null key is not allowed!");
        }
        HashSet<Data> dataKeys = new HashSet<Data>(keys.size());
        for (K key : keys) {
            dataKeys.add(this.toData(key, this.partitionStrategy));
        }
        return this.executeOnKeysInternal(dataKeys, entryProcessor);
    }

    @Override
    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data keyData = this.toData(key, this.partitionStrategy);
        this.executeOnKeyInternal(keyData, entryProcessor, callback);
    }

    @Override
    public ICompletableFuture submitToKey(K key, EntryProcessor entryProcessor) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data keyData = this.toData(key, this.partitionStrategy);
        ICompletableFuture f = this.executeOnKeyInternal(keyData, entryProcessor, null);
        return new DelegatingFuture(f, service.getMapServiceContext().getNodeEngine().getSerializationService());
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getNodeEngine().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-map-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            ValidationUtil.isNotNull(jobTracker, "jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMap(this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator<Map.Entry, Result> collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory == null ? mappingJob.reducer(reducerFactory) : mappingJob.combiner(combinerFactory).reducer(reducerFactory);
            JobCompletableFuture<Result> future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    protected Object invoke(Operation operation, int partitionId) throws Throwable {
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
        Object response = f.get();
        Object returnObj = this.toObject(response);
        if (returnObj instanceof Throwable) {
            throw (Throwable)returnObj;
        }
        return returnObj;
    }

    private <K> List<Data> convertKeysToData(Set<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys.size());
        for (K key : keys) {
            if (key == null) {
                throw new NullPointerException("Null key is not allowed");
            }
            Data dataKey = this.toData(key);
            dataKeys.add(dataKey);
        }
        return dataKeys;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IMap");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

