/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.ArrayList;
import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessor;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacRequestSentEvent;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnacRequest {
    public static final ConnProcessor.ErrorType ERRTYPE_SNAC_RESPONSE_LISTENER = new ConnProcessor.ErrorType("ERRTYPE_SNAC_RESPONSE_LISTENER");
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.snac");
    private final SnacCommand command;
    private List<SnacRequestListener> listeners = null;
    private final Object listenerEventLock = new Object();
    private List<SnacResponseEvent> responses = null;
    private long sentAt = -1L;
    private long reqid = -1L;
    private boolean storingResponses = false;

    public SnacRequest(SnacCommand command, SnacRequestListener listener) {
        DefensiveTools.checkNull((Object)command, (String)"command");
        this.command = command;
        if (listener != null) {
            this.addListener(listener);
        }
    }

    final void setReqid(long requestID) {
        this.reqid = requestID;
    }

    final long getReqid() {
        return this.reqid;
    }

    public final synchronized void addListener(SnacRequestListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        if (this.listeners == null) {
            this.listeners = new ArrayList<SnacRequestListener>(4);
        }
        this.listeners.add(l);
    }

    public final synchronized void removeListener(SnacRequestListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public final synchronized boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public final SnacCommand getCommand() {
        return this.command;
    }

    public boolean isStoringResponses() {
        return this.storingResponses;
    }

    public void setStoringResponses(boolean storingResponses) {
        this.storingResponses = storingResponses;
    }

    public final synchronized long getSentTime() {
        return this.sentAt;
    }

    public final synchronized List<SnacResponseEvent> getResponses() {
        List<SnacResponseEvent> responses = this.responses;
        if (responses == null || responses.isEmpty()) {
            return DefensiveTools.emptyList();
        }
        return DefensiveTools.getUnmodifiableCopy(responses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sent(SnacRequestSentEvent event) {
        boolean logFiner = logger.logFinerEnabled();
        if (logFiner) {
            logger.logFiner("Snac request sent: " + this);
        }
        SnacRequest snacRequest = this;
        synchronized (snacRequest) {
            this.sentAt = event.getSentTime();
        }
        List<SnacRequestListener> listeners = this.getListenersCopy();
        if (listeners != null) {
            Object object = this.listenerEventLock;
            synchronized (object) {
                for (SnacRequestListener listener : listeners) {
                    if (logFiner) {
                        logger.logFiner("Running response listener " + listener);
                    }
                    try {
                        listener.handleSent(event);
                    }
                    catch (Throwable t) {
                        event.getFlapProcessor().handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, t, listener);
                    }
                }
            }
        }
        if (logFiner) {
            logger.logFiner("Finished processing Snac request send");
        }
    }

    @Nullable
    private synchronized List<SnacRequestListener> getListenersCopy() {
        List<SnacRequestListener> listeners = this.listeners;
        if (listeners != null && listeners.isEmpty()) {
            listeners = null;
        }
        if (listeners == null) {
            return null;
        }
        return new ArrayList<SnacRequestListener>(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void gotResponse(SnacResponseEvent event) {
        boolean logFiner = logger.logFinerEnabled();
        if (logFiner) {
            logger.logFiner("Processing response " + event.getSnacPacket() + " to Snac request " + this);
        }
        SnacRequest snacRequest = this;
        synchronized (snacRequest) {
            if (this.storingResponses) {
                if (this.responses == null) {
                    this.responses = new ArrayList<SnacResponseEvent>(5);
                }
                this.responses.add(event);
            }
        }
        List<SnacRequestListener> listeners = this.getListenersCopy();
        if (listeners != null) {
            Object object = this.listenerEventLock;
            synchronized (object) {
                for (SnacRequestListener listener : listeners) {
                    if (logFiner) {
                        logger.logFiner("Running response listener " + listener);
                    }
                    try {
                        listener.handleResponse(event);
                    }
                    catch (Throwable t) {
                        event.getFlapProcessor().handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, t, listener);
                    }
                }
            }
        }
        if (logFiner) {
            logger.logFiner("Finished handling response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void timedOut(SnacRequestTimeoutEvent event) {
        List<SnacRequestListener> listeners;
        boolean logFiner = logger.logFinerEnabled();
        if (logFiner) {
            logger.logFiner("Snac request " + this + " timed out");
        }
        if ((listeners = this.getListenersCopy()) != null) {
            Object object = this.listenerEventLock;
            synchronized (object) {
                for (SnacRequestListener listener : listeners) {
                    if (logFiner) {
                        logger.logFiner("Running response listener " + listener + " for request timeout");
                    }
                    try {
                        listener.handleTimeout(event);
                    }
                    catch (Throwable t) {
                        event.getFlapProcessor().handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, t, listener);
                    }
                }
            }
        }
        if (logFiner) {
            logger.logFiner("Finished handling Snac request timeout");
        }
    }

    public synchronized String toString() {
        return "SnacRequest for " + this.command + ": listeners: " + this.listeners + ", responses: " + this.responses;
    }
}

