/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import net.sf.cindy.Message;
import net.sf.cindy.Session;
import net.sf.cindy.SessionAdapter;
import net.sf.cindy.SessionListener;
import net.sf.cindy.impl.ChannelSession;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.impl.SecureSocketSession;
import net.sf.cindy.impl.SocketSession;

public abstract class ServerSocketSession
extends ChannelSession {
    private SocketAddress socketAddress;
    private ServerSocketChannel channel;
    private final Set sessions = new HashSet();
    private boolean closeAllSocketSessions;
    private SSLContext sslc;
    private final SessionListener listener = new SessionAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionClosed(Session session) {
            session.removeSessionListener(this);
            Set set = ServerSocketSession.this.sessions;
            synchronized (set) {
                ServerSocketSession.this.sessions.remove(session);
            }
        }
    };

    public void setSSLContext(SSLContext sSLContext) {
        this.sslc = sSLContext;
    }

    public SSLContext getSSLContext() {
        return this.sslc;
    }

    public void setCloseAllSocketSessions(boolean bl) {
        this.closeAllSocketSessions = bl;
    }

    public boolean isCloseAllSocketSessions() {
        return this.closeAllSocketSessions;
    }

    public void setListenPort(int n) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set listen port after session started");
        }
        this.socketAddress = new InetSocketAddress(n);
    }

    public void setListenAddress(SocketAddress socketAddress) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set listen address after session started");
        }
        this.socketAddress = socketAddress;
    }

    public void setChannel(ServerSocketChannel serverSocketChannel) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set server socket channel after session started");
        }
        this.channel = serverSocketChannel;
    }

    public ServerSocketChannel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketSession[] getConnectedSessions() {
        Set set = this.sessions;
        synchronized (set) {
            SocketSession[] socketSessionArray = new SocketSession[this.sessions.size()];
            this.sessions.toArray(socketSessionArray);
            return socketSessionArray;
        }
    }

    public synchronized void start(boolean bl) throws IllegalStateException {
        if (this.isStarted()) {
            return;
        }
        if (this.channel == null) {
            try {
                this.channel = ServerSocketChannel.open();
                this.channel.socket().bind(this.socketAddress == null ? new InetSocketAddress(0) : this.socketAddress);
            }
            catch (IOException iOException) {
                this.dispatchException(iOException);
                if (this.channel != null) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.channel = null;
                }
                this.dispatchSessionClosed();
                return;
            }
        }
        this.startSession(this.channel, this.channel, bl);
    }

    public void onEvent(Object object, Object object2) {
        if (object == Constants.EV_ACCEPTABLE) {
            this.onAcceptable();
        }
        super.onEvent(object, object2);
    }

    protected void onRegister(Selector selector) {
        try {
            this.channel.register(selector, 16, this);
            super.onRegister(selector);
            this.dispatchSessionEstablished();
        }
        catch (ClosedChannelException closedChannelException) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUnregister() {
        Object object;
        if (this.closeAllSocketSessions) {
            object = this.getConnectedSessions();
            for (int i = 0; i < ((SocketSession[])object).length; ++i) {
                object[i].close();
            }
        }
        object = this.sessions;
        synchronized (object) {
            this.sessions.clear();
        }
        this.channel = null;
        super.onUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAcceptable() {
        block7: {
            try {
                SocketChannel socketChannel = this.getChannel().accept();
                SocketSession socketSession = this.buildSession(socketChannel.socket().getRemoteSocketAddress());
                if (socketSession != null) {
                    Object object;
                    if (socketSession instanceof SecureSocketSession) {
                        object = (SecureSocketSession)socketSession;
                        this.initSecureSocketSession((SecureSocketSession)object);
                    }
                    socketSession.setChannel(socketChannel);
                    socketSession.addSessionListener(this.listener);
                    object = this.sessions;
                    synchronized (object) {
                        this.sessions.add(socketSession);
                    }
                    socketSession.start();
                    break block7;
                }
                socketChannel.socket().setSoLinger(true, 0);
                socketChannel.close();
            }
            catch (IOException iOException) {
                this.dispatchException(iOException);
            }
        }
    }

    protected void initSecureSocketSession(SecureSocketSession secureSocketSession) {
        if (this.sslc != null) {
            secureSocketSession.setSSLContext(this.sslc);
        }
        secureSocketSession.setUseClientMode(false);
    }

    public void write(Message message) {
        throw new UnsupportedOperationException("can't write message to ServerSocketSession");
    }

    public boolean blockWrite(Message message) {
        throw new UnsupportedOperationException("can't write message to ServerSocketSession");
    }

    protected abstract SocketSession buildSession(SocketAddress var1);
}

