/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import net.sf.cindy.Message;
import net.sf.cindy.PacketMessage;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.impl.PacketChannelSession;
import net.sf.cindy.spi.EventGeneratorSpi;
import net.sf.cindy.spi.SessionStatisticSpi;
import net.sf.cindy.util.ByteBufferUtils;

public class DatagramSession
extends PacketChannelSession {
    private DatagramChannel channel;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;

    public void setLocalAddress(SocketAddress socketAddress) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set local address after session started");
        }
        this.localAddress = socketAddress;
    }

    public void setRemoteAddress(SocketAddress socketAddress) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set remote address after session started");
        }
        this.remoteAddress = socketAddress;
    }

    public void setChannel(DatagramChannel datagramChannel) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set datagram channel after session started");
        }
        this.channel = datagramChannel;
    }

    public DatagramChannel getChannel() {
        return this.channel;
    }

    public synchronized void start(boolean bl) throws IllegalStateException {
        if (this.isStarted()) {
            return;
        }
        if (this.channel == null) {
            try {
                this.channel = DatagramChannel.open();
                this.channel.socket().bind(this.localAddress);
                if (this.remoteAddress != null) {
                    this.channel.connect(this.remoteAddress);
                }
            }
            catch (IOException iOException) {
                this.dispatchException(iOException);
                if (this.channel != null) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.channel = null;
                }
                this.dispatchSessionClosed();
                return;
            }
        }
        this.startSession(this.channel, this.channel, bl);
    }

    public boolean isConnected() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isConnected();
    }

    protected void onRegister(Selector selector) {
        try {
            this.channel.register(selector, 1, this);
            super.onRegister(selector);
            this.dispatchSessionEstablished();
        }
        catch (ClosedChannelException closedChannelException) {
            this.close();
        }
    }

    protected void onUnregister() {
        this.channel = null;
        super.onUnregister();
    }

    protected void readFromChannel(SelectableChannel selectableChannel) throws IOException {
        while ((this.lastSocketAddress = ((DatagramChannel)selectableChannel).receive(this.readBuffer)) != null) {
            Message message;
            this.readBuffer.flip();
            if (this.getStatistic() != null) {
                ((SessionStatisticSpi)this.getStatistic()).received(this.readBuffer.remaining());
            }
            if ((message = this.recognizeMessage(this.readBuffer)) != null) {
                this.dispatchMessageReceived(message);
            }
            this.readBuffer.clear();
        }
        ((EventGeneratorSpi)this.getEventGenerator()).register(this, Constants.EV_ENABLE_READ);
    }

    protected final Object transMessage(Message message) throws IllegalArgumentException {
        if (!this.canWriteToQueue(message)) {
            throw new IllegalArgumentException("can't send message without socket address");
        }
        return super.transMessage(message);
    }

    private boolean canWriteToQueue(Message message) {
        if (this.isConnected()) {
            return true;
        }
        return message instanceof PacketMessage && ((PacketMessage)message).getSocketAddress() != null;
    }

    protected Message writeToChannel(SelectableChannel selectableChannel, Object object) throws IOException {
        Message message = (Message)object;
        ByteBuffer[] byteBufferArray = message.toByteBuffer();
        if (ByteBufferUtils.hasRemaining(byteBufferArray)) {
            long l = 0L;
            if (this.isConnected()) {
                l = this.getChannel().write(byteBufferArray);
            } else {
                SocketAddress socketAddress = ((PacketMessage)message).getSocketAddress();
                ByteBuffer byteBuffer = byteBufferArray.length == 1 ? byteBufferArray[0] : ByteBufferUtils.gather(byteBufferArray);
                l = this.getChannel().send(byteBuffer, socketAddress);
            }
            if (this.getStatistic() != null) {
                ((SessionStatisticSpi)this.getStatistic()).sent(l);
            }
            if (l == 0L) {
                return null;
            }
        }
        return message;
    }
}

