/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.ratelim.ConnectionQueueMgr;
import net.kano.joscar.ratelim.RateClassMonitor;
import net.kano.joscar.ratelim.RateLimitingQueueMgr;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacRequest;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateQueue {
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.ratelim");
    private final ConnectionQueueMgr parentMgr;
    private final LinkedList<SnacRequest> queue = new LinkedList();
    private final RateClassMonitor rateMonitor;

    RateQueue(ConnectionQueueMgr parentMgr, RateClassMonitor monitor) {
        DefensiveTools.checkNull((Object)parentMgr, (String)"parentMgr");
        DefensiveTools.checkNull((Object)monitor, (String)"monitor");
        this.parentMgr = parentMgr;
        this.rateMonitor = monitor;
    }

    public ConnectionQueueMgr getParentMgr() {
        return this.parentMgr;
    }

    public RateClassMonitor getRateClassMonitor() {
        return this.rateMonitor;
    }

    public synchronized int getQueueSize() {
        return this.queue.size();
    }

    public synchronized boolean hasRequests() {
        return !this.queue.isEmpty();
    }

    synchronized void enqueue(SnacRequest req) {
        DefensiveTools.checkNull((Object)req, (String)"req");
        if (logger.logFineEnabled()) {
            logger.logFine("Enqueuing " + req.getCommand() + " within ratequeue " + "(class " + this.rateMonitor.getRateInfo().getRateClass() + ")...");
        }
        this.queue.add(req);
    }

    @Nullable
    synchronized SnacRequest dequeue() {
        if (this.queue.isEmpty()) {
            return null;
        }
        SnacRequest request = this.queue.removeFirst();
        if (logger.logFineEnabled()) {
            logger.logFine("Dequeueing " + request.getCommand() + " from ratequeue (class " + this.rateMonitor.getRateInfo().getRateClass() + ")...");
        }
        return request;
    }

    synchronized void dequeueAll(Collection<? super SnacRequest> dest) {
        dest.addAll(this.queue);
        this.queue.clear();
    }

    synchronized void clear() {
        this.queue.clear();
    }

    public String toString() {
        return "RateQueue: rateMonitor=" + this.rateMonitor + ", queued: " + this.queue.size();
    }

    public boolean isOpen() {
        return this.hasRequests() && !this.getParentMgr().isPaused();
    }

    public boolean isReady() {
        return this.getOptimalWaitTime() <= 0L;
    }

    public long getOptimalWaitTime() {
        return this.getRateClassMonitor().getOptimalWaitTime();
    }

    public synchronized boolean sendAndDequeueReadyRequestsIfPossible() {
        if (!this.isOpen()) {
            return true;
        }
        if (this.isReady()) {
            this.sendAndDequeueReadyRequests();
        }
        return !this.hasRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndDequeueReadyRequests() {
        ArrayList<SnacRequest> requests;
        RateQueue rateQueue = this;
        synchronized (rateQueue) {
            int possibleCmdCount = this.getRateClassMonitor().getPossibleCmdCount();
            if (possibleCmdCount == 0) {
                possibleCmdCount = 1;
            }
            requests = new ArrayList<SnacRequest>(this.queue.size());
            for (int i = 0; this.hasRequests() && this.isReady() && i < possibleCmdCount; ++i) {
                requests.add(this.dequeue());
            }
        }
        logger.logFine("sendAndDequeueReadyRequests(): " + this.toString() + " will attempt to send " + requests.size());
        ConnectionQueueMgr connMgr = this.getParentMgr();
        RateLimitingQueueMgr rateMgr = connMgr.getParentQueueMgr();
        ClientSnacProcessor processor = connMgr.getSnacProcessor();
        while (!requests.isEmpty() && this.isReady()) {
            rateMgr.sendSnac(processor, (SnacRequest)requests.get(0));
            requests.remove(0);
            this.getRateClassMonitor().updateRate(System.currentTimeMillis());
        }
        if (!requests.isEmpty()) {
            logger.logFine("re-enqueuing " + requests.size() + " SnacRequests for " + this.toString());
            RateQueue rateQueue2 = this;
            synchronized (rateQueue2) {
                this.queue.addAll(0, requests);
            }
        }
    }
}

