/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import net.sf.jml.MsnMessageChain;
import net.sf.jml.MsnMessageIterator;
import net.sf.jml.protocol.MsnMessage;

public class MsnMessageChainImpl
implements MsnMessageChain {
    private static final int DEFAULT_FIXED_SIZE = 20;
    private final MsnMessage[] messages;
    private final int fixedSize;
    private int pos;

    public MsnMessageChainImpl() {
        this(20);
    }

    public MsnMessageChainImpl(int n) {
        this.fixedSize = n;
        this.messages = new MsnMessage[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMsnMessage(MsnMessage msnMessage) {
        if (msnMessage == null) return;
        MsnMessage[] msnMessageArray = this.messages;
        synchronized (this.messages) {
            this.messages[this.pos++] = msnMessage;
            if (this.pos < this.fixedSize) return;
            this.pos = 0;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public MsnMessageIterator iterator() {
        return new MsnMessageIteratorImpl();
    }

    private class MsnMessageIteratorImpl
    implements MsnMessageIterator {
        private MsnMessage[] msgs;
        private int position;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MsnMessageIteratorImpl() {
            this.msgs = new MsnMessage[MsnMessageChainImpl.this.fixedSize];
            this.position = MsnMessageChainImpl.this.fixedSize;
            MsnMessage[] msnMessageArray = MsnMessageChainImpl.this.messages;
            synchronized (msnMessageArray) {
                System.arraycopy(MsnMessageChainImpl.this.messages, MsnMessageChainImpl.this.pos, this.msgs, 0, MsnMessageChainImpl.this.fixedSize - MsnMessageChainImpl.this.pos);
                System.arraycopy(MsnMessageChainImpl.this.messages, 0, this.msgs, MsnMessageChainImpl.this.fixedSize - MsnMessageChainImpl.this.pos, MsnMessageChainImpl.this.pos);
            }
        }

        public boolean hasPrevious() {
            return this.position != 0 && this.msgs[this.position - 1] != null;
        }

        public MsnMessage previous() {
            return this.msgs[--this.position];
        }
    }
}

