/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joustsim.MultipleExceptionsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTools {
    private static final Logger LOGGER = Logger.getLogger(JavaTools.class.getName());

    private JavaTools() {
    }

    public static void throwExceptions(List<Exception> list, String string) {
        if (list.size() == 1) {
            Exception exception = list.get(0);
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IllegalStateException(exception);
        }
        if (!list.isEmpty()) {
            for (Exception exception : list) {
                LOGGER.log(Level.WARNING, string, exception);
            }
            throw new MultipleExceptionsException(list);
        }
    }

    public static <L> L getDelegatingProxy(final Collection<? extends L> collection, Class<? extends L> clazz) {
        return JavaTools.cast(clazz, Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (!method.getReturnType().equals(Void.TYPE)) {
                    throw new IllegalArgumentException("I can't delegate call to " + method + ": it has non-void return " + "type");
                }
                for (Object e : collection) {
                    method.invoke(e, objectArray);
                }
                return null;
            }
        }));
    }

    public static <E> E cast(Class<E> clazz, Object object) {
        return (E)object;
    }
}

