/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;

public abstract class RvProxyCmd {
    private final int packetVersion;
    private final int commandType;
    private final int flags;

    protected RvProxyCmd(RvProxyPacket packet) {
        this(packet.getPacketVersion(), packet.getCommandType(), packet.getFlags());
    }

    protected RvProxyCmd(int cmdType) {
        this(cmdType, 0);
    }

    protected RvProxyCmd(int cmdType, int flags) {
        this(1098, cmdType, flags);
    }

    protected RvProxyCmd(int packetVersion, int cmdType, int flags) {
        DefensiveTools.checkRange((int)packetVersion, (String)"packetVersion", (int)0);
        DefensiveTools.checkRange((int)cmdType, (String)"cmdType", (int)0);
        DefensiveTools.checkRange((int)flags, (String)"flags", (int)0);
        this.packetVersion = packetVersion;
        this.commandType = cmdType;
        this.flags = flags;
    }

    public final int getPacketVersion() {
        return this.packetVersion;
    }

    public final int getCommandType() {
        return this.commandType;
    }

    public final int getFlags() {
        return this.flags;
    }

    public abstract void writeCommandData(OutputStream var1) throws IOException;
}

