/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;
import org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import org.apache.tools.ant.taskdefs.cvslib.ChangeLogParser;
import org.apache.tools.ant.taskdefs.cvslib.CvsUser;
import org.apache.tools.ant.taskdefs.cvslib.CvsVersion;
import org.apache.tools.ant.taskdefs.cvslib.RedirectingStreamHandler;
import org.apache.tools.ant.types.FileSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChangeLogTask
extends AbstractCvsTask {
    private File m_usersFile;
    private Vector m_cvsUsers;
    private File m_dir;
    private File m_destfile;
    private Date m_start;
    private Date m_stop;
    private final Vector m_filesets;

    public void setDir(File dir) {
        this.m_dir = dir;
    }

    public void setDestfile(File destfile) {
        this.m_destfile = destfile;
    }

    public void setUsersfile(File usersFile) {
        this.m_usersFile = usersFile;
    }

    public void addUser(CvsUser user) {
        this.m_cvsUsers.addElement(user);
    }

    public void setStart(Date start) {
        this.m_start = start;
    }

    public void setEnd(Date stop) {
        this.m_stop = stop;
    }

    public void setDaysinpast(int days) {
        long time = System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L;
        this.setStart(new Date(time));
    }

    public void addFileset(FileSet fileSet) {
        this.m_filesets.addElement(fileSet);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        File savedDir = this.m_dir;
        try {
            Properties userList;
            block12: {
                this.validate();
                userList = new Properties();
                this.loadUserlist(userList);
                Enumeration e = this.m_cvsUsers.elements();
                while (true) {
                    if (!e.hasMoreElements()) {
                        this.setCommand("log");
                        if (this.getTag() != null) {
                            CvsVersion myCvsVersion = new CvsVersion();
                            myCvsVersion.setProject(this.getProject());
                            myCvsVersion.setTaskName("cvsversion");
                            myCvsVersion.setCvsRoot(this.getCvsRoot());
                            myCvsVersion.setCvsRsh(this.getCvsRsh());
                            myCvsVersion.setPassfile(this.getPassFile());
                            myCvsVersion.setDest(this.m_dir);
                            myCvsVersion.execute();
                            if (myCvsVersion.supportsCvsLogWithSOption()) {
                                this.addCommandArgument("-S");
                            }
                        }
                        if (this.m_start != null) {
                            SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
                            String dateRange = ">=" + outputDate.format(this.m_start);
                            this.addCommandArgument("-d");
                            this.addCommandArgument(dateRange);
                        }
                        if (!this.m_filesets.isEmpty()) {
                            e = this.m_filesets.elements();
                            break;
                        }
                        break block12;
                    }
                    CvsUser user = (CvsUser)e.nextElement();
                    user.validate();
                    userList.put(user.getUserID(), user.getDisplayname());
                }
                while (e.hasMoreElements()) {
                    FileSet fileSet = (FileSet)e.nextElement();
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                    String[] files = scanner.getIncludedFiles();
                    int i = 0;
                    while (i < files.length) {
                        this.addCommandArgument(files[i]);
                        ++i;
                    }
                }
            }
            ChangeLogParser parser = new ChangeLogParser();
            RedirectingStreamHandler handler = new RedirectingStreamHandler(parser);
            this.log(this.getCommand(), 3);
            this.setDest(this.m_dir);
            this.setExecuteStreamHandler(handler);
            super.execute();
            String errors = handler.getErrors();
            if (errors != null) {
                this.log(errors, 0);
            }
            CVSEntry[] entrySet = parser.getEntrySetAsArray();
            CVSEntry[] filteredEntrySet = this.filterEntrySet(entrySet);
            this.replaceAuthorIdWithName(userList, filteredEntrySet);
            this.writeChangeLog(filteredEntrySet);
        }
        catch (Throwable throwable) {
            Object var3_10 = null;
            this.m_dir = savedDir;
            throw throwable;
        }
        {
            Object var3_11 = null;
            this.m_dir = savedDir;
            return;
        }
    }

    private final void validate() throws BuildException {
        if (this.m_dir == null) {
            this.m_dir = this.getProject().getBaseDir();
        }
        if (this.m_destfile == null) {
            String message = "Destfile must be set.";
            throw new BuildException("Destfile must be set.");
        }
        if (!this.m_dir.exists()) {
            String message = "Cannot find base dir " + this.m_dir.getAbsolutePath();
            throw new BuildException(message);
        }
        if (this.m_usersFile != null && !this.m_usersFile.exists()) {
            String message = "Cannot find user lookup list " + this.m_usersFile.getAbsolutePath();
            throw new BuildException(message);
        }
    }

    private final void loadUserlist(Properties userList) throws BuildException {
        if (this.m_usersFile != null) {
            try {
                userList.load(new FileInputStream(this.m_usersFile));
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
            }
        }
    }

    private final CVSEntry[] filterEntrySet(CVSEntry[] entrySet) {
        Vector<CVSEntry> results = new Vector<CVSEntry>();
        int i = 0;
        while (i < entrySet.length) {
            CVSEntry cvsEntry = entrySet[i];
            Date date = cvsEntry.getDate();
            if (!(this.m_start != null && this.m_start.after(date) || this.m_stop != null && this.m_stop.before(date))) {
                results.addElement(cvsEntry);
            }
            ++i;
        }
        Object[] resultArray = new CVSEntry[results.size()];
        results.copyInto(resultArray);
        return resultArray;
    }

    private final void replaceAuthorIdWithName(Properties userList, CVSEntry[] entrySet) {
        int i = 0;
        while (i < entrySet.length) {
            CVSEntry entry = entrySet[i];
            if (userList.containsKey(entry.getAuthor())) {
                entry.setAuthor(userList.getProperty(entry.getAuthor()));
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private final void writeChangeLog(CVSEntry[] entrySet) throws BuildException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 112->116)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final /* synthetic */ void this() {
        this.m_cvsUsers = new Vector();
        this.m_filesets = new Vector();
    }

    public ChangeLogTask() {
        this.this();
    }
}

