/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.directim;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.TlvChain;

public class DirectIMReqRvCmd
extends AbstractRequestRvCmd {
    private final RvConnectionInfo connInfo;

    public DirectIMReqRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getRvTlvs();
        this.connInfo = RvConnectionInfo.readConnectionInfo(tlvChain);
    }

    public DirectIMReqRvCmd(RvConnectionInfo rvConnectionInfo) {
        this(1, rvConnectionInfo);
    }

    public DirectIMReqRvCmd(int n, RvConnectionInfo rvConnectionInfo) {
        super(CapabilityBlock.BLOCK_DIRECTIM, n);
        this.connInfo = rvConnectionInfo;
    }

    public final RvConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    protected void writeRvTlvs(OutputStream outputStream) throws IOException {
        if (this.connInfo != null) {
            this.connInfo.write(outputStream);
        }
    }

    protected boolean hasServiceData() {
        return false;
    }

    protected void writeServiceData(OutputStream outputStream) throws IOException {
    }

    public String toString() {
        return "DirectIMReqRvCmd: " + this.connInfo;
    }
}

