/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.sf.antcontrib.antserver.Command;
import net.sf.antcontrib.antserver.Response;
import net.sf.antcontrib.antserver.commands.DisconnectCommand;
import net.sf.antcontrib.antserver.server.ConnectionBuildListener;
import net.sf.antcontrib.antserver.server.ServerTask;
import org.apache.tools.ant.BuildListener;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;

public class ConnectionHandler
implements Runnable {
    private static long nextGroupId = 0L;
    private ServerTask task;
    private Socket socket;
    private Thread thread;
    private Throwable thrown;

    public ConnectionHandler(ServerTask serverTask, Socket socket) {
        this.socket = socket;
        this.task = serverTask;
    }

    public void start() {
        long l = nextGroupId;
        nextGroupId = nextGroupId == Long.MAX_VALUE ? 0L : ++nextGroupId;
        ThreadGroup threadGroup = new ThreadGroup("server-tg-" + l);
        this.thread = new Thread(threadGroup, this);
        this.thread.start();
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            ConnectionBuildListener connectionBuildListener = null;
            inputStream = this.socket.getInputStream();
            outputStream = this.socket.getOutputStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(new Response());
            boolean bl = false;
            Command command = null;
            Response response = null;
            while (true) {
                OutputFormat outputFormat;
                block50: {
                    if (bl) {
                        return;
                    }
                    this.task.getProject().log("Reading command object.", 4);
                    command = (Command)objectInputStream.readObject();
                    this.task.getProject().log("Executing command object: " + command, 4);
                    response = new Response();
                    try {
                        try {
                            connectionBuildListener = new ConnectionBuildListener();
                            this.task.getProject().addBuildListener((BuildListener)connectionBuildListener);
                            if (command.execute(this.task.getProject(), objectInputStream)) {
                                bl = true;
                                this.task.getProject().log("Got disconnect command", 1);
                            }
                            response.setSucceeded(true);
                        }
                        catch (Throwable throwable) {
                            response.setSucceeded(false);
                            response.setThrowable(throwable);
                            outputFormat = null;
                            if (connectionBuildListener != null) {
                                this.task.getProject().removeBuildListener((BuildListener)connectionBuildListener);
                            }
                            break block50;
                        }
                        outputFormat = null;
                        if (connectionBuildListener == null) break block50;
                    }
                    catch (Throwable throwable) {
                        outputFormat = null;
                        if (connectionBuildListener == null) throw throwable;
                        this.task.getProject().removeBuildListener((BuildListener)connectionBuildListener);
                        throw throwable;
                    }
                    this.task.getProject().removeBuildListener((BuildListener)connectionBuildListener);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XMLSerializer xMLSerializer = new XMLSerializer();
                outputFormat = new OutputFormat();
                outputFormat.setOmitDocumentType(true);
                outputFormat.setOmitXMLDeclaration(false);
                xMLSerializer.setOutputFormat(outputFormat);
                xMLSerializer.setOutputByteStream((OutputStream)byteArrayOutputStream);
                xMLSerializer.serialize(connectionBuildListener.getDocument());
                response.setResultsXml(byteArrayOutputStream.toString());
                this.task.getProject().log("Executed command object: " + command, 4);
                this.task.getProject().log("Sending response: " + response, 4);
                objectOutputStream.writeObject(response);
                if (!(command instanceof DisconnectCommand)) continue;
                bl = true;
                this.task.getProject().log("Got shutdown command", 1);
                this.task.shutdown();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.thrown = classNotFoundException;
            return;
        }
        catch (IOException iOException) {
            this.thrown = iOException;
            return;
        }
        catch (Throwable throwable) {
            this.thrown = throwable;
            return;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

