/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rv.RvCommandFactory;
import net.kano.joscar.rvcmd.addins.AddinsAcceptRvCmd;
import net.kano.joscar.rvcmd.addins.AddinsRejectRvCmd;
import net.kano.joscar.rvcmd.addins.AddinsReqRvCmd;
import net.kano.joscar.rvcmd.chatinvite.ChatInvitationRvCmd;
import net.kano.joscar.rvcmd.chatinvite.ChatInviteRejectRvCmd;
import net.kano.joscar.rvcmd.directim.DirectIMAcceptRvCmd;
import net.kano.joscar.rvcmd.directim.DirectIMRejectRvCmd;
import net.kano.joscar.rvcmd.directim.DirectIMReqRvCmd;
import net.kano.joscar.rvcmd.getfile.GetFileAcceptRvCmd;
import net.kano.joscar.rvcmd.getfile.GetFileRejectRvCmd;
import net.kano.joscar.rvcmd.getfile.GetFileReqRvCmd;
import net.kano.joscar.rvcmd.icon.SendBuddyIconRvCmd;
import net.kano.joscar.rvcmd.sendbl.SendBuddyListRvCmd;
import net.kano.joscar.rvcmd.sendfile.FileSendAcceptRvCmd;
import net.kano.joscar.rvcmd.sendfile.FileSendRejectRvCmd;
import net.kano.joscar.rvcmd.sendfile.FileSendReqRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.AbstractTrillianCryptRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptAcceptRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptBeginRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptCloseRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptMsgRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptReqRvCmd;
import net.kano.joscar.rvcmd.voice.VoiceAcceptRvCmd;
import net.kano.joscar.rvcmd.voice.VoiceRejectRvCmd;
import net.kano.joscar.rvcmd.voice.VoiceReqRvCmd;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRvCommandFactory
implements RvCommandFactory {
    private static final List<CapabilityBlock> SUPPORTED_CAPS = DefensiveTools.asUnmodifiableList((Object[])new CapabilityBlock[]{CapabilityBlock.BLOCK_FILE_SEND, CapabilityBlock.BLOCK_TRILLIANCRYPT, CapabilityBlock.BLOCK_SENDBUDDYLIST, CapabilityBlock.BLOCK_CHAT, CapabilityBlock.BLOCK_DIRECTIM, CapabilityBlock.BLOCK_FILE_GET, CapabilityBlock.BLOCK_ICON, CapabilityBlock.BLOCK_ADDINS, CapabilityBlock.BLOCK_VOICE});

    @Override
    public List<CapabilityBlock> getSupportedCapabilities() {
        return SUPPORTED_CAPS;
    }

    @Override
    public RvCommand genRvCommand(RecvRvIcbm rvIcbm) {
        DefensiveTools.checkNull((Object)rvIcbm, (String)"rvIcbm");
        CapabilityBlock block = rvIcbm.getCapability();
        int rvStatus = rvIcbm.getRvStatus();
        if (block.equals(CapabilityBlock.BLOCK_FILE_SEND)) {
            if (rvStatus == 0) {
                return new FileSendReqRvCmd(rvIcbm);
            }
            if (rvStatus == 1) {
                return new FileSendRejectRvCmd(rvIcbm);
            }
            if (rvStatus == 2) {
                return new FileSendAcceptRvCmd(rvIcbm);
            }
            return null;
        }
        if (block.equals(CapabilityBlock.BLOCK_TRILLIANCRYPT)) {
            int status = AbstractTrillianCryptRvCmd.getTrillianCmdType(rvIcbm);
            if (status == 0) {
                return new TrillianCryptReqRvCmd(rvIcbm);
            }
            if (status == 1) {
                return new TrillianCryptAcceptRvCmd(rvIcbm);
            }
            if (status == 2) {
                return new TrillianCryptBeginRvCmd(rvIcbm);
            }
            if (status == 3) {
                return new TrillianCryptMsgRvCmd(rvIcbm);
            }
            if (status == 4) {
                return new TrillianCryptCloseRvCmd(rvIcbm);
            }
            return null;
        }
        if (block.equals(CapabilityBlock.BLOCK_SENDBUDDYLIST)) {
            if (rvStatus == 0) {
                return new SendBuddyListRvCmd(rvIcbm);
            }
            return null;
        }
        if (block.equals(CapabilityBlock.BLOCK_CHAT)) {
            if (rvStatus == 0) {
                return new ChatInvitationRvCmd(rvIcbm);
            }
            if (rvStatus == 1) {
                return new ChatInviteRejectRvCmd(rvIcbm);
            }
            return null;
        }
        if (block.equals(CapabilityBlock.BLOCK_DIRECTIM)) {
            if (rvStatus == 0) {
                return new DirectIMReqRvCmd(rvIcbm);
            }
            if (rvStatus == 2) {
                return new DirectIMAcceptRvCmd(rvIcbm);
            }
            if (rvStatus == 1) {
                return new DirectIMRejectRvCmd(rvIcbm);
            }
            return null;
        }
        if (block.equals(CapabilityBlock.BLOCK_FILE_GET)) {
            if (rvStatus == 0) {
                return new GetFileReqRvCmd(rvIcbm);
            }
            if (rvStatus == 2) {
                return new GetFileAcceptRvCmd(rvIcbm);
            }
            if (rvStatus == 1) {
                return new GetFileRejectRvCmd(rvIcbm);
            }
            return null;
        }
        if (block.equals(CapabilityBlock.BLOCK_ICON)) {
            if (rvStatus == 0) {
                return new SendBuddyIconRvCmd(rvIcbm);
            }
            return null;
        }
        if (block.equals(CapabilityBlock.BLOCK_ADDINS)) {
            if (rvStatus == 0) {
                return new AddinsReqRvCmd(rvIcbm);
            }
            if (rvStatus == 2) {
                return new AddinsAcceptRvCmd(rvIcbm);
            }
            if (rvStatus == 1) {
                return new AddinsRejectRvCmd(rvIcbm);
            }
            return null;
        }
        if (block.equals(CapabilityBlock.BLOCK_VOICE)) {
            if (rvStatus == 0) {
                return new VoiceReqRvCmd(rvIcbm);
            }
            if (rvStatus == 2) {
                return new VoiceAcceptRvCmd(rvIcbm);
            }
            if (rvStatus == 1) {
                return new VoiceRejectRvCmd(rvIcbm);
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return "DefaultRvCommandFactory";
    }
}

