/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.ilbc;

import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.ilbc.ilbc_encoder;
import org.jitsi.service.neomedia.codec.Constants;

public class JavaEncoder
extends AbstractCodec2 {
    private ilbc_encoder enc;
    private int inputLength;
    private int outputLength;
    private byte[] prevInput;
    private int prevInputLength;
    private int duration = 0;

    public JavaEncoder() {
        super("iLBC Encoder", AudioFormat.class, new Format[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, 0, 1)});
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
        this.addControl(new SilenceSuppressionAdapter(this, false, false));
    }

    @Override
    protected void doClose() {
        this.enc = null;
        this.outputLength = 0;
        this.inputLength = 0;
        this.prevInput = null;
        this.prevInputLength = 0;
        this.duration = 0;
    }

    @Override
    protected void doOpen() {
        int mode = Constants.ILBC_MODE;
        this.enc = new ilbc_encoder(mode);
        switch (mode) {
            case 20: {
                this.outputLength = 38;
                break;
            }
            case 30: {
                this.outputLength = 50;
                break;
            }
            default: {
                throw new IllegalStateException("mode");
            }
        }
        this.duration = mode * 1000000;
        this.inputLength = this.enc.ULP_inst.blockl * 2;
        this.prevInput = new byte[this.inputLength];
        this.prevInputLength = 0;
    }

    @Override
    public Format getOutputFormat() {
        Format outputFormat = super.getOutputFormat();
        if (outputFormat != null && outputFormat.getClass() == AudioFormat.class) {
            AudioFormat outputAudioFormat = (AudioFormat)outputFormat;
            outputFormat = this.setOutputFormat(new AudioFormat(outputAudioFormat.getEncoding(), outputAudioFormat.getSampleRate(), outputAudioFormat.getSampleSizeInBits(), outputAudioFormat.getChannels(), outputAudioFormat.getEndian(), outputAudioFormat.getSigned(), outputAudioFormat.getFrameSizeInBits(), outputAudioFormat.getFrameRate(), outputAudioFormat.getDataType()){
                private static final long serialVersionUID = 0L;

                @Override
                public long computeDuration(long length) {
                    return JavaEncoder.this.duration;
                }
            });
        }
        return outputFormat;
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int ret;
        int inputLength = inputBuffer.getLength();
        byte[] input = (byte[])inputBuffer.getData();
        int inputOffset = inputBuffer.getOffset();
        if (this.prevInputLength != 0 || inputLength < this.inputLength) {
            int bytesToCopy = this.inputLength - this.prevInputLength;
            if (bytesToCopy > inputLength) {
                bytesToCopy = inputLength;
            }
            System.arraycopy(input, inputOffset, this.prevInput, this.prevInputLength, bytesToCopy);
            this.prevInputLength += bytesToCopy;
            inputBuffer.setLength(inputLength - bytesToCopy);
            inputBuffer.setOffset(inputOffset + bytesToCopy);
            inputLength = this.prevInputLength;
            input = this.prevInput;
            inputOffset = 0;
        } else {
            inputBuffer.setLength(inputLength - this.inputLength);
            inputBuffer.setOffset(inputOffset + this.inputLength);
        }
        if (inputLength >= this.inputLength) {
            this.prevInputLength = 0;
            int outputOffset = 0;
            byte[] output = JavaEncoder.validateByteArraySize(outputBuffer, outputOffset + this.outputLength, true);
            this.enc.encode(output, outputOffset, input, inputOffset);
            this.updateOutput(outputBuffer, this.getOutputFormat(), this.outputLength, outputOffset);
            outputBuffer.setDuration(this.duration);
            ret = 0;
        } else {
            ret = 4;
        }
        if (inputBuffer.getLength() > 0) {
            ret |= 2;
        }
        return ret;
    }
}

