/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.awt.Dimension;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.media.control.PacketQueueControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.ReceiveStream;
import net.sf.fmj.media.rtp.RTCPFeedback;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.StreamRTPManager;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.device.VideoMediaDeviceSession;
import org.jitsi.service.neomedia.MediaStreamStats;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.control.FECDecoderControl;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.Logger;

public class MediaStreamStatsImpl
implements MediaStreamStats {
    private static final Logger logger = Logger.getLogger(MediaStreamStatsImpl.class);
    private final MediaStreamImpl mediaStreamImpl;
    private long updateTimeMs;
    private long[] nbPackets = new long[]{0L, 0L};
    private long uploadFeedbackNbPackets = 0L;
    private long[] nbLost = new long[]{0L, 0L};
    private long nbDiscarded = 0L;
    private long nbFec = 0L;
    private long[] nbByte = new long[]{0L, 0L};
    private double[] percentLoss = new double[]{0.0, 0.0};
    private double percentDiscarded = 0.0;
    private double[] rateKiloBitPerSec = new double[]{0.0, 0.0};
    private double[] jitterRTPTimestampUnits = new double[]{0.0, 0.0};
    private long rttMs = -1L;

    public MediaStreamStatsImpl(MediaStreamImpl mediaStreamImpl) {
        this.updateTimeMs = System.currentTimeMillis();
        this.mediaStreamImpl = mediaStreamImpl;
    }

    @Override
    public void updateStats() {
        long currentTimeMs = System.currentTimeMillis();
        this.updateStreamDirectionStats(StreamDirection.DOWNLOAD, currentTimeMs);
        this.updateStreamDirectionStats(StreamDirection.UPLOAD, currentTimeMs);
        this.updateTimeMs = currentTimeMs;
    }

    private void updateStreamDirectionStats(StreamDirection streamDirection, long currentTimeMs) {
        int streamDirectionIndex = streamDirection.ordinal();
        long newNbRecv = this.getNbPDU(streamDirection);
        long newNbByte = this.getNbBytes(streamDirection);
        long nbSteps = newNbRecv - this.nbPackets[streamDirectionIndex];
        if (nbSteps == 0L) {
            nbSteps = (currentTimeMs - this.updateTimeMs) / 20L;
        }
        if (streamDirection == StreamDirection.DOWNLOAD) {
            long newNbLost = this.getDownloadNbPDULost() - this.nbLost[streamDirectionIndex];
            this.updateNbLoss(streamDirection, newNbLost, nbSteps + newNbLost);
            long newNbDiscarded = this.getNbDiscarded() - this.nbDiscarded;
            this.updateNbDiscarded(newNbDiscarded, nbSteps + newNbDiscarded);
        }
        double newRateKiloBitPerSec = MediaStreamStatsImpl.computeRateKiloBitPerSec(newNbByte - this.nbByte[streamDirectionIndex], currentTimeMs - this.updateTimeMs);
        this.rateKiloBitPerSec[streamDirectionIndex] = MediaStreamStatsImpl.computeEWMA(nbSteps, this.rateKiloBitPerSec[streamDirectionIndex], newRateKiloBitPerSec);
        this.nbPackets[streamDirectionIndex] = newNbRecv;
        this.nbByte[streamDirectionIndex] = newNbByte;
        this.updateNbFec();
    }

    @Override
    public String getLocalIPAddress() {
        InetSocketAddress mediaStreamLocalDataAddress = this.mediaStreamImpl.getLocalDataAddress();
        return mediaStreamLocalDataAddress == null ? null : mediaStreamLocalDataAddress.getAddress().getHostAddress();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress mediaStreamLocalDataAddress = this.mediaStreamImpl.getLocalDataAddress();
        return mediaStreamLocalDataAddress == null ? -1 : mediaStreamLocalDataAddress.getPort();
    }

    @Override
    public String getRemoteIPAddress() {
        MediaStreamTarget mediaStreamTarget = this.mediaStreamImpl.getTarget();
        return mediaStreamTarget == null ? null : mediaStreamTarget.getDataAddress().getAddress().getHostAddress();
    }

    @Override
    public int getRemotePort() {
        MediaStreamTarget mediaStreamTarget = this.mediaStreamImpl.getTarget();
        return mediaStreamTarget == null ? -1 : mediaStreamTarget.getDataAddress().getPort();
    }

    @Override
    public String getEncoding() {
        MediaFormat format = this.mediaStreamImpl.getFormat();
        return format == null ? null : format.getEncoding();
    }

    @Override
    public String getEncodingClockRate() {
        MediaFormat format = this.mediaStreamImpl.getFormat();
        return format == null ? null : format.getRealUsedClockRateString();
    }

    private VideoFormat getUploadVideoFormat() {
        MediaDeviceSession deviceSession = this.mediaStreamImpl.getDeviceSession();
        return deviceSession instanceof VideoMediaDeviceSession ? ((VideoMediaDeviceSession)deviceSession).getSentVideoFormat() : null;
    }

    private VideoFormat getDownloadVideoFormat() {
        MediaDeviceSession deviceSession = this.mediaStreamImpl.getDeviceSession();
        return deviceSession instanceof VideoMediaDeviceSession ? ((VideoMediaDeviceSession)deviceSession).getReceivedVideoFormat() : null;
    }

    @Override
    public Dimension getUploadVideoSize() {
        VideoFormat format = this.getUploadVideoFormat();
        return format == null ? null : format.getSize();
    }

    @Override
    public Dimension getDownloadVideoSize() {
        VideoFormat format = this.getDownloadVideoFormat();
        return format == null ? null : format.getSize();
    }

    @Override
    public double getDownloadPercentLoss() {
        return this.percentLoss[StreamDirection.DOWNLOAD.ordinal()];
    }

    @Override
    public double getPercentDiscarded() {
        return this.percentDiscarded;
    }

    @Override
    public double getUploadPercentLoss() {
        return this.percentLoss[StreamDirection.UPLOAD.ordinal()];
    }

    @Override
    public double getDownloadRateKiloBitPerSec() {
        return this.rateKiloBitPerSec[StreamDirection.DOWNLOAD.ordinal()];
    }

    @Override
    public double getUploadRateKiloBitPerSec() {
        return this.rateKiloBitPerSec[StreamDirection.UPLOAD.ordinal()];
    }

    @Override
    public double getDownloadJitterMs() {
        return this.getJitterMs(StreamDirection.DOWNLOAD);
    }

    @Override
    public double getUploadJitterMs() {
        return this.getJitterMs(StreamDirection.UPLOAD);
    }

    private double getJitterMs(StreamDirection streamDirection) {
        MediaType mediaType;
        MediaFormat format = this.mediaStreamImpl.getFormat();
        double clockRate = format == null ? (MediaType.VIDEO.equals((Object)(mediaType = this.mediaStreamImpl.getMediaType())) ? 90000.0 : -1.0) : format.getClockRate();
        if (clockRate <= 0.0) {
            return -1.0;
        }
        return this.jitterRTPTimestampUnits[streamDirection.ordinal()] / clockRate * 1000.0;
    }

    private void updateJitterRTPTimestampUnits(RTCPFeedback feedback, StreamDirection streamDirection) {
        this.jitterRTPTimestampUnits[streamDirection.ordinal()] = feedback.getJitter();
    }

    @Override
    public void updateNewSentFeedback(RTCPFeedback feedback) {
        this.updateJitterRTPTimestampUnits(feedback, StreamDirection.DOWNLOAD);
    }

    @Override
    public void updateNewReceivedFeedback(RTCPFeedback feedback) {
        StreamDirection streamDirection = StreamDirection.UPLOAD;
        this.updateJitterRTPTimestampUnits(feedback, streamDirection);
        long uploadNewNbRecv = feedback.getXtndSeqNum();
        long newNbLost = feedback.getNumLost() - this.nbLost[streamDirection.ordinal()];
        long nbSteps = uploadNewNbRecv - this.uploadFeedbackNbPackets;
        this.updateNbLoss(streamDirection, newNbLost, nbSteps);
        this.uploadFeedbackNbPackets = uploadNewNbRecv;
        this.rttMs = this.computeRTTInMs(feedback);
    }

    private void updateNbLoss(StreamDirection streamDirection, long newNbLost, long nbSteps) {
        int streamDirectionIndex = streamDirection.ordinal();
        double newPercentLoss = MediaStreamStatsImpl.computePercentLoss(nbSteps, newNbLost);
        this.percentLoss[streamDirectionIndex] = MediaStreamStatsImpl.computeEWMA(nbSteps, this.percentLoss[streamDirectionIndex], newPercentLoss);
        int n = streamDirectionIndex;
        this.nbLost[n] = this.nbLost[n] + newNbLost;
    }

    private static double computePercentLoss(long nbLostAndRecv, long nbLost) {
        if (nbLostAndRecv == 0L) {
            return 0.0;
        }
        return 100.0 * (double)nbLost / (double)nbLostAndRecv;
    }

    private static double computeRateKiloBitPerSec(long nbByteRecv, long callNbTimeMsSpent) {
        if (nbByteRecv == 0L) {
            return 0.0;
        }
        return (double)nbByteRecv * 8.0 / 1000.0 / ((double)callNbTimeMsSpent / 1000.0);
    }

    private static double computeEWMA(long nbStepSinceLastUpdate, double lastValue, double newValue) {
        double EWMACoeff = 0.01 * (double)nbStepSinceLastUpdate;
        if (EWMACoeff > 1.0) {
            EWMACoeff = 1.0;
        }
        return lastValue * (1.0 - EWMACoeff) + newValue * EWMACoeff;
    }

    private long getNbPDU(StreamDirection streamDirection) {
        StreamRTPManager rtpManager = this.mediaStreamImpl.queryRTPManager();
        long nbPDU = 0L;
        if (rtpManager != null) {
            switch (streamDirection) {
                case UPLOAD: {
                    nbPDU = rtpManager.getGlobalTransmissionStats().getRTPSent();
                    break;
                }
                case DOWNLOAD: {
                    GlobalReceptionStats globalReceptionStats = rtpManager.getGlobalReceptionStats();
                    nbPDU = globalReceptionStats.getPacketsRecd() - globalReceptionStats.getRTCPRecd();
                }
            }
        }
        return nbPDU;
    }

    private long getDownloadNbPDULost() {
        MediaDeviceSession devSession = this.mediaStreamImpl.getDeviceSession();
        int nbLost = 0;
        if (devSession != null) {
            for (ReceiveStream receiveStream : devSession.getReceiveStreams()) {
                nbLost += receiveStream.getSourceReceptionStats().getPDUlost();
            }
        }
        return nbLost;
    }

    @Override
    public long getNbDiscarded() {
        int nbDiscarded = 0;
        for (PacketQueueControl pqc : this.getPacketQueueControls()) {
            nbDiscarded = pqc.getDiscarded();
        }
        return nbDiscarded;
    }

    @Override
    public int getNbDiscardedShrink() {
        int nbDiscardedShrink = 0;
        for (PacketQueueControl pqc : this.getPacketQueueControls()) {
            nbDiscardedShrink = pqc.getDiscardedShrink();
        }
        return nbDiscardedShrink;
    }

    @Override
    public int getNbDiscardedFull() {
        int nbDiscardedFull = 0;
        for (PacketQueueControl pqc : this.getPacketQueueControls()) {
            nbDiscardedFull = pqc.getDiscardedFull();
        }
        return nbDiscardedFull;
    }

    @Override
    public int getNbDiscardedLate() {
        int nbDiscardedLate = 0;
        for (PacketQueueControl pqc : this.getPacketQueueControls()) {
            nbDiscardedLate = pqc.getDiscardedLate();
        }
        return nbDiscardedLate;
    }

    @Override
    public int getNbDiscardedReset() {
        int nbDiscardedReset = 0;
        for (PacketQueueControl pqc : this.getPacketQueueControls()) {
            nbDiscardedReset = pqc.getDiscardedReset();
        }
        return nbDiscardedReset;
    }

    private long getNbBytes(StreamDirection streamDirection) {
        StreamRTPManager rtpManager = this.mediaStreamImpl.queryRTPManager();
        long nbBytes = 0L;
        if (rtpManager != null) {
            switch (streamDirection) {
                case DOWNLOAD: {
                    nbBytes = rtpManager.getGlobalReceptionStats().getBytesRecd();
                    break;
                }
                case UPLOAD: {
                    nbBytes = rtpManager.getGlobalTransmissionStats().getBytesSent();
                }
            }
        }
        return nbBytes;
    }

    private long computeRTTInMs(RTCPFeedback feedback) {
        long currentTime = System.currentTimeMillis();
        long DLSR = feedback.getDLSR();
        long LSR = feedback.getLSR();
        if (DLSR != 0L && LSR != 0L) {
            long currentTimeS = currentTime / 1000L & 0xFFFFL;
            long DLSRs = DLSR / 65535L;
            long LSRs = LSR >> 16;
            long rttS = currentTimeS - DLSRs - LSRs;
            long currentTimeMs = currentTime % 1000L;
            long DLSRms = (DLSR & 0xFFFFL) * 1000L / 65535L;
            long LSRms = (LSR & 0xFFFFL) * 1000L / 65535L;
            long rttMs = currentTimeMs - DLSRms - LSRms;
            long computedRTTms = rttS * 1000L + rttMs;
            if (computedRTTms > 60000L && logger.isInfoEnabled()) {
                logger.info("Stream: " + this.mediaStreamImpl.getName() + ", RTT computation seems to be wrong (" + computedRTTms + "> 60 seconds):" + "\n\tcurrentTime: " + currentTime + " (" + Long.toHexString(currentTime) + ")" + "\n\tDLSR: " + DLSR + " (" + Long.toHexString(DLSR) + ")" + "\n\tLSR: " + LSR + " (" + Long.toHexString(LSR) + ")" + "\n\n\tcurrentTimeS: " + currentTimeS + " (" + Long.toHexString(currentTimeS) + ")" + "\n\tDLSRs: " + DLSRs + " (" + Long.toHexString(DLSRs) + ")" + "\n\tLSRs: " + LSRs + " (" + Long.toHexString(LSRs) + ")" + "\n\trttS: " + rttS + " (" + Long.toHexString(rttS) + ")" + "\n\n\tcurrentTimeMs: " + currentTimeMs + " (" + Long.toHexString(currentTimeMs) + ")" + "\n\tDLSRms: " + DLSRms + " (" + Long.toHexString(DLSRms) + ")" + "\n\tLSRms: " + LSRms + " (" + Long.toHexString(LSRms) + ")" + "\n\trttMs: " + rttMs + " (" + Long.toHexString(rttMs) + ")");
            }
            return computedRTTms;
        }
        return -1L;
    }

    @Override
    public long getRttMs() {
        return this.rttMs;
    }

    @Override
    public long getNbFec() {
        return this.nbFec;
    }

    private void updateNbFec() {
        MediaDeviceSession devSession = this.mediaStreamImpl.getDeviceSession();
        int nbFec = 0;
        if (devSession != null) {
            for (ReceiveStream receiveStream : devSession.getReceiveStreams()) {
                for (FECDecoderControl fecDecoderControl : devSession.getDecoderControls(receiveStream, FECDecoderControl.class)) {
                    nbFec += fecDecoderControl.fecPacketsDecoded();
                }
            }
        }
        this.nbFec = nbFec;
    }

    private void updateNbDiscarded(long newNbDiscarded, long nbSteps) {
        double newPercentDiscarded = MediaStreamStatsImpl.computePercentLoss(nbSteps, newNbDiscarded);
        this.percentDiscarded = MediaStreamStatsImpl.computeEWMA(nbSteps, this.percentDiscarded, newPercentDiscarded);
        this.nbDiscarded += newNbDiscarded;
    }

    @Override
    public boolean isAdaptiveBufferEnabled() {
        for (PacketQueueControl pcq : this.getPacketQueueControls()) {
            if (!pcq.isAdaptiveBufferEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getJitterBufferDelayPackets() {
        int delay = 0;
        for (PacketQueueControl pqc : this.getPacketQueueControls()) {
            if (pqc.getCurrentDelayPackets() <= delay) continue;
            delay = pqc.getCurrentDelayPackets();
        }
        return delay;
    }

    @Override
    public int getJitterBufferDelayMs() {
        int delay = 0;
        for (PacketQueueControl pqc : this.getPacketQueueControls()) {
            if (pqc.getCurrentDelayMs() <= delay) continue;
            delay = pqc.getCurrentDelayMs();
        }
        return delay;
    }

    @Override
    public int getPacketQueueSize() {
        Iterator<PacketQueueControl> i$ = this.getPacketQueueControls().iterator();
        if (i$.hasNext()) {
            PacketQueueControl pqc = i$.next();
            return pqc.getCurrentSizePackets();
        }
        return 0;
    }

    @Override
    public int getPacketQueueCountPackets() {
        Iterator<PacketQueueControl> i$ = this.getPacketQueueControls().iterator();
        if (i$.hasNext()) {
            PacketQueueControl pqc = i$.next();
            return pqc.getCurrentPacketCount();
        }
        return 0;
    }

    private Set<PacketQueueControl> getPacketQueueControls() {
        MediaDeviceSession devSession;
        HashSet<PacketQueueControl> set = new HashSet<PacketQueueControl>();
        if (this.mediaStreamImpl.isStarted() && (devSession = this.mediaStreamImpl.getDeviceSession()) != null) {
            for (ReceiveStream receiveStream : devSession.getReceiveStreams()) {
                DataSource ds = receiveStream.getDataSource();
                if (!(ds instanceof net.sf.fmj.media.protocol.rtp.DataSource)) continue;
                for (PushBufferStream pbs : ((net.sf.fmj.media.protocol.rtp.DataSource)ds).getStreams()) {
                    PacketQueueControl pqc = (PacketQueueControl)pbs.getControl(PacketQueueControl.class.getName());
                    if (pqc == null) continue;
                    set.add(pqc);
                }
            }
        }
        return set;
    }

    private static enum StreamDirection {
        DOWNLOAD,
        UPLOAD;

    }
}

