/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.io.File;
import java.io.IOException;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.TransferredFileFactory;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferredFile;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferredFileImpl;
import org.jetbrains.annotations.Nullable;

public class DefaultTransferredFileFactory
implements TransferredFileFactory {
    public TransferredFileImpl getTransferredFile(File file, String name) throws IOException {
        return this.createTransferredFile(file, name);
    }

    private TransferredFileImpl createTransferredFile(File file, String name) throws IOException {
        TransferredFileImpl tfile = this.createInitialTransferredFile(file, name);
        this.initializeFile(tfile);
        return tfile;
    }

    protected TransferredFileImpl createInitialTransferredFile(File file, String name) throws IOException {
        return new TransferredFileImpl(file, name, "r");
    }

    public TransferredFile getTransferredFileInFolder(File file, String folderName) throws IOException {
        return this.createTransferredFile(file, folderName + File.separator + file.getName());
    }

    public TransferredFile getTransferredFileFromRoot(File file, File root, @Nullable String folderName) throws IOException, IllegalArgumentException {
        File component;
        if (file.equals(root)) {
            throw new IllegalArgumentException("File cannot be root: " + file);
        }
        StringBuilder string = new StringBuilder(100);
        for (component = file; component != null && !component.equals(root); component = component.getParentFile()) {
            string.insert(0, File.separator + component.getName());
        }
        if (component == null) {
            throw new IllegalArgumentException("File is not child of root: file=" + file + ", root=" + root);
        }
        string.delete(0, 1);
        if (folderName != null) {
            while (folderName.endsWith(File.separator)) {
                folderName = folderName.substring(0, folderName.length() - 1);
            }
            if (folderName.length() > 0) {
                string.insert(0, folderName + File.separator);
            }
        }
        return this.createTransferredFile(file, string.toString());
    }

    protected void initializeFile(TransferredFileImpl tfile) {
    }
}

