/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import org.jboss.netty.util.internal.SystemPropertyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DetectionUtil {
    private static final int JAVA_VERSION = DetectionUtil.javaVersion0();
    private static final boolean HAS_UNSAFE = DetectionUtil.hasUnsafe(AtomicInteger.class.getClassLoader());
    private static final boolean IS_WINDOWS;

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    public static int javaVersion() {
        return JAVA_VERSION;
    }

    private static boolean hasUnsafe(ClassLoader loader) {
        boolean useUnsafe = Boolean.valueOf(SystemPropertyUtil.get("org.jboss.netty.tryUnsafe", "true"));
        if (!useUnsafe) {
            return false;
        }
        try {
            Class<?> unsafeClazz = Class.forName("sun.misc.Unsafe", true, loader);
            return DetectionUtil.hasUnsafeField(unsafeClazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasUnsafeField(final Class<?> unsafeClass) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                unsafeClass.getDeclaredField("theUnsafe");
                return true;
            }
        });
    }

    private static int javaVersion0() {
        try {
            Class.forName("android.app.Application");
            return 6;
        }
        catch (ClassNotFoundException e) {
            try {
                Deflater.class.getDeclaredField("SYNC_FLUSH");
                return 7;
            }
            catch (Exception e2) {
                try {
                    Double.class.getDeclaredField("MIN_NORMAL");
                    return 6;
                }
                catch (Exception exception) {
                    return 5;
                }
            }
        }
    }

    private DetectionUtil() {
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        IS_WINDOWS = os.indexOf("win") >= 0;
    }
}

