/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sentinel.local;

import com.voxeo.sentinel.local.LocalSentinelThread;
import com.voxeo.sentinel.protocols.LocalSentinelProtocol;
import com.voxeo.versioning.AComponent;
import com.voxeo.versioning.Machine;
import com.voxeo.versioning.Module;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LocalSentinel
extends Thread {
    private static final Logger Log = Logger.getLogger(LocalSentinel.class);
    private final int[] PORT_SEQ = new int[]{101, 201, 301, 401, 501};
    private final int[] RANGE_SEQ = new int[]{9000, 8000, 7000, 6000, 5000};
    private ServerSocket serverSocket = null;
    private Integer serverPort = null;
    private boolean listening = false;
    private static HashMap<LocalSentinelProtocol, AComponent> moduleHash;
    private static HashMap<LocalSentinelProtocol, Date> timeoutHash;

    public LocalSentinel() {
        this.setName("LocalSentinel");
        moduleHash = new HashMap(100);
        timeoutHash = new HashMap(100);
    }

    public LocalSentinel(Integer serverPort) {
        this();
        this.serverPort = serverPort;
    }

    private boolean bindSentinel() {
        boolean returnValue = false;
        ServerSocket serversocket = null;
        try {
            if (this.serverPort != null) {
                try {
                    serversocket = new ServerSocket(this.serverPort);
                    returnValue = true;
                }
                catch (Exception e) {
                    returnValue = false;
                    Log.debug((Object)("SentinelClient::connectToSentinel() - On the configured port " + this.serverPort + " Exception: "), (Throwable)e);
                }
            }
            if (!returnValue) {
                for (int i = 0; i < this.RANGE_SEQ.length; ++i) {
                    for (int k = 0; k < this.PORT_SEQ.length; ++k) {
                        try {
                            Log.debug((Object)("LocalSentinel::bindSentinel() - Trying to connect to port:" + (this.RANGE_SEQ[i] + this.PORT_SEQ[k])));
                            serversocket = new ServerSocket(new Integer(this.RANGE_SEQ[i] + this.PORT_SEQ[k]));
                            this.serverPort = new Integer(this.RANGE_SEQ[i] + this.PORT_SEQ[k]);
                            break;
                        }
                        catch (Exception e) {
                            Log.debug((Object)("SentinelClient::connectToSentinel() - On port " + (this.RANGE_SEQ[i] + this.PORT_SEQ[k]) + " Exception: "), (Throwable)e);
                            Thread.sleep(1000L);
                            continue;
                        }
                    }
                    if (serversocket != null) break;
                }
            }
            if (serversocket != null) {
                this.serverSocket = serversocket;
                returnValue = true;
            }
        }
        catch (Exception e) {
            Log.debug((Object)"SentinelClient::connectToSentinel() - Exception: ", (Throwable)e);
            returnValue = false;
        }
        return returnValue;
    }

    private void listenUp() {
        try {
            Log.debug((Object)("Waiting for connections on port " + this.serverPort));
            this.listening = true;
            while (this.listening) {
                new LocalSentinelThread(this.serverSocket.accept()).start();
                Log.debug((Object)"Server spawned off a thread");
            }
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        if (this.bindSentinel()) {
            this.listenUp();
        }
    }

    public void turnOff() {
        this.listening = false;
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isListening() {
        return this.listening;
    }

    public static void unregisterModule(LocalSentinelProtocol localSentinelProtocol) {
        moduleHash.remove(localSentinelProtocol);
        timeoutHash.remove(localSentinelProtocol);
    }

    public static void registerModule(Module incoming, LocalSentinelProtocol localSentinelProtocol) {
        if (incoming == null) {
            Log.warn((Object)("Module is null for some reason, connection: " + localSentinelProtocol));
        }
        Date theDate = new Date();
        moduleHash.put(localSentinelProtocol, incoming);
        timeoutHash.put(localSentinelProtocol, theDate);
    }

    public static void handleHTTPRequest(PrintWriter out, String hostname, String ip) {
        String formattedDate = "";
        try {
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss zzz");
            formattedDate = df.format(new Date());
        }
        catch (Exception e) {
            Log.debug((Object)"LocalSentinel::handleHTTPRequest() - Exception: ", (Throwable)e);
        }
        String content = LocalSentinel.getXML(hostname, ip);
        String statusLine = "HTTP/1.0 200 OK\r\n";
        String generalHeader = "Date: " + formattedDate + "\r\n";
        String entityHeader = "Allow: GET\r\nContent-Type: text/xml\r\nContent-Length: " + content.length() + "\r\n";
        out.print("HTTP/1.0 200 OK\r\n" + generalHeader + entityHeader + "\r\n" + content);
    }

    public static String getXML(String name, String ip) {
        Machine machine = new Machine(name, ip);
        for (LocalSentinelProtocol localSentinelProtocol : moduleHash.keySet()) {
            localSentinelProtocol.waitForRefresh();
            machine.addComponent(moduleHash.get(localSentinelProtocol));
        }
        return machine.toXML();
    }

    public int getPort() {
        return this.serverPort;
    }
}

