/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.support;

import java.util.Stack;
import org.openymsg.support.MessageElement;

public class MessageDecoder {
    protected char[] msg;
    protected StringBuffer out = new StringBuffer();
    protected int pos;
    protected Stack<MessageElement> stack = new Stack();
    protected static final char ESC = '\u001b';
    protected static final String ESC_SEQ = "\u001b[";

    public synchronized MessageElement decode(String m) {
        this.msg = m.toCharArray();
        this.out.setLength(0);
        this.stack.removeAllElements();
        this.pos = 0;
        MessageElement section = new MessageElement(-1);
        this.stack.push(section);
        while (this.pos < this.msg.length) {
            if (this.startsWith("<font ")) {
                this.handleFont();
            } else if (this.startsWith("<fade ")) {
                this.handleFade();
            } else if (this.startsWith("<alt ")) {
                this.handleAlt();
            } else if (this.startsWith(ESC_SEQ)) {
                this.handleEscape();
            } else if (this.startsWith("</font>")) {
                this.handleFontExit();
            } else if (this.startsWith("</fade>")) {
                this.handleFadeExit();
            } else if (this.startsWith("</alt>")) {
                this.handleAltExit();
            } else if (this.startsWith("<")) {
                this.handleOtherTag();
            } else {
                this.out.append(this.msg[this.pos]);
            }
            ++this.pos;
        }
        this.addText();
        return section;
    }

    public String decodeToText(String m) {
        MessageElement me = this.decode(m);
        return me.toText();
    }

    protected void handleFont() {
        this.addText();
        this.pos += 6;
        int end = this.nextNonLiteral('>');
        String s = new String(this.msg, this.pos, end - this.pos);
        this.add(new MessageElement(5, s));
        this.pos = end;
    }

    protected void handleFade() {
        this.addText();
        this.pos += 6;
        int end = this.nextNonLiteral('>');
        String s = new String(this.msg, this.pos, end - this.pos);
        this.add(new MessageElement(6, s));
        this.pos = this.nextNonLiteral('>');
    }

    protected void handleAlt() {
        this.addText();
        this.pos += 5;
        int end = this.nextNonLiteral('>');
        String s = new String(this.msg, this.pos, end - this.pos);
        this.add(new MessageElement(7, s));
        this.pos = this.nextNonLiteral('>');
    }

    protected void handleEscape() {
        this.addText();
        this.pos += 2;
        MessageElement section = null;
        char c = this.msg[this.pos];
        if (c >= '1' && c <= '4') {
            switch (c) {
                case '1': {
                    section = new MessageElement(1);
                    break;
                }
                case '2': {
                    section = new MessageElement(2);
                    break;
                }
                case '3': {
                    section = new MessageElement(3, "" + this.msg[this.pos + 1]);
                    break;
                }
                case '4': {
                    section = new MessageElement(4);
                }
            }
            this.add(section);
        } else if (c == 'x') {
            ++this.pos;
            int ty = -1;
            switch (this.msg[this.pos]) {
                case '1': {
                    ty = 1;
                    break;
                }
                case '2': {
                    ty = 2;
                    break;
                }
                case '4': {
                    ty = 4;
                }
            }
            if (ty > -1) {
                this.remove(ty);
            }
        } else if (c == '#') {
            ++this.pos;
            String s = new String(this.msg, this.pos, 6);
            section = new MessageElement(8, s);
            this.add(section);
        }
        this.pos = this.nextNonLiteral('m');
    }

    protected void handleFontExit() {
        this.addText();
        this.pos += 6;
        this.remove(5);
    }

    protected void handleFadeExit() {
        this.addText();
        this.pos += 6;
        this.remove(6);
    }

    protected void handleAltExit() {
        this.addText();
        this.pos += 5;
        this.remove(7);
    }

    protected void handleOtherTag() {
        this.addText();
        ++this.pos;
        int end = this.nextNonLiteral('>');
        String s = new String(this.msg, this.pos, end - this.pos).toLowerCase();
        int i1 = MessageElement.whichColourName(s);
        if (i1 >= 0) {
            MessageElement section = new MessageElement(9, i1);
            this.add(section);
            this.pos = end;
        } else if (s.equals("b")) {
            this.add(new MessageElement(1));
            ++this.pos;
        } else if (s.equals("/b")) {
            this.remove(1);
            this.pos += 2;
        } else if (s.equals("i")) {
            this.add(new MessageElement(2));
            ++this.pos;
        } else if (s.equals("/i")) {
            this.remove(2);
            this.pos += 2;
        } else if (s.equals("u")) {
            this.add(new MessageElement(4));
            ++this.pos;
        } else if (s.equals("/u")) {
            this.remove(4);
            this.pos += 2;
        } else if (s.length() > 1 && s.charAt(0) == '/') {
            int i2 = MessageElement.whichColourName(s.substring(1));
            if (i2 >= 0) {
                this.remove(9, i2);
            }
            this.pos = end;
        } else if (s.startsWith("#")) {
            this.add(new MessageElement(8, s.substring(1)));
            this.pos += 7;
        } else {
            this.out.append('<');
            --this.pos;
        }
    }

    private void add(MessageElement s) {
        this.stack.peek().addChild(s);
        this.stack.push(s);
    }

    private void remove(int type) {
        if (this.stack.size() > 1) {
            MessageElement me = this.stack.pop();
            while (me.type != type && this.stack.size() > 1) {
                me = this.stack.pop();
            }
        }
    }

    private void remove(int type, int col) {
        if (this.stack.size() > 1) {
            MessageElement me = this.stack.pop();
            while (!(me.type == type && me.colourEquals(col) || this.stack.size() <= 1)) {
                me = this.stack.pop();
            }
        }
    }

    private void addText() {
        if (this.out.length() > 0) {
            MessageElement me = this.stack.peek();
            MessageElement me2 = new MessageElement(0, this.out.toString());
            me.addChild(me2);
            this.out = new StringBuffer();
        }
    }

    private boolean startsWith(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (this.pos + i >= this.msg.length) {
                return false;
            }
            char c = this.msg[this.pos + i];
            if (c >= 'A' && c <= 'Z') {
                c = Character.toLowerCase(c);
            }
            if (c == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private int nextNonLiteral(char t) {
        int p;
        boolean literal = false;
        for (p = this.pos; p < this.msg.length && (this.msg[p] != t || literal); ++p) {
            if (this.msg[p] != '\"') continue;
            literal = !literal;
        }
        return p;
    }
}

