/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.EntryEventData;
import com.hazelcast.map.impl.EventData;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEventData;
import com.hazelcast.map.impl.MapPartitionEventData;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.NodeEngine;

class MapEventPublishingService
implements EventPublishingService<EventData, ListenerAdapter> {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    protected MapEventPublishingService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public void dispatchEvent(EventData eventData, ListenerAdapter listener) {
        if (eventData instanceof EntryEventData) {
            this.dispatchEntryEventData((EntryEventData)eventData, listener);
            return;
        }
        if (eventData instanceof MapEventData) {
            this.dispatchMapEventData((MapEventData)eventData, listener);
            return;
        }
        if (eventData instanceof MapPartitionEventData) {
            this.dispatchMapPartitionLostEventData((MapPartitionEventData)eventData, listener);
            return;
        }
        throw new IllegalArgumentException("Unknown map event data");
    }

    private void incrementEventStats(IMapEvent event) {
        String mapName = event.getName();
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            this.mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(mapName).incrementReceivedEvents();
        }
    }

    private void dispatchMapEventData(MapEventData mapEventData, ListenerAdapter listener) {
        Member member = this.getMember(mapEventData);
        MapEvent event = this.createMapEvent(mapEventData, member);
        this.callListener(listener, event);
    }

    private void dispatchMapPartitionLostEventData(MapPartitionEventData mapPartitionEventData, ListenerAdapter listener) {
        Member member = this.getMember(mapPartitionEventData);
        MapPartitionLostEvent event = this.createMapPartitionLostEventData(mapPartitionEventData, member);
        this.callListener(listener, event);
    }

    private MapPartitionLostEvent createMapPartitionLostEventData(MapPartitionEventData mapPartitionEventData, Member member) {
        return new MapPartitionLostEvent(mapPartitionEventData.getMapName(), member, mapPartitionEventData.getEventType(), mapPartitionEventData.getPartitionId());
    }

    private void callListener(ListenerAdapter listener, IMapEvent event) {
        listener.onEvent(event);
        this.incrementEventStats(event);
    }

    private MapEvent createMapEvent(MapEventData mapEventData, Member member) {
        return new MapEvent(mapEventData.getMapName(), member, mapEventData.getEventType(), mapEventData.getNumberOfEntries());
    }

    private void dispatchEntryEventData(EntryEventData entryEventData, ListenerAdapter listener) {
        Member member = this.getMember(entryEventData);
        DataAwareEntryEvent event = this.createDataAwareEntryEvent(entryEventData, member);
        this.callListener(listener, event);
    }

    private Member getMember(EventData eventData) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(eventData.getCaller());
        if (member == null) {
            member = new MemberImpl(eventData.getCaller(), false);
        }
        return member;
    }

    private DataAwareEntryEvent createDataAwareEntryEvent(EntryEventData entryEventData, Member member) {
        return new DataAwareEntryEvent(member, entryEventData.getEventType(), entryEventData.getMapName(), entryEventData.getDataKey(), entryEventData.getDataNewValue(), entryEventData.getDataOldValue(), entryEventData.getDataMergingValue(), this.nodeEngine.getSerializationService());
    }
}

