/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.configuration;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ServletConfigurator
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$configuration$ServletConfigurator == null ? (class$org$logicalcobwebs$proxool$configuration$ServletConfigurator = ServletConfigurator.class$("org.logicalcobwebs.proxool.configuration.ServletConfigurator")) : class$org$logicalcobwebs$proxool$configuration$ServletConfigurator));
    private static final String XML_FILE_PROPERTY = "xmlFile";
    private static final String PROPERTY_FILE_PROPERTY = "propertyFile";
    private static final String AUTO_SHUTDOWN_PROPERTY = "autoShutdown";
    private boolean autoShutdown = true;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$configuration$ServletConfigurator;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String appDir = servletConfig.getServletContext().getRealPath("/");
        Properties properties = new Properties();
        Enumeration names = servletConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            File file;
            String name = (String)names.nextElement();
            String value = servletConfig.getInitParameter(name);
            if (name.equals(XML_FILE_PROPERTY)) {
                try {
                    file = new File(value);
                    if (file.isAbsolute()) {
                        JAXPConfigurator.configure(value, false);
                        continue;
                    }
                    JAXPConfigurator.configure(appDir + File.separator + value, false);
                }
                catch (ProxoolException e) {
                    LOG.error((Object)("Problem configuring " + value), (Throwable)e);
                }
                continue;
            }
            if (name.equals(PROPERTY_FILE_PROPERTY)) {
                try {
                    file = new File(value);
                    if (file.isAbsolute()) {
                        PropertyConfigurator.configure(value);
                        continue;
                    }
                    PropertyConfigurator.configure(appDir + File.separator + value);
                }
                catch (ProxoolException e) {
                    LOG.error((Object)("Problem configuring " + value), (Throwable)e);
                }
                continue;
            }
            if (name.equals(AUTO_SHUTDOWN_PROPERTY)) {
                this.autoShutdown = Boolean.valueOf(value);
                continue;
            }
            if (!name.startsWith("jdbc")) continue;
            properties.setProperty(name, value);
        }
        if (properties.size() > 0) {
            try {
                PropertyConfigurator.configure(properties);
            }
            catch (ProxoolException e) {
                LOG.error((Object)"Problem configuring using init properties", (Throwable)e);
            }
        }
    }

    public void destroy() {
        if (this.autoShutdown) {
            ProxoolFacade.shutdown(0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

