/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin.jmx;

import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.admin.jmx.ConnectionPoolMBean;

public class ProxoolJMXHelper {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$admin$jmx$ProxoolJMXHelper == null ? (class$org$logicalcobwebs$proxool$admin$jmx$ProxoolJMXHelper = ProxoolJMXHelper.class$("org.logicalcobwebs.proxool.admin.jmx.ProxoolJMXHelper")) : class$org$logicalcobwebs$proxool$admin$jmx$ProxoolJMXHelper));
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$admin$jmx$ProxoolJMXHelper;

    private ProxoolJMXHelper() {
    }

    public static void registerPool(String alias, Properties poolPropeties) throws ProxoolException {
        ConnectionPoolDefinitionIF connectionPoolDefinition = ProxoolFacade.getConnectionPoolDefinition(alias);
        String[] agentIds = ProxoolJMXHelper.getAgentIds(poolPropeties);
        ArrayList<MBeanServer> servers = null;
        for (int i = 0; i < agentIds.length; ++i) {
            servers = MBeanServerFactory.findMBeanServer(agentIds[i]);
            if (servers == null || servers.size() < 1) {
                LOG.error((Object)("Could not register pool " + connectionPoolDefinition.getAlias() + " for JMX instrumentation" + " because lookup of MBeanServer using agent id " + agentIds[i] + " failed."));
                continue;
            }
            MBeanServer mBeanServer = servers.get(0);
            ConnectionPoolMBean poolMBean = new ConnectionPoolMBean(alias, poolPropeties);
            try {
                mBeanServer.registerMBean(poolMBean, ProxoolJMXHelper.getObjectName(connectionPoolDefinition.getAlias()));
                LOG.info((Object)("Registered JMX MBean for pool " + connectionPoolDefinition.getAlias() + " in agent " + agentIds[i]));
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("Registration of JMX MBean for pool " + connectionPoolDefinition.getAlias() + "in agent " + agentIds[i] + " failed."), (Throwable)e);
            }
        }
    }

    public static void unregisterPool(String alias, Properties poolPropeties) {
        String[] agentIds = ProxoolJMXHelper.getAgentIds(poolPropeties);
        ArrayList<MBeanServer> servers = null;
        for (int i = 0; i < agentIds.length; ++i) {
            servers = MBeanServerFactory.findMBeanServer(agentIds[i]);
            if (servers == null || servers.size() < 1) {
                LOG.error((Object)("Could not unregister MBean for pool " + alias + " because lookup of MBeanServer using agent id " + agentIds[i] + " failed."));
                continue;
            }
            MBeanServer mBeanServer = servers.get(0);
            try {
                mBeanServer.unregisterMBean(ProxoolJMXHelper.getObjectName(alias));
                LOG.info((Object)("Unregistered JMX MBean for pool " + alias + " in agent " + agentIds[i]));
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("Unregistration of JMX MBean for pool " + alias + "in agent " + agentIds[i] + " failed."), (Throwable)e);
            }
        }
    }

    public static ObjectName getObjectName(String alias) throws MalformedObjectNameException {
        return new ObjectName("Proxool:type=Pool, name=" + alias);
    }

    private static String[] getAgentIds(Properties poolPropeties) {
        String idString = poolPropeties.getProperty("proxool.jmx-agent-id");
        if (idString == null || idString.trim().equals("")) {
            return new String[]{null};
        }
        StringTokenizer tokenizer = new StringTokenizer(idString, ",");
        ArrayList<String> tokens = new ArrayList<String>(3);
        while (tokenizer.hasMoreElements()) {
            tokens.add(tokenizer.nextToken().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String getValidIdentifier(String propertyName) {
        if (propertyName.indexOf("-") == -1) {
            return propertyName;
        }
        StringBuffer buffer = new StringBuffer(propertyName);
        int index = -1;
        while ((index = buffer.toString().indexOf("-")) > -1) {
            buffer.deleteCharAt(index);
            buffer.setCharAt(index, Character.toUpperCase(buffer.charAt(index)));
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

