/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.expression;

import org.apache.taglibs.standard.lang.jpath.expression.SimpleNode;

public class ValidationException
extends Exception {
    protected boolean specialConstructor;
    public String image;
    protected SimpleNode node;
    protected String eol = System.getProperty("line.separator", "\n");

    public ValidationException() {
        this.specialConstructor = false;
    }

    public ValidationException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public ValidationException(SimpleNode currentNode, String message) {
        super(message);
        this.specialConstructor = true;
        this.node = currentNode;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        boolean maxSize = true;
        String retval = this.eol + "Encountered \"";
        retval = retval + super.getMessage();
        retval = retval + "\"" + this.eol;
        retval = retval + "at : " + this.eol;
        retval = retval + this.node.rootOriginalString() + this.eol;
        int i = 0;
        while (i < this.node.firstToken.beginColumn - 1) {
            retval = retval + " ";
            ++i;
        }
        int i2 = 0;
        while (i2 < this.node.lastToken.endColumn - (this.node.firstToken.beginColumn - 1)) {
            retval = retval + "^";
            ++i2;
        }
        retval = retval + this.eol;
        retval = retval + "beginning at column " + this.node.firstToken.beginColumn + "." + this.eol;
        retval = retval + "ending at column " + this.node.lastToken.endColumn + "." + this.eol;
        return retval;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

