/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.chatroom;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openymsg.network.chatroom.YahooChatUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooChatLobby {
    private int lobbyNumber;
    private final long parentRoomId;
    private final String networkName;
    private final Map<String, YahooChatUser> users;
    private int reportedWebcams = -1;
    private int reportedUsers = -1;
    private int reportedVoices = -1;

    public YahooChatLobby(String string, long l, int n) {
        this.lobbyNumber = n;
        this.parentRoomId = l;
        this.users = new HashMap<String, YahooChatUser>();
        this.networkName = string + ":" + this.lobbyNumber;
    }

    public void addUser(YahooChatUser yahooChatUser) {
        if (yahooChatUser == null) {
            throw new IllegalArgumentException("Argument 'yahooChatUser' cannot be null.");
        }
        this.users.put(yahooChatUser.getId(), yahooChatUser);
    }

    public void removeUser(YahooChatUser yahooChatUser) {
        this.users.remove(yahooChatUser.getId());
    }

    public void clearUsers() {
        this.users.clear();
    }

    public boolean exists(YahooChatUser yahooChatUser) {
        return this.users.containsKey(yahooChatUser.getId());
    }

    public YahooChatUser getUser(String string) {
        return this.users.get(string);
    }

    public int getLobbyNumber() {
        return this.lobbyNumber;
    }

    public int getUserCount() {
        return this.users.size();
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public Collection<YahooChatUser> getMembers() {
        return this.users.values();
    }

    public String toString() {
        return "YahooChatLobby '" + this.networkName + "'";
    }

    public int getReportedUsers() {
        return this.reportedUsers;
    }

    public int getReportedVoices() {
        return this.reportedVoices;
    }

    public int getReportedWebcams() {
        return this.reportedWebcams;
    }

    public void setReportedUsers(int n) {
        this.reportedUsers = n;
    }

    public void setReportedVoices(int n) {
        this.reportedVoices = n;
    }

    public void setReportedWebcams(int n) {
        this.reportedWebcams = n;
    }

    public long getParentRoomId() {
        return this.parentRoomId;
    }
}

