/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public class PrivacyItem
extends AbstractItemObj
implements SsiItemObjectWithId {
    public static final int MODE_ALLOW_ALL = 1;
    public static final int MODE_BLOCK_ALL = 2;
    public static final int MODE_ALLOW_PERMITS = 3;
    public static final int MODE_BLOCK_DENIES = 4;
    public static final int MODE_ALLOW_BUDDIES = 5;
    public static final long VISMASK_HIDE_WIRELESS = 2L;
    private static final String NAME_DEFAULT = "";
    private static final int PARENTID_DEFAULT = 0;
    private static final int TYPE_PRIVACY_MODE = 202;
    private static final int TYPE_CLASS_MASK = 203;
    private static final int TYPE_VISIBLE_MASK = 204;
    private final int id;
    private int privacyMode;
    private long classMask;
    private long visibleMask;

    public PrivacyItem(SsiItem item) {
        DefensiveTools.checkNull((Object)item, (String)"item");
        ImmutableTlvChain chain = TlvTools.readChain(item.getData());
        this.id = item.getId();
        Tlv typeTlv = chain.getLastTlv(202);
        this.privacyMode = typeTlv != null ? (int)BinaryTools.getUByte((ByteBlock)typeTlv.getData(), (int)0) : -1;
        Tlv classMaskTlv = chain.getLastTlv(203);
        this.classMask = classMaskTlv != null ? BinaryTools.getUInt((ByteBlock)classMaskTlv.getData(), (int)0) : -1L;
        Tlv visibleMaskTlv = chain.getLastTlv(204);
        this.visibleMask = visibleMaskTlv != null ? BinaryTools.getUInt((ByteBlock)visibleMaskTlv.getData(), (int)0) : -1L;
        MutableTlvChain extraTlvs = TlvTools.getMutableCopy(chain);
        extraTlvs.removeTlvs(202, 203, 204);
        this.addExtraTlvs(extraTlvs);
    }

    public PrivacyItem(PrivacyItem other) {
        this(other.id, other.privacyMode, other.classMask, other.visibleMask, other.copyExtraTlvs());
    }

    public PrivacyItem(int id, int mode, long visibleMask) {
        this(id, mode, 0xFFFFFFFFL, visibleMask);
    }

    public PrivacyItem(int id, int mode, long classMask, long visibleMask) {
        this(id, mode, classMask, visibleMask, null);
    }

    public PrivacyItem(int id, int mode, long classMask, long visibleMask, TlvChain extraTlvs) {
        super(extraTlvs);
        DefensiveTools.checkRange((int)id, (String)"id", (int)0);
        DefensiveTools.checkRange((int)mode, (String)"mode", (int)-1);
        DefensiveTools.checkRange((long)classMask, (String)"classMask", (long)-1L);
        DefensiveTools.checkRange((long)visibleMask, (String)"visibleMask", (long)-1L);
        this.id = id;
        this.privacyMode = mode;
        this.classMask = classMask;
        this.visibleMask = visibleMask;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized int getPrivacyMode() {
        return this.privacyMode;
    }

    public final synchronized long getClassMask() {
        return this.classMask;
    }

    public final synchronized long getVisibleMask() {
        return this.visibleMask;
    }

    public final synchronized void setPrivacyMode(int privacyMode) {
        this.privacyMode = privacyMode;
    }

    public final synchronized void setClassMask(long classMask) {
        this.classMask = classMask;
    }

    public final synchronized void setVisibleMask(long visibleMask) {
        this.visibleMask = visibleMask;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain chain = TlvTools.createMutableChain();
        if (this.privacyMode != -1) {
            chain.addTlv(new Tlv(202, (Writable)ByteBlock.wrap((byte[])BinaryTools.getUByte((int)this.privacyMode))));
        }
        if (this.classMask != -1L) {
            chain.addTlv(Tlv.getUIntInstance(203, this.classMask));
        }
        if (this.visibleMask != -1L) {
            chain.addTlv(Tlv.getUIntInstance(204, this.visibleMask));
        }
        return this.generateItem(NAME_DEFAULT, 0, this.id, 4, chain);
    }

    public synchronized String toString() {
        return "PrivacyItem: id=0x" + Integer.toHexString(this.id) + ", mode=" + this.privacyMode + " (" + MiscTools.findIntField(PrivacyItem.class, this.privacyMode, "MODE_.*") + ")" + ", classMask=0x" + Long.toHexString(this.classMask) + " (" + MiscTools.getFlagFieldsString(FullUserInfo.class, this.classMask, "VISMASK_.*") + ")" + ", visMask=0x" + Long.toHexString(this.visibleMask) + " (" + MiscTools.getFlagFieldsString(FullUserInfo.class, this.visibleMask, "MASK_.*") + ")";
    }
}

