/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Timer;
import com.sun.speech.freetts.util.Utilities;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

public class JavaClipAudioPlayer
implements AudioPlayer {
    private static final Logger LOGGER = Logger.getLogger(JavaClipAudioPlayer.class.getName());
    private volatile boolean paused;
    private volatile boolean cancelled = false;
    private volatile Clip currentClip;
    private float volume = 1.0f;
    private boolean audioMetrics = false;
    private final BulkTimer timer = new BulkTimer();
    private AudioFormat defaultFormat;
    private AudioFormat currentFormat = this.defaultFormat = new AudioFormat(8000.0f, 16, 1, true, true);
    private boolean firstSample = true;
    private boolean firstPlay = true;
    private int curIndex = 0;
    private final PipedOutputStream outputData;
    private AudioInputStream audioInput;
    private final LineListener lineListener;
    private long drainDelay = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.drainDelay", 150L);
    private long openFailDelayMs = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.openFailDelayMs", 0L);
    private long totalOpenFailDelayMs = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.totalOpenFailDelayMs", 0L);

    public JavaClipAudioPlayer() {
        this.audioMetrics = Utilities.getBoolean("com.sun.speech.freetts.audio.AudioPlayer.showAudioMetrics");
        this.setPaused(false);
        this.outputData = new PipedOutputStream();
        this.lineListener = new JavaClipLineListener();
    }

    @Override
    public synchronized void setAudioFormat(AudioFormat format) {
        if (this.currentFormat.matches(format)) {
            return;
        }
        this.currentFormat = format;
        if (this.currentClip != null) {
            this.currentClip = null;
        }
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        if (!this.paused) {
            this.setPaused(true);
            if (this.currentClip != null) {
                this.currentClip.stop();
            }
            JavaClipAudioPlayer javaClipAudioPlayer = this;
            synchronized (javaClipAudioPlayer) {
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized void resume() {
        if (this.paused) {
            this.setPaused(false);
            if (this.currentClip != null) {
                this.currentClip.start();
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (this.audioMetrics) {
            this.timer.start("audioCancel");
        }
        if (this.currentClip != null) {
            this.currentClip.stop();
            this.currentClip.close();
        }
        JavaClipAudioPlayer javaClipAudioPlayer = this;
        synchronized (javaClipAudioPlayer) {
            this.cancelled = true;
            this.paused = false;
            this.notifyAll();
        }
        if (this.audioMetrics) {
            this.timer.stop("audioCancel");
            Timer.showTimesShortTitle("");
            this.timer.getTimer("audioCancel").showTimesShort(0L);
        }
    }

    @Override
    public synchronized void reset() {
        this.timer.start("speakableOut");
    }

    @Override
    public boolean drain() {
        this.timer.stop("speakableOut");
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.currentClip != null) {
            this.currentClip.drain();
            if (this.drainDelay > 0L) {
                try {
                    Thread.sleep(this.drainDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.currentClip.close();
        }
        this.notifyAll();
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(float volume) {
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        this.volume = volume;
        if (this.currentClip != null) {
            this.setVolume(this.currentClip, volume);
        }
    }

    private void setPaused(boolean state) {
        this.paused = state;
    }

    private void setVolume(Clip clip, float vol) {
        if (clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl volumeControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            float range = volumeControl.getMaximum() - volumeControl.getMinimum();
            volumeControl.setValue(vol * range + volumeControl.getMinimum());
        }
    }

    @Override
    public synchronized long getTime() {
        return -1L;
    }

    @Override
    public synchronized void resetTime() {
    }

    @Override
    public synchronized void begin(int size) throws IOException {
        this.timer.start("utteranceOutput");
        this.cancelled = false;
        this.curIndex = 0;
        try {
            PipedInputStream in = new PipedInputStream(this.outputData);
            this.audioInput = new AudioInputStream(in, this.currentFormat, size);
        }
        catch (IOException e) {
            LOGGER.warning(e.getLocalizedMessage());
        }
        while (this.paused && !this.cancelled) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                return;
            }
        }
        this.timer.start("clipGeneration");
        boolean opened = false;
        long totalDelayMs = 0L;
        do {
            try {
                this.currentClip = this.getClip();
                this.currentClip.open(this.audioInput);
                opened = true;
            }
            catch (LineUnavailableException lue) {
                System.err.println("LINE UNAVAILABLE: Format is " + this.currentFormat);
                try {
                    Thread.sleep(this.openFailDelayMs);
                    totalDelayMs += this.openFailDelayMs;
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        } while (!opened && totalDelayMs < this.totalOpenFailDelayMs);
        if (!opened) {
            this.close();
        } else {
            this.setVolume(this.currentClip, this.volume);
            if (this.audioMetrics && this.firstPlay) {
                this.firstPlay = false;
                this.timer.stop("firstPlay");
                this.timer.getTimer("firstPlay");
                Timer.showTimesShortTitle("");
                this.timer.getTimer("firstPlay").showTimesShort(0L);
            }
            this.currentClip.start();
        }
    }

    private Clip getClip() throws LineUnavailableException {
        if (this.currentClip == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("creating new clip");
            }
            DataLine.Info info = new DataLine.Info(Clip.class, this.currentFormat);
            try {
                this.currentClip = (Clip)AudioSystem.getLine(info);
                this.currentClip.addLineListener(this.lineListener);
            }
            catch (SecurityException e) {
                throw new LineUnavailableException(e.getLocalizedMessage());
            }
            catch (IllegalArgumentException e) {
                throw new LineUnavailableException(e.getLocalizedMessage());
            }
        }
        return this.currentClip;
    }

    @Override
    public synchronized boolean end() {
        boolean ok = true;
        if (this.cancelled) {
            return false;
        }
        if (this.currentClip == null || !this.currentClip.isOpen()) {
            this.close();
            ok = false;
        } else {
            this.setVolume(this.currentClip, this.volume);
            if (this.audioMetrics && this.firstPlay) {
                this.firstPlay = false;
                this.timer.stop("firstPlay");
                this.timer.getTimer("firstPlay");
                Timer.showTimesShortTitle("");
                this.timer.getTimer("firstPlay").showTimesShort(0L);
            }
            try {
                while (this.currentClip != null && (this.currentClip.isRunning() || this.paused) && !this.cancelled) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                ok = false;
            }
            this.close();
        }
        this.timer.stop("clipGeneration");
        this.timer.stop("utteranceOutput");
        return ok &= !this.cancelled;
    }

    @Override
    public boolean write(byte[] audioData) throws IOException {
        return this.write(audioData, 0, audioData.length);
    }

    @Override
    public boolean write(byte[] bytes, int offset, int size) throws IOException {
        if (this.firstSample) {
            this.firstSample = false;
            this.timer.stop("firstAudio");
            if (this.audioMetrics) {
                Timer.showTimesShortTitle("");
                this.timer.getTimer("firstAudio").showTimesShort(0L);
            }
        }
        this.outputData.write(bytes, offset, size);
        this.curIndex += size;
        return true;
    }

    public String toString() {
        return "JavaClipAudioPlayer";
    }

    @Override
    public void showMetrics() {
        this.timer.show(this.toString());
    }

    @Override
    public void startFirstSampleTimer() {
        this.timer.start("firstAudio");
        this.firstSample = true;
        if (this.audioMetrics) {
            this.timer.start("firstPlay");
            this.firstPlay = true;
        }
    }

    private class JavaClipLineListener
    implements LineListener {
        private JavaClipLineListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(LineEvent event) {
            if (event.getType().equals(LineEvent.Type.START)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(this.toString() + ": EVENT START");
                }
            } else {
                if (event.getType().equals(LineEvent.Type.STOP)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this.toString() + ": EVENT STOP");
                    }
                    JavaClipAudioPlayer javaClipAudioPlayer = JavaClipAudioPlayer.this;
                    synchronized (javaClipAudioPlayer) {
                        JavaClipAudioPlayer.this.notifyAll();
                    }
                }
                if (event.getType().equals(LineEvent.Type.OPEN)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this.toString() + ": EVENT OPEN");
                    }
                } else if (event.getType().equals(LineEvent.Type.CLOSE)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this.toString() + ": EVENT CLOSE");
                    }
                    JavaClipAudioPlayer javaClipAudioPlayer = JavaClipAudioPlayer.this;
                    synchronized (javaClipAudioPlayer) {
                        JavaClipAudioPlayer.this.notifyAll();
                    }
                }
            }
        }
    }
}

