/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.cache.impl.operation.CacheGetConfigOperation;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CacheGetConfigRequest
extends AbstractCacheRequest {
    private String simpleName;

    public CacheGetConfigRequest() {
    }

    public CacheGetConfigRequest(String cacheName, String simpleName, InMemoryFormat inMemoryFormat) {
        super(cacheName, inMemoryFormat);
        this.simpleName = simpleName;
    }

    @Override
    protected Object getKey() {
        return this.name;
    }

    @Override
    protected Operation prepareOperation() {
        return new CacheGetConfigOperation(this.name, this.simpleName);
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("s", this.simpleName);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.simpleName = reader.readUTF("s");
    }
}

