/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.CommandRegister;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.AbstractCommand;
import java.util.Date;
import org.apache.log4j.Logger;

public class TopicCommand
extends AbstractCommand {
    static Logger log = Logger.getLogger(TopicCommand.class);
    private String channel;
    private String topic;
    public static final String IDENTIFIER_PRIMARY = "TOPIC";
    public static final String IDENTIFIER_SECONDARY = "332";

    public TopicCommand() {
        this(null, null);
    }

    public TopicCommand(String channel, String topic) {
        this.channel = channel;
        this.topic = topic;
    }

    public String getIrcIdentifier() {
        return IDENTIFIER_PRIMARY;
    }

    public void selfRegister(CommandRegister commandRegister) {
        commandRegister.addCommand(IDENTIFIER_PRIMARY, this);
        commandRegister.addCommand(IDENTIFIER_SECONDARY, this);
    }

    public InCommand parse(String prefix, String identifier, String params) {
        if (identifier.equals(IDENTIFIER_SECONDARY)) {
            return new TopicCommand(this.getParameter(params, 1), this.getParameter(params, 2));
        }
        return new TopicCommand(this.getParameter(params, 0), this.getParameter(params, 1));
    }

    public String renderParams() {
        return this.getChannel() + " :" + this.getTopic();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getChannel() {
        return this.channel;
    }

    public boolean updateClientState(ClientState state) {
        log.debug((Object)("Topic: Channel: " + this.channel));
        Channel chan = state.getChannel(this.channel);
        chan.setTopic(this.topic);
        chan.setTopicDate(new Date());
        return true;
    }
}

