/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringHolder
implements Cloneable {
    private final Map<String, String> properties = new LinkedHashMap<String, String>();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public int getIntProperty(String string) {
        return this.getIntProperty(string, 0);
    }

    public int getIntProperty(String string, int n) {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return NumberUtils.stringToInt(string2, n);
        }
        return n;
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public void setProperty(String string, int n) {
        this.setProperty(string, String.valueOf(n));
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public void clear() {
        this.properties.clear();
    }

    public void parseString(String string) {
        this.properties.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.trim().length() == 0) continue;
            int n = string2.indexOf(58);
            if (n > 0) {
                String string3 = string2.substring(0, n);
                String string4 = StringUtils.ltrim(string2.substring(n + 1));
                this.setProperty(string3, string4);
                continue;
            }
            this.setProperty(string2, null);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            stringBuffer.append(entry.getKey()).append(": ").append(entry.getValue()).append("\r\n");
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        StringHolder stringHolder = new StringHolder();
        stringHolder.properties.putAll(this.properties);
        return stringHolder;
    }
}

