/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.quicktime;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jitsi.impl.neomedia.quicktime.NSErrorException;
import org.jitsi.impl.neomedia.quicktime.NSObject;
import org.jitsi.impl.neomedia.quicktime.QTFormatDescription;
import org.jitsi.impl.neomedia.quicktime.QTMediaType;

public class QTCaptureDevice
extends NSObject {
    private static final Map<QTMediaType, List<QTCaptureDevice>> inputDevices = new HashMap<QTMediaType, List<QTCaptureDevice>>();
    private static final QTFormatDescription[] NO_FORMAT_DESCRIPTIONS = new QTFormatDescription[0];
    private static final QTCaptureDevice[] NO_INPUT_DEVICES = new QTCaptureDevice[0];

    public QTCaptureDevice(long ptr) {
        super(ptr);
    }

    public void close() {
        QTCaptureDevice.close(this.getPtr());
    }

    private static native void close(long var0);

    public static QTCaptureDevice deviceWithUniqueID(String deviceUID) {
        QTCaptureDevice[] inputDevices = QTCaptureDevice.inputDevicesWithMediaType(QTMediaType.Video);
        QTCaptureDevice deviceWithUniqueID = QTCaptureDevice.deviceWithUniqueID(deviceUID, inputDevices);
        if (deviceWithUniqueID == null) {
            inputDevices = QTCaptureDevice.inputDevicesWithMediaType(QTMediaType.Sound);
            deviceWithUniqueID = QTCaptureDevice.deviceWithUniqueID(deviceUID, inputDevices);
        }
        return deviceWithUniqueID;
    }

    private static QTCaptureDevice deviceWithUniqueID(String deviceUID, QTCaptureDevice[] inputDevices) {
        if (inputDevices != null) {
            for (QTCaptureDevice inputDevice : inputDevices) {
                if (!deviceUID.equals(inputDevice.uniqueID())) continue;
                return inputDevice;
            }
        }
        return null;
    }

    protected void finalize() {
        this.release();
    }

    public QTFormatDescription[] formatDescriptions() {
        QTFormatDescription[] formatDescriptions;
        long[] formatDescriptionPtrs = QTCaptureDevice.formatDescriptions(this.getPtr());
        if (formatDescriptionPtrs == null) {
            formatDescriptions = NO_FORMAT_DESCRIPTIONS;
        } else {
            int formatDescriptionCount = formatDescriptionPtrs.length;
            if (formatDescriptionCount == 0) {
                formatDescriptions = NO_FORMAT_DESCRIPTIONS;
            } else {
                formatDescriptions = new QTFormatDescription[formatDescriptionCount];
                for (int i = 0; i < formatDescriptionCount; ++i) {
                    formatDescriptions[i] = new QTFormatDescription(formatDescriptionPtrs[i]);
                }
            }
        }
        return formatDescriptions;
    }

    private static native long[] formatDescriptions(long var0);

    public static QTCaptureDevice[] inputDevicesWithMediaType(QTMediaType mediaType) {
        QTCaptureDevice[] inputDevicesWithMediaType;
        int inputDeviceCount;
        long[] inputDevicePtrs = QTCaptureDevice.inputDevicesWithMediaType(mediaType.name());
        int n = inputDeviceCount = inputDevicePtrs == null ? 0 : inputDevicePtrs.length;
        if (inputDeviceCount == 0) {
            inputDevicesWithMediaType = NO_INPUT_DEVICES;
            inputDevices.remove((Object)mediaType);
        } else {
            inputDevicesWithMediaType = new QTCaptureDevice[inputDeviceCount];
            List<QTCaptureDevice> cachedInputDevicesWithMediaType = inputDevices.get((Object)mediaType);
            if (cachedInputDevicesWithMediaType == null) {
                cachedInputDevicesWithMediaType = new LinkedList<QTCaptureDevice>();
                inputDevices.put(mediaType, cachedInputDevicesWithMediaType);
            }
            for (int i = 0; i < inputDeviceCount; ++i) {
                long inputDevicePtr = inputDevicePtrs[i];
                QTCaptureDevice inputDevice = null;
                for (QTCaptureDevice cachedInputDevice : cachedInputDevicesWithMediaType) {
                    if (inputDevicePtr != cachedInputDevice.getPtr()) continue;
                    inputDevice = cachedInputDevice;
                    break;
                }
                if (inputDevice == null) {
                    inputDevice = new QTCaptureDevice(inputDevicePtr);
                    cachedInputDevicesWithMediaType.add(inputDevice);
                } else {
                    NSObject.release(inputDevicePtr);
                }
                inputDevicesWithMediaType[i] = inputDevice;
            }
            Iterator<QTCaptureDevice> cachedInputDeviceIter = cachedInputDevicesWithMediaType.iterator();
            while (cachedInputDeviceIter.hasNext()) {
                long cachedInputDevicePtr = cachedInputDeviceIter.next().getPtr();
                boolean remove = true;
                for (long inputDevicePtr : inputDevicePtrs) {
                    if (cachedInputDevicePtr != inputDevicePtr) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                cachedInputDeviceIter.remove();
            }
        }
        return inputDevicesWithMediaType;
    }

    private static native long[] inputDevicesWithMediaType(String var0);

    public boolean isConnected() {
        return QTCaptureDevice.isConnected(this.getPtr());
    }

    private static native boolean isConnected(long var0);

    public String localizedDisplayName() {
        return QTCaptureDevice.localizedDisplayName(this.getPtr());
    }

    private static native String localizedDisplayName(long var0);

    public boolean open() throws NSErrorException {
        return QTCaptureDevice.open(this.getPtr());
    }

    private static native boolean open(long var0) throws NSErrorException;

    public String uniqueID() {
        return QTCaptureDevice.uniqueID(this.getPtr());
    }

    private static native String uniqueID(long var0);
}

