/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack.container;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.whack.ExternalComponentManager;
import org.jivesoftware.whack.container.ComponentFinder;
import org.jivesoftware.whack.container.ServerContainer;
import org.xmpp.component.Component;

public class ComponentServlet
extends HttpServlet {
    private static Map<String, HttpServlet> servlets = new ConcurrentHashMap<String, HttpServlet>();
    private static File componentDirectory = new File(ServerContainer.getInstance().getHomeDirectory(), "components");
    private static ServletConfig servletConfig;
    private static ExternalComponentManager manager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        servletConfig = config;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.setStatus(404);
            return;
        }
        try {
            if (pathInfo.endsWith(".jsp")) {
                this.handleJSP(pathInfo, request, response);
                return;
            }
            if (pathInfo.endsWith(".gif") || pathInfo.endsWith(".png")) {
                this.handleImage(pathInfo, response);
                return;
            }
            if (!servlets.containsKey(pathInfo.substring(1).toLowerCase())) {
                response.setStatus(404);
                return;
            }
            this.handleServlet(pathInfo, request, response);
        }
        catch (Exception e) {
            manager.getLog().error(e);
            response.setStatus(500);
            return;
        }
    }

    public static void registerServlets(ComponentFinder finder, Component component, File webXML) {
        if (!webXML.exists()) {
            manager.getLog().error("Could not register component servlets, file " + webXML.getAbsolutePath() + " does not exist.");
            return;
        }
        String pluginName = webXML.getParentFile().getParentFile().getName();
        try {
            SAXReader saxReader = new SAXReader(false);
            saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = saxReader.read(webXML);
            List classes = doc.selectNodes("//servlet");
            HashMap<String, Class> classMap = new HashMap<String, Class>();
            for (int i = 0; i < classes.size(); ++i) {
                Element servletElement = (Element)classes.get(i);
                String name = servletElement.element("servlet-name").getTextTrim();
                String className = servletElement.element("servlet-class").getTextTrim();
                classMap.put(name, finder.loadClass(className, component));
            }
            List names = doc.selectNodes("//servlet-mapping");
            for (int i = 0; i < names.size(); ++i) {
                Element nameElement = (Element)names.get(i);
                String name = nameElement.element("servlet-name").getTextTrim();
                String url = nameElement.element("url-pattern").getTextTrim();
                Class servletClass = (Class)classMap.get(name);
                Object instance = servletClass.newInstance();
                if (instance instanceof HttpServlet) {
                    ((HttpServlet)instance).init(servletConfig);
                    servlets.put(pluginName + url, (HttpServlet)instance);
                    continue;
                }
                manager.getLog().warn("Could not load " + pluginName + url + ": not a servlet.");
            }
        }
        catch (Throwable e) {
            manager.getLog().error(e);
        }
    }

    public static void unregisterServlets(File webXML) {
        if (!webXML.exists()) {
            manager.getLog().error("Could not unregister component servlets, file " + webXML.getAbsolutePath() + " does not exist.");
            return;
        }
        String pluginName = webXML.getParentFile().getParentFile().getName();
        try {
            SAXReader saxReader = new SAXReader(false);
            saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = saxReader.read(webXML);
            List names = doc.selectNodes("//servlet-mapping");
            for (int i = 0; i < names.size(); ++i) {
                Element nameElement = (Element)names.get(i);
                String url = nameElement.element("url-pattern").getTextTrim();
                HttpServlet servlet = servlets.get(pluginName + url);
                servlet.destroy();
                servlets.remove(pluginName + url);
                servlet = null;
            }
        }
        catch (Throwable e) {
            manager.getLog().error(e);
        }
    }

    private void handleJSP(String pathInfo, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jspURL = pathInfo.substring(1);
        HttpServlet servlet = servlets.get(jspURL);
        if (servlet != null) {
            servlet.service((ServletRequest)request, (ServletResponse)response);
            return;
        }
        response.setStatus(404);
    }

    private void handleServlet(String pathInfo, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jspURL = pathInfo.substring(1);
        HttpServlet servlet = servlets.get(jspURL);
        if (servlet != null) {
            servlet.service((ServletRequest)request, (ServletResponse)response);
            return;
        }
        response.setStatus(404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImage(String pathInfo, HttpServletResponse response) throws IOException {
        String[] parts = pathInfo.split("/");
        if (parts.length != 4) {
            response.setStatus(404);
            return;
        }
        File image = new File(componentDirectory, parts[1] + File.separator + "web" + File.separator + "images" + File.separator + parts[3]);
        if (!image.exists()) {
            response.setStatus(404);
            return;
        }
        String contentType = "image/gif";
        if (pathInfo.endsWith(".png")) {
            contentType = "image/png";
        }
        response.setHeader("Content-disposition", "filename=\"" + image + "\";");
        response.setContentType(contentType);
        InputStream in = null;
        ServletOutputStream out = null;
        try {
            int len;
            in = new BufferedInputStream(new FileInputStream(image));
            out = response.getOutputStream();
            response.setContentLength((int)image.length());
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignored) {}
            try {
                out.close();
            }
            catch (Exception ignored) {}
        }
    }

    static {
        manager = (ExternalComponentManager)ServerContainer.getInstance().getManager();
    }
}

