/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.packets;

import gnu.java.zrtp.ZrtpConstants;
import gnu.java.zrtp.packets.ZrtpPacketBase;
import gnu.java.zrtp.utils.ZrtpUtils;

public class ZrtpPacketDHPart
extends ZrtpPacketBase {
    private int dhLength;
    private static final int HASH_H1_OFFSET = 12;
    private static final int RS1ID_OFFSET = 44;
    private static final int RS2ID_OFFSET = 52;
    private static final int S3_ID_OFFSET = 60;
    private static final int PBX_SECRET_ID_OFFSET = 68;
    private static final int PUBLIC_KEY_OFFSET = 76;
    private static final int ZRTP_DHPART_FIXED_LENGTH = 16;
    private static final int DHPART_FIXED_LENGTH = 80;

    public ZrtpPacketDHPart() {
        super(null);
    }

    public ZrtpPacketDHPart(ZrtpConstants.SupportedPubKeys pkt) {
        super(null);
        this.setPubKeyType(pkt);
    }

    public ZrtpPacketDHPart(byte[] data) {
        super(data);
        short len = this.getLength();
        if (len == 85) {
            this.dhLength = 256;
        } else if (len == 117) {
            this.dhLength = 384;
        } else if (len == 37) {
            this.dhLength = 64;
        } else if (len == 45) {
            this.dhLength = 96;
        } else {
            this.dhLength = 0;
            return;
        }
    }

    public void setPubKeyType(ZrtpConstants.SupportedPubKeys pkt) {
        if (pkt == ZrtpConstants.SupportedPubKeys.DH2K) {
            this.dhLength = 256;
        } else if (pkt == ZrtpConstants.SupportedPubKeys.DH3K) {
            this.dhLength = 384;
        } else if (pkt == ZrtpConstants.SupportedPubKeys.EC25) {
            this.dhLength = 64;
        } else if (pkt == ZrtpConstants.SupportedPubKeys.EC38) {
            this.dhLength = 96;
        } else {
            return;
        }
        int length = 80 + this.dhLength + 8;
        this.packetBuffer = new byte[length];
        this.setLength((length - 4) / 4);
        this.setZrtpId();
    }

    public final byte[] getPv() {
        return ZrtpUtils.readRegion(this.packetBuffer, 76, this.dhLength);
    }

    public final byte[] getRs1Id() {
        return ZrtpUtils.readRegion(this.packetBuffer, 44, 8);
    }

    public final byte[] getRs2Id() {
        return ZrtpUtils.readRegion(this.packetBuffer, 52, 8);
    }

    public final byte[] getAuxSecretId() {
        return ZrtpUtils.readRegion(this.packetBuffer, 60, 8);
    }

    public final byte[] getPbxSecretId() {
        return ZrtpUtils.readRegion(this.packetBuffer, 68, 8);
    }

    public final byte[] getH1() {
        return ZrtpUtils.readRegion(this.packetBuffer, 12, 32);
    }

    public final byte[] getHMAC() {
        return ZrtpUtils.readRegion(this.packetBuffer, 76 + this.dhLength, 8);
    }

    public final boolean isLengthOk() {
        return this.getLength() >= 37;
    }

    public final void setPv(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 76, this.dhLength);
    }

    public final void setRs1Id(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 44, 8);
    }

    public final void setRs2Id(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 52, 8);
    }

    public final void setAuxSecretId(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 60, 8);
    }

    public final void setPbxSecretId(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 68, 8);
    }

    public final void setH1(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 12, 32);
    }

    public final void setHMAC(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 76 + this.dhLength, 8);
    }
}

