/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.notification.NotificationEventIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.notification.NotificationEventIQProvider;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetGenericNotifications;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.GenericEvent;
import net.java.sip.communicator.service.protocol.event.GenericEventListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;

public class OperationSetGenericNotificationsJabberImpl
implements OperationSetGenericNotifications,
PacketListener {
    private static final Logger logger = Logger.getLogger(OperationSetGenericNotificationsJabberImpl.class);
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private final Map<String, List<GenericEventListener>> genericEventListeners = new HashMap<String, List<GenericEventListener>>();

    OperationSetGenericNotificationsJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.jabberProvider = provider;
        provider.addRegistrationStateChangeListener(new RegistrationStateListener());
        ProviderManager.getInstance().addIQProvider("notification", "sip-communicator:iq:notification", (Object)new NotificationEventIQProvider());
    }

    public void notifyForEvent(Contact contact, String eventName, String eventValue) {
        if (!this.jabberProvider.isRegistered()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("provider not registered. won't send keep alive. acc.id=" + this.jabberProvider.getAccountID().getAccountUniqueID()));
            }
            return;
        }
        NotificationEventIQ newEvent = new NotificationEventIQ();
        newEvent.setEventName(eventName);
        newEvent.setEventValue(eventValue);
        newEvent.setTo(contact.getAddress());
        newEvent.setEventSource(this.jabberProvider.getOurJID());
        this.jabberProvider.getConnection().sendPacket((Packet)newEvent);
    }

    public void notifyForEvent(String jid, String eventName, String eventValue) {
        this.notifyForEvent(jid, eventName, eventValue, null);
    }

    public void notifyForEvent(String jid, String eventName, String eventValue, String source) {
        if (!this.jabberProvider.isRegistered()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("provider not registered. won't send keep alive. acc.id=" + this.jabberProvider.getAccountID().getAccountUniqueID()));
            }
            return;
        }
        String fullJid = this.jabberProvider.getFullJid(jid);
        if (fullJid != null) {
            jid = fullJid;
        }
        NotificationEventIQ newEvent = new NotificationEventIQ();
        newEvent.setEventName(eventName);
        newEvent.setEventValue(eventValue);
        newEvent.setTo(jid);
        if (source != null) {
            newEvent.setEventSource(source);
        } else {
            newEvent.setEventSource(this.jabberProvider.getOurJID());
        }
        this.jabberProvider.getConnection().sendPacket((Packet)newEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGenericEventListener(String eventName, GenericEventListener listener) {
        Map<String, List<GenericEventListener>> map = this.genericEventListeners;
        synchronized (map) {
            List<GenericEventListener> l = this.genericEventListeners.get(eventName);
            if (l == null) {
                l = new ArrayList<GenericEventListener>();
                this.genericEventListeners.put(eventName, l);
            }
            if (!l.contains(listener)) {
                l.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGenericEventListener(String eventName, GenericEventListener listener) {
        Map<String, List<GenericEventListener>> map = this.genericEventListeners;
        synchronized (map) {
            List<GenericEventListener> listenerList = this.genericEventListeners.get(eventName);
            if (listenerList != null) {
                listenerList.remove(listener);
            }
        }
    }

    public void processPacket(Packet packet) {
        String fromUserID;
        Object sender;
        if (packet != null && !(packet instanceof NotificationEventIQ)) {
            return;
        }
        NotificationEventIQ notifyEvent = (NotificationEventIQ)packet;
        if (logger.isDebugEnabled() && logger.isDebugEnabled()) {
            logger.debug((Object)("Received notificationEvent from " + notifyEvent.getFrom() + " msg : " + notifyEvent.toXML()));
        }
        if ((sender = this.opSetPersPresence.findContactByID(fromUserID = StringUtils.parseBareAddress((String)notifyEvent.getFrom()))) == null) {
            sender = this.opSetPersPresence.createVolatileContact(notifyEvent.getFrom());
        }
        if (notifyEvent.getType() == IQ.Type.GET) {
            this.fireNewEventNotification((Contact)sender, notifyEvent.getEventName(), notifyEvent.getEventValue(), notifyEvent.getEventSource(), true);
        } else if (notifyEvent.getType() == IQ.Type.ERROR) {
            this.fireNewEventNotification((Contact)sender, notifyEvent.getEventName(), notifyEvent.getEventValue(), notifyEvent.getEventSource(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNewEventNotification(Contact from, String eventName, String eventValue, String source, boolean incoming) {
        ArrayList<GenericEventListener> listeners;
        String sourceUserID = StringUtils.parseBareAddress((String)source);
        Object sourceContact = this.opSetPersPresence.findContactByID(sourceUserID);
        if (sourceContact == null) {
            sourceContact = this.opSetPersPresence.createVolatileContact(source);
        }
        GenericEvent event = new GenericEvent((ProtocolProviderService)this.jabberProvider, from, eventName, eventValue, sourceContact);
        Map<String, List<GenericEventListener>> map = this.genericEventListeners;
        synchronized (map) {
            List<GenericEventListener> ls = this.genericEventListeners.get(eventName);
            if (ls == null) {
                return;
            }
            listeners = new ArrayList<GenericEventListener>(ls);
        }
        for (GenericEventListener listener : listeners) {
            if (incoming) {
                listener.notificationReceived(event);
                continue;
            }
            listener.notificationDeliveryFailed(event);
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                OperationSetGenericNotificationsJabberImpl.this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)OperationSetGenericNotificationsJabberImpl.this.jabberProvider.getOperationSet(OperationSetPersistentPresence.class);
                if (OperationSetGenericNotificationsJabberImpl.this.jabberProvider.getConnection() != null) {
                    OperationSetGenericNotificationsJabberImpl.this.jabberProvider.getConnection().addPacketListener((PacketListener)OperationSetGenericNotificationsJabberImpl.this, (PacketFilter)new PacketTypeFilter(NotificationEventIQ.class));
                }
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.CONNECTION_FAILED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED) {
                if (OperationSetGenericNotificationsJabberImpl.this.jabberProvider.getConnection() != null) {
                    OperationSetGenericNotificationsJabberImpl.this.jabberProvider.getConnection().removePacketListener((PacketListener)OperationSetGenericNotificationsJabberImpl.this);
                }
                OperationSetGenericNotificationsJabberImpl.this.opSetPersPresence = null;
            }
        }
    }
}

