/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import ch.imvs.sdes4j.srtp.SrtpCryptoAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallPeerJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CryptoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.EncryptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ZrtpHashPacketExtension;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.protocol.media.SrtpControls;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SDesControl;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.ZrtpControl;

public abstract class AbstractCallPeerMediaHandlerJabberGTalkImpl<T extends AbstractCallPeerJabberGTalkImpl<?, ?, ?>>
extends CallPeerMediaHandler<T> {
    private static final Logger logger = Logger.getLogger(AbstractCallPeerMediaHandlerJabberGTalkImpl.class);
    private boolean localInputEvtAware = false;

    public AbstractCallPeerMediaHandlerJabberGTalkImpl(T peer) {
        super(peer, peer);
    }

    public boolean getLocalInputEvtAware() {
        return this.localInputEvtAware;
    }

    public void setLocalInputEvtAware(boolean enable) {
        this.localInputEvtAware = enable;
    }

    protected void addZrtpAdvertisedEncryptions(boolean isInitiator, RtpDescriptionPacketExtension description, MediaType mediaType) {
        ZrtpHashPacketExtension zrtpHashPacketExtension;
        AccountID accountID;
        MediaAwareCallPeer peer = this.getPeer();
        Call call = peer.getCall();
        if (call.getConference().isJitsiVideobridge()) {
            return;
        }
        EncryptionPacketExtension encryptionPacketExtension = description.getFirstChildOfType(EncryptionPacketExtension.class);
        if (encryptionPacketExtension != null && (accountID = peer.getProtocolProvider().getAccountID()).getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(SrtpControlType.ZRTP) && call.isSipZrtpAttribute() && (zrtpHashPacketExtension = encryptionPacketExtension.getFirstChildOfType(ZrtpHashPacketExtension.class)) != null && zrtpHashPacketExtension.getValue() != null) {
            this.addAdvertisedEncryptionMethod(SrtpControlType.ZRTP);
        }
    }

    protected void addSDesAdvertisedEncryptions(boolean isInitiator, RtpDescriptionPacketExtension description, MediaType mediaType) {
        SrtpControl sdesControl;
        MediaAwareCallPeer peer = this.getPeer();
        if (peer.getCall().getConference().isJitsiVideobridge()) {
            return;
        }
        EncryptionPacketExtension encryptionPacketExtension = description.getFirstChildOfType(EncryptionPacketExtension.class);
        if (encryptionPacketExtension != null) {
            AccountID accountID = peer.getProtocolProvider().getAccountID();
            if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(SrtpControlType.SDES)) {
                SrtpControls srtpControls = this.getSrtpControls();
                SDesControl sdesControl2 = (SDesControl)srtpControls.getOrCreate(mediaType, SrtpControlType.SDES);
                SrtpCryptoAttribute selectedSdes = this.selectSdesCryptoSuite(isInitiator, sdesControl2, encryptionPacketExtension);
                if (selectedSdes != null) {
                    this.removeAndCleanupOtherSrtpControls(mediaType, SrtpControlType.SDES);
                    this.addAdvertisedEncryptionMethod(SrtpControlType.SDES);
                } else {
                    sdesControl2.cleanup();
                    srtpControls.remove(mediaType, SrtpControlType.SDES);
                }
            }
        } else if (isInitiator && (sdesControl = this.getSrtpControls().remove(mediaType, SrtpControlType.SDES)) != null) {
            sdesControl.cleanup();
        }
    }

    protected SrtpCryptoAttribute selectSdesCryptoSuite(boolean isInitiator, SDesControl sDesControl, EncryptionPacketExtension encryptionPacketExtension) {
        List<CryptoPacketExtension> cryptoPacketExtensions = encryptionPacketExtension.getCryptoList();
        ArrayList<SrtpCryptoAttribute> peerAttributes = new ArrayList<SrtpCryptoAttribute>(cryptoPacketExtensions.size());
        for (CryptoPacketExtension cpe : cryptoPacketExtensions) {
            peerAttributes.add(cpe.toSrtpCryptoAttribute());
        }
        return isInitiator ? sDesControl.initiatorSelectAttribute(peerAttributes) : sDesControl.responderSelectAttribute(peerAttributes);
    }

    protected boolean isRemoteZrtpCapable(EncryptionPacketExtension encryptionPacketExtension) {
        return encryptionPacketExtension.getFirstChildOfType(ZrtpHashPacketExtension.class) != null;
    }

    protected boolean setZrtpEncryptionOnDescription(MediaType mediaType, RtpDescriptionPacketExtension description, RtpDescriptionPacketExtension remoteDescription) {
        AccountID accountID;
        EncryptionPacketExtension remoteEncryption;
        MediaAwareCallPeer peer = this.getPeer();
        Call call = peer.getCall();
        if (call.getConference().isJitsiVideobridge()) {
            return false;
        }
        boolean isRemoteZrtpCapable = remoteDescription == null ? true : (remoteEncryption = remoteDescription.getFirstChildOfType(EncryptionPacketExtension.class)) != null && this.isRemoteZrtpCapable(remoteEncryption);
        boolean zrtpHashSet = false;
        if (isRemoteZrtpCapable && (accountID = peer.getProtocolProvider().getAccountID()).getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(SrtpControlType.ZRTP) && call.isSipZrtpAttribute()) {
            ZrtpControl zrtpControl = (ZrtpControl)this.getSrtpControls().getOrCreate(mediaType, SrtpControlType.ZRTP);
            int numberSupportedVersions = zrtpControl.getNumberSupportedVersions();
            for (int i = 0; i < numberSupportedVersions; ++i) {
                String[] helloHash = zrtpControl.getHelloHashSep(i);
                if (helloHash == null || helloHash[1].length() <= 0) continue;
                ZrtpHashPacketExtension hash = new ZrtpHashPacketExtension();
                hash.setVersion(helloHash[0]);
                hash.setValue(helloHash[1]);
                EncryptionPacketExtension encryption = description.getFirstChildOfType(EncryptionPacketExtension.class);
                if (encryption == null) {
                    encryption = new EncryptionPacketExtension();
                    description.addChildExtension(encryption);
                }
                encryption.addChildExtension(hash);
                zrtpHashSet = true;
            }
        }
        return zrtpHashSet;
    }

    protected boolean setSDesEncryptionOnDescription(MediaType mediaType, RtpDescriptionPacketExtension localDescription, RtpDescriptionPacketExtension remoteDescription) {
        MediaAwareCallPeer peer = this.getPeer();
        if (peer.getCall().getConference().isJitsiVideobridge()) {
            return false;
        }
        AccountID accountID = peer.getProtocolProvider().getAccountID();
        if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(SrtpControlType.SDES)) {
            SrtpControls srtpControls = this.getSrtpControls();
            SDesControl sdesControl = (SDesControl)srtpControls.getOrCreate(mediaType, SrtpControlType.SDES);
            String ciphers = accountID.getAccountPropertyString((Object)"SDES_CIPHER_SUITES");
            if (ciphers == null) {
                ciphers = JabberActivator.getResources().getSettingsString("net.java.sip.communicator.service.neomedia.SDES_CIPHER_SUITES");
            }
            sdesControl.setEnabledCiphers(Arrays.asList(ciphers.split(",")));
            if (remoteDescription == null) {
                EncryptionPacketExtension localEncryption = localDescription.getFirstChildOfType(EncryptionPacketExtension.class);
                if (localEncryption == null) {
                    localEncryption = new EncryptionPacketExtension();
                    localDescription.addChildExtension(localEncryption);
                }
                for (SrtpCryptoAttribute ca : sdesControl.getInitiatorCryptoAttributes()) {
                    CryptoPacketExtension crypto = new CryptoPacketExtension(ca);
                    localEncryption.addChildExtension(crypto);
                }
                return true;
            }
            EncryptionPacketExtension remoteEncryption = remoteDescription.getFirstChildOfType(EncryptionPacketExtension.class);
            if (remoteEncryption != null) {
                SrtpCryptoAttribute selectedSdes = this.selectSdesCryptoSuite(false, sdesControl, remoteEncryption);
                if (selectedSdes != null) {
                    EncryptionPacketExtension localEncryption = localDescription.getFirstChildOfType(EncryptionPacketExtension.class);
                    if (localEncryption == null) {
                        localEncryption = new EncryptionPacketExtension();
                        localDescription.addChildExtension(localEncryption);
                    }
                    CryptoPacketExtension crypto = new CryptoPacketExtension(selectedSdes);
                    localEncryption.addChildExtension(crypto);
                    return true;
                }
                sdesControl.cleanup();
                srtpControls.remove(mediaType, SrtpControlType.SDES);
                logger.warn((Object)"Received unsupported sdes crypto attribute");
            } else {
                sdesControl.cleanup();
                srtpControls.remove(mediaType, SrtpControlType.SDES);
            }
        }
        return false;
    }

    protected void setAndAddPreferredEncryptionProtocol(MediaType mediaType, RtpDescriptionPacketExtension localDescription, RtpDescriptionPacketExtension remoteDescription) {
        List preferredEncryptionProtocols = ((ProtocolProviderServiceJabberImpl)((AbstractCallPeerJabberGTalkImpl)this.getPeer()).getProtocolProvider()).getAccountID().getSortedEnabledEncryptionProtocolList();
        for (SrtpControlType srtpControlType : preferredEncryptionProtocols) {
            if (!this.setAndAddPreferredEncryptionProtocol(srtpControlType, mediaType, localDescription, remoteDescription)) continue;
            return;
        }
    }

    protected boolean setAndAddPreferredEncryptionProtocol(SrtpControlType srtpControlType, MediaType mediaType, RtpDescriptionPacketExtension localDescription, RtpDescriptionPacketExtension remoteDescription) {
        if (((AbstractCallPeerJabberGTalkImpl)this.getPeer()).isJitsiVideobridge()) {
            return false;
        }
        if (srtpControlType == SrtpControlType.SDES) {
            this.addSDesAdvertisedEncryptions(false, remoteDescription, mediaType);
            if (this.setSDesEncryptionOnDescription(mediaType, localDescription, remoteDescription)) {
                return true;
            }
        } else if (srtpControlType == SrtpControlType.ZRTP && this.setZrtpEncryptionOnDescription(mediaType, localDescription, remoteDescription)) {
            this.addZrtpAdvertisedEncryptions(false, remoteDescription, mediaType);
            return true;
        }
        return false;
    }
}

