/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.util.Collection;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RemoteCandidatePacketExtension;
import org.jitsi.service.neomedia.MediaDirection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JSONSerializer {
    static final String CANDIDATE_LIST = "candidates";
    static final String CHANNELS = "channels";
    static final String CONTENTS = "contents";
    static final String FINGERPRINTS = "fingerprints";
    static final String PARAMETERS = "parameters";
    static final String PAYLOAD_TYPES = "payload-types";
    static final String SOURCES = "sources";
    static final String SSRCS = "ssrcs";
    static final String XMLNS = "xmlns";

    public static void serializeAbstractPacketExtensionAttributes(AbstractPacketExtension abstractPacketExtension, JSONObject jsonObject) {
        for (String name : abstractPacketExtension.getAttributeNames()) {
            Object value = abstractPacketExtension.getAttribute(name);
            if (value instanceof Enum) {
                value = value.toString();
            }
            jsonObject.put((Object)name, value);
        }
    }

    public static JSONObject serializeCandidate(CandidatePacketExtension candidate) {
        JSONObject candidateJSONObject;
        if (candidate == null) {
            candidateJSONObject = null;
        } else {
            candidateJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes((AbstractPacketExtension)candidate, candidateJSONObject);
        }
        return candidateJSONObject;
    }

    public static JSONArray serializeCandidates(Collection<CandidatePacketExtension> candidates) {
        JSONArray candidatesJSONArray;
        if (candidates == null) {
            candidatesJSONArray = null;
        } else {
            candidatesJSONArray = new JSONArray();
            for (CandidatePacketExtension candidate : candidates) {
                candidatesJSONArray.add((Object)JSONSerializer.serializeCandidate(candidate));
            }
        }
        return candidatesJSONArray;
    }

    public static JSONObject serializeChannel(ColibriConferenceIQ.Channel channel) {
        JSONObject channelJSONObject;
        if (channel == null) {
            channelJSONObject = null;
        } else {
            MediaDirection direction = channel.getDirection();
            String endpoint = channel.getEndpoint();
            int expire = channel.getExpire();
            String id = channel.getID();
            Boolean initiator = channel.isInitiator();
            Integer lastN = channel.getLastN();
            List payloadTypes = channel.getPayloadTypes();
            RTPLevelRelayType rtpLevelRelayType = channel.getRTPLevelRelayType();
            List sources = channel.getSources();
            int[] ssrcs = channel.getSSRCs();
            IceUdpTransportPacketExtension transport = channel.getTransport();
            channelJSONObject = new JSONObject();
            if (direction != null) {
                channelJSONObject.put((Object)"direction", (Object)direction.toString());
            }
            if (endpoint != null) {
                channelJSONObject.put((Object)"endpoint", (Object)endpoint);
            }
            if (expire >= 0) {
                channelJSONObject.put((Object)"expire", (Object)expire);
            }
            if (id != null) {
                channelJSONObject.put((Object)"id", (Object)id);
            }
            if (initiator != null) {
                channelJSONObject.put((Object)"initiator", (Object)initiator);
            }
            if (lastN != null) {
                channelJSONObject.put((Object)"last-n", (Object)lastN);
            }
            if (payloadTypes != null && !payloadTypes.isEmpty()) {
                channelJSONObject.put((Object)PAYLOAD_TYPES, (Object)JSONSerializer.serializePayloadTypes(payloadTypes));
            }
            if (rtpLevelRelayType != null) {
                channelJSONObject.put((Object)"rtp-level-relay-type", (Object)rtpLevelRelayType.toString());
            }
            if (sources != null && !sources.isEmpty()) {
                channelJSONObject.put((Object)SOURCES, (Object)JSONSerializer.serializeSources(sources));
            }
            if (ssrcs != null && ssrcs.length > 0) {
                channelJSONObject.put((Object)SSRCS, (Object)JSONSerializer.serializeSSRCs(ssrcs));
            }
            if (transport != null) {
                channelJSONObject.put((Object)transport.getElementName(), (Object)JSONSerializer.serializeTransport(transport));
            }
        }
        return channelJSONObject;
    }

    public static JSONArray serializeChannels(Collection<ColibriConferenceIQ.Channel> channels) {
        JSONArray channelsJSONArray;
        if (channels == null) {
            channelsJSONArray = null;
        } else {
            channelsJSONArray = new JSONArray();
            for (ColibriConferenceIQ.Channel channel : channels) {
                channelsJSONArray.add((Object)JSONSerializer.serializeChannel(channel));
            }
        }
        return channelsJSONArray;
    }

    public static JSONObject serializeConference(ColibriConferenceIQ conference) {
        JSONObject conferenceJSONObject;
        if (conference == null) {
            conferenceJSONObject = null;
        } else {
            String id = conference.getID();
            List contents = conference.getContents();
            conferenceJSONObject = new JSONObject();
            if (id != null) {
                conferenceJSONObject.put((Object)"id", (Object)id);
            }
            if (contents != null && !contents.isEmpty()) {
                conferenceJSONObject.put((Object)CONTENTS, (Object)JSONSerializer.serializeContents(contents));
            }
        }
        return conferenceJSONObject;
    }

    public static JSONArray serializeConferences(Collection<ColibriConferenceIQ> conferences) {
        JSONArray conferencesJSONArray;
        if (conferences == null) {
            conferencesJSONArray = null;
        } else {
            conferencesJSONArray = new JSONArray();
            for (ColibriConferenceIQ conference : conferences) {
                conferencesJSONArray.add((Object)JSONSerializer.serializeConference(conference));
            }
        }
        return conferencesJSONArray;
    }

    public static JSONObject serializeContent(ColibriConferenceIQ.Content content) {
        JSONObject contentJSONObject;
        if (content == null) {
            contentJSONObject = null;
        } else {
            String name = content.getName();
            List channels = content.getChannels();
            contentJSONObject = new JSONObject();
            if (name != null) {
                contentJSONObject.put((Object)"name", (Object)name);
            }
            if (channels != null && !channels.isEmpty()) {
                contentJSONObject.put((Object)CHANNELS, (Object)JSONSerializer.serializeChannels(channels));
            }
        }
        return contentJSONObject;
    }

    public static JSONArray serializeContents(Collection<ColibriConferenceIQ.Content> contents) {
        JSONArray contentsJSONArray;
        if (contents == null) {
            contentsJSONArray = null;
        } else {
            contentsJSONArray = new JSONArray();
            for (ColibriConferenceIQ.Content content : contents) {
                contentsJSONArray.add((Object)JSONSerializer.serializeContent(content));
            }
        }
        return contentsJSONArray;
    }

    public static JSONObject serializeFingerprint(DtlsFingerprintPacketExtension fingerprint) {
        JSONObject fingerprintJSONObject;
        if (fingerprint == null) {
            fingerprintJSONObject = null;
        } else {
            String theFingerprint = fingerprint.getFingerprint();
            fingerprintJSONObject = new JSONObject();
            if (theFingerprint != null) {
                fingerprintJSONObject.put((Object)fingerprint.getElementName(), (Object)theFingerprint);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes((AbstractPacketExtension)fingerprint, fingerprintJSONObject);
        }
        return fingerprintJSONObject;
    }

    public static JSONArray serializeFingerprints(Collection<DtlsFingerprintPacketExtension> fingerprints) {
        JSONArray fingerprintsJSONArray;
        if (fingerprints == null) {
            fingerprintsJSONArray = null;
        } else {
            fingerprintsJSONArray = new JSONArray();
            for (DtlsFingerprintPacketExtension fingerprint : fingerprints) {
                fingerprintsJSONArray.add((Object)JSONSerializer.serializeFingerprint(fingerprint));
            }
        }
        return fingerprintsJSONArray;
    }

    public static JSONObject serializeParameters(Collection<ParameterPacketExtension> parameters) {
        JSONObject parametersJSONObject;
        if (parameters == null) {
            parametersJSONObject = null;
        } else {
            parametersJSONObject = new JSONObject();
            for (ParameterPacketExtension parameter : parameters) {
                String name = parameter.getName();
                String value = parameter.getValue();
                if (name == null && value == null) continue;
                parametersJSONObject.put((Object)name, (Object)value);
            }
        }
        return parametersJSONObject;
    }

    public static JSONObject serializePayloadType(PayloadTypePacketExtension payloadType) {
        JSONObject payloadTypeJSONObject;
        if (payloadType == null) {
            payloadTypeJSONObject = null;
        } else {
            List parameters = payloadType.getParameters();
            payloadTypeJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes((AbstractPacketExtension)payloadType, payloadTypeJSONObject);
            if (parameters != null && !parameters.isEmpty()) {
                payloadTypeJSONObject.put((Object)PARAMETERS, (Object)JSONSerializer.serializeParameters(parameters));
            }
        }
        return payloadTypeJSONObject;
    }

    public static JSONArray serializePayloadTypes(Collection<PayloadTypePacketExtension> payloadTypes) {
        JSONArray payloadTypesJSONArray;
        if (payloadTypes == null) {
            payloadTypesJSONArray = null;
        } else {
            payloadTypesJSONArray = new JSONArray();
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                payloadTypesJSONArray.add((Object)JSONSerializer.serializePayloadType(payloadType));
            }
        }
        return payloadTypesJSONArray;
    }

    public static Long serializeSource(SourcePacketExtension source) {
        return source == null ? null : Long.valueOf(source.getSSRC());
    }

    public static JSONArray serializeSources(Collection<SourcePacketExtension> sources) {
        JSONArray sourcesJSONArray;
        if (sources == null) {
            sourcesJSONArray = null;
        } else {
            sourcesJSONArray = new JSONArray();
            for (SourcePacketExtension source : sources) {
                sourcesJSONArray.add((Object)JSONSerializer.serializeSource(source));
            }
        }
        return sourcesJSONArray;
    }

    public static JSONArray serializeSSRCs(int[] ssrcs) {
        JSONArray ssrcsJSONArray;
        if (ssrcs == null) {
            ssrcsJSONArray = null;
        } else {
            ssrcsJSONArray = new JSONArray();
            for (int i = 0; i < ssrcs.length; ++i) {
                ssrcsJSONArray.add((Object)((long)ssrcs[i] & 0xFFFFFFFFL));
            }
        }
        return ssrcsJSONArray;
    }

    public static JSONObject serializeTransport(IceUdpTransportPacketExtension transport) {
        JSONObject transportJSONObject;
        if (transport == null) {
            transportJSONObject = null;
        } else {
            String xmlns = transport.getNamespace();
            List fingerprints = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            List candidateList = transport.getCandidateList();
            RemoteCandidatePacketExtension remoteCandidate = transport.getRemoteCandidate();
            transportJSONObject = new JSONObject();
            if (xmlns != null) {
                transportJSONObject.put((Object)XMLNS, (Object)xmlns);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes((AbstractPacketExtension)transport, transportJSONObject);
            if (fingerprints != null && !fingerprints.isEmpty()) {
                transportJSONObject.put((Object)FINGERPRINTS, (Object)JSONSerializer.serializeFingerprints(fingerprints));
            }
            if (candidateList != null && !candidateList.isEmpty()) {
                transportJSONObject.put((Object)CANDIDATE_LIST, (Object)JSONSerializer.serializeCandidates(candidateList));
            }
            if (remoteCandidate != null) {
                transportJSONObject.put((Object)remoteCandidate.getElementName(), (Object)JSONSerializer.serializeCandidate((CandidatePacketExtension)remoteCandidate));
            }
        }
        return transportJSONObject;
    }

    private JSONSerializer() {
    }
}

