/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jitsi.impl.neomedia.RTCPFeedbackMessagePacket;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.neomedia.MediaStream;

class RTCPFeedbackMessageSender {
    private final RTPTranslatorImpl rtpTranslator;
    private Map<Long, Integer> sequenceNumbers = new LinkedHashMap<Long, Integer>();

    public RTCPFeedbackMessageSender(RTPTranslatorImpl rtpTranslator) {
        this.rtpTranslator = rtpTranslator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextSequenceNumber(int sourceSSRC, int targetSSRC) {
        Map<Long, Integer> map = this.sequenceNumbers;
        synchronized (map) {
            Long key = ((long)sourceSSRC & 0xFFFFFFFFL) << 32 | (long)targetSSRC & 0xFFFFFFFFL;
            Integer value = this.sequenceNumbers.get(key);
            int seqNr = value == null ? 0 : value;
            this.sequenceNumbers.put(key, seqNr + 1);
            return seqNr;
        }
    }

    private long getSenderSSRC() {
        long ssrc = this.rtpTranslator.getLocalSSRC(null);
        return ssrc == Long.MAX_VALUE ? -1L : ssrc & 0xFFFFFFFFL;
    }

    public boolean sendFIR(MediaStream destination, int mediaSenderSSRC) {
        long senderSSRC = this.getSenderSSRC();
        if (senderSSRC == -1L) {
            return false;
        }
        RTCPFeedbackMessagePacket fir = new RTCPFeedbackMessagePacket(4, -50, senderSSRC, 0xFFFFFFFFL & (long)mediaSenderSSRC);
        fir.setSequenceNumber(this.getNextSequenceNumber((int)senderSSRC, mediaSenderSSRC));
        return this.rtpTranslator.writeRTCPFeedbackMessage(fir, destination);
    }

    public boolean sendFIR(MediaStream destination, int[] mediaSenderSSRCs) {
        boolean sentFIR = false;
        for (int mediaSenderSSRC : mediaSenderSSRCs) {
            if (!this.sendFIR(destination, mediaSenderSSRC)) continue;
            sentFIR = true;
        }
        return sentFIR;
    }
}

