<%@ page import="java.util.*,
				 java.net.URLEncoder,
				 org.jivesoftware.util.*,
				 org.jivesoftware.messenger.PresenceManager,
                 org.jivesoftware.messenger.user.*,
                 org.jivesoftware.admin.*,
                 org.xmpp.packet.Presence"
%>

<%@ taglib uri="http://java.sun.com/jstl/core_rt" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jstl/fmt_rt" prefix="fmt" %>

<jsp:useBean id="webManager" class="org.jivesoftware.util.WebManager"/>
<%   webManager.init(request, response, session, application, out); %>

<%  
    String criteria = ParamUtils.getParameter(request, "criteria");
    
    UserManager userManager = webManager.getUserManager();
    Set<String> searchFields = userManager.getSearchFields();

	List<User> users = new ArrayList<User>();

	for (String searchField : searchFields) {
		
		boolean searchValue = ParamUtils.getBooleanParameter(request, searchField, false);
		if (searchValue) {
    		Collection<User> foundUsers = userManager.findUsers(new HashSet<String>(Arrays.asList(searchField)), criteria);
    		
    		// Filter out all duplicate users.
            for (User user : foundUsers) {
                if (!users.contains(user)) {
                    users.add(user);
                }
            }
    	}
	}
%>
<jsp:useBean id="pageinfo" scope="request" class="org.jivesoftware.admin.AdminPageBean"/>
<%
    String title = "Advance User Search";
    pageinfo.setTitle(title);
    pageinfo.getBreadcrumbs().add(new AdminPageBean.Breadcrumb(LocaleUtils.getLocalizedString("global.main"), "../../index.jsp"));
    pageinfo.getBreadcrumbs().add(new AdminPageBean.Breadcrumb(title, "advance-user-search.jsp"));
    pageinfo.setPageID("advance-user-search");
%>

<jsp:include page="top.jsp" flush="true"/>
<jsp:include page="title.jsp" flush="true"/>


<form name="f" action="advance-user-search.jsp">
  <input type="hidden" name="search" value="true"/>
  <fieldset>
    <legend>Search for User</legend>
    <div>
    <p>
    The following fields are available for search. Wildcard (*) characters are allowed as part the of query.
    </p>
    <table cellpadding="3" cellspacing="1" border="0" width="600">
    
    	<tr class="c1">
	        <td width="1%" nowrap>Search:</td>
	        <td class="c2">
	          <input type="text" name="criteria" value="<%= (criteria != null ? criteria : "") %>" size="30" maxlength="75"/>
	        </td>
	     </tr>
    
    <%
	for (String searchField : searchFields) {
    %>	
    	<tr class="c1">
	        <td width="1%" nowrap><%=searchField %>:</td>
	        <td class="c2">
	          <input type="checkbox" checked="checked" name="<%=searchField %>"/>
	        </td>
	     </tr>
	 <%
	 }
     %>
     <tr><td colspan="2" nowrap><input type="submit" name="search" value="Search"/></td>
     </tr>
    </table>
  </fieldset>
</form>	

<% if (criteria != null) { %>

<div class="jive-table">
<table cellpadding="0" cellspacing="0" border="0" width="100%">
<thead>
    <tr>
        <th>&nbsp;</th>
        <th nowrap>Online</th>
        <th nowrap>Username</th>
        <th nowrap>Name</th>
        <th nowrap>Email</th>
        <th nowrap>Edit</th>
        <th nowrap>Delete</th>
    </tr>
</thead>
<tbody>

	<% if (users.isEmpty()) { %>
	
	 	<tr>
	        <td align="center" colspan="7">No users found.</td>
	    </tr>
	    
	<% 
	} else {
	    int i = 0;
	    PresenceManager presenceManager = webManager.getPresenceManager();
	    
	    for (User user : users) {
	        i++;
	%>
	
	    <tr class="jive-<%= (((i%2)==0) ? "even" : "odd") %>">
	        <td width="1%">
	            <%= i %>
	        </td>
	        <td width="1%" align="center" valign="middle">
	            <%  if (presenceManager.isAvailable(user)) {
	                    Presence presence = presenceManager.getPresence(user);
	            %>
	                <% if (presence.getShow() == null) { %>
	                <img src="images/user-green-16x16.gif" width="16" height="16" border="0" alt="<fmt:message key="user.properties.available" />">
	                <% } %>
	                <% if (presence.getShow() == Presence.Show.chat) { %>
	                <img src="images/user-green-16x16.gif" width="16" height="16" border="0" alt="<fmt:message key="session.details.chat_available" />">
	                <% } %>
	                <% if (presence.getShow() == Presence.Show.away) { %>
	                <img src="images/user-yellow-16x16.gif" width="16" height="16" border="0" alt="<fmt:message key="session.details.away" />">
	                <% } %>
	                <% if (presence.getShow() == Presence.Show.xa) { %>
	                <img src="images/user-yellow-16x16.gif" width="16" height="16" border="0" alt="<fmt:message key="session.details.extended" />">
	                <% } %>
	                <% if (presence.getShow() == Presence.Show.dnd) { %>
	                <img src="images/user-red-16x16.gif" width="16" height="16" border="0" alt="<fmt:message key="session.details.not_disturb" />">
	                <% } %>
	
	            <%  } else { %>
	
	                <img src="images/user-clear-16x16.gif" width="16" height="16" border="0" alt="<fmt:message key="user.properties.offline" />">
	
	            <%  } %>
	        </td>
	        <td width="30%">
	            <a href="../../user-properties.jsp?username=<%= URLEncoder.encode(user.getUsername(), "UTF-8") %>"><%= user.getUsername() %></a>
	        </td>
	        <td width="35">
	            <%= user.getName() %> &nbsp;
	        </td>
	        <td width="35%">
	            <%= user.getEmail() %> &nbsp;
	        </td>
	        <td width="1%" align="center">
	            <a href="../../user-edit-form.jsp?username=<%= URLEncoder.encode(user.getUsername(), "UTF-8") %>"
	             title="<fmt:message key="user.summary.click_edit" />"
	             ><img src="images/edit-16x16.gif" width="17" height="17" border="0"></a>
	        </td>
	        <td width="1%" align="center" style="border-right:1px #ccc solid;">
	            <a href="../../user-delete.jsp?username=<%= URLEncoder.encode(user.getUsername(), "UTF-8") %>"
	             title="<fmt:message key="user.summary.click_delete" />"
	             ><img src="images/delete-16x16.gif" width="16" height="16" border="0"></a>
	        </td>
	    </tr>
	    
<%
		}
    }
%>

</tbody>
</table>
</div>

<% } %>

<jsp:include page="bottom.jsp" flush="true"/>
