/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.util.LineTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class HeadFilter
extends BaseParamFilterReader
implements ChainableReader {
    private static final String LINES_KEY = "lines";
    private static final String SKIP_KEY = "skip";
    private static final int DEFAULT_NUM_LINES = 10;
    private long linesRead;
    private long lines;
    private long skip;
    private LineTokenizer lineTokenizer;
    private String line;
    private int linePos;

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        while (this.line == null || this.line.length() == 0) {
            this.line = this.lineTokenizer.getToken(this.in);
            if (this.line == null) {
                return -1;
            }
            this.line = this.headFilter(this.line);
            this.linePos = 0;
        }
        char c = this.line.charAt(this.linePos);
        ++this.linePos;
        if (this.linePos == this.line.length()) {
            this.line = null;
        }
        return c;
    }

    public final void setLines(long l) {
        this.lines = l;
    }

    private final long getLines() {
        return this.lines;
    }

    public final void setSkip(long l) {
        this.skip = l;
    }

    private final long getSkip() {
        return this.skip;
    }

    public final Reader chain(Reader reader) {
        HeadFilter headFilter = new HeadFilter(reader);
        headFilter.setLines(this.getLines());
        headFilter.setSkip(this.getSkip());
        headFilter.setInitialized(true);
        return headFilter;
    }

    private final void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                if (LINES_KEY.equals(parameterArray[n].getName())) {
                    this.lines = new Long(parameterArray[n].getValue());
                } else if (SKIP_KEY.equals(parameterArray[n].getName())) {
                    this.skip = new Long(parameterArray[n].getValue());
                }
                ++n;
            }
        }
    }

    private final String headFilter(String string) {
        ++this.linesRead;
        if (this.skip > 0L && this.linesRead - 1L < this.skip) {
            return null;
        }
        if (this.lines > 0L && this.linesRead > this.lines + this.skip) {
            return null;
        }
        return string;
    }

    private final /* synthetic */ void this() {
        this.linesRead = 0L;
        this.lines = 10L;
        this.skip = 0L;
        this.lineTokenizer = null;
        this.line = null;
        this.linePos = 0;
    }

    public HeadFilter() {
        this.this();
    }

    public HeadFilter(Reader reader) {
        super(reader);
        this.this();
        this.lineTokenizer = new LineTokenizer();
        this.lineTokenizer.setIncludeDelims(true);
    }
}

