/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import javax.media.rtp.OutputDataStream;
import org.jitsi.impl.neomedia.MaxPacketsPerMillisPolicy;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.util.Logger;

public abstract class RTPConnectorOutputStream
implements OutputDataStream {
    private static final Logger logger = Logger.getLogger(RTPConnectorOutputStream.class);
    private boolean enabled = true;
    private MaxPacketsPerMillisPolicy maxPacketsPerMillisPolicy;
    private long numberOfBytesSent = 0L;
    private long numberOfPackets = 0L;
    private final LinkedBlockingQueue<RawPacket[]> rawPacketArrayPool = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<RawPacket> rawPacketPool = new LinkedBlockingQueue();
    protected final List<InetSocketAddress> targets = new LinkedList<InetSocketAddress>();

    static boolean logPacket(long numOfPacket) {
        return numOfPacket == 1L || numOfPacket == 300L || numOfPacket == 500L || numOfPacket == 1000L || numOfPacket % 5000L == 0L;
    }

    public void addTarget(InetAddress remoteAddr, int remotePort) {
        InetSocketAddress target = new InetSocketAddress(remoteAddr, remotePort);
        if (!this.targets.contains(target)) {
            this.targets.add(target);
        }
    }

    public void close() {
        if (this.maxPacketsPerMillisPolicy != null) {
            this.maxPacketsPerMillisPolicy.close();
            this.maxPacketsPerMillisPolicy = null;
        }
        this.removeTargets();
    }

    protected RawPacket[] createRawPacket(byte[] buffer, int offset, int length) {
        byte[] pktBuffer;
        RawPacket pkt;
        RawPacket[] pkts = this.rawPacketArrayPool.poll();
        if (pkts == null) {
            pkts = new RawPacket[1];
        }
        if ((pkt = this.rawPacketPool.poll()) == null) {
            pktBuffer = new byte[length];
            pkt = new RawPacket();
        } else {
            pktBuffer = pkt.getBuffer();
        }
        if (pktBuffer.length < length) {
            pktBuffer = new byte[length];
        }
        pkt.setBuffer(pktBuffer);
        pkt.setFlags(0);
        pkt.setLength(length);
        pkt.setOffset(0);
        System.arraycopy(buffer, offset, pktBuffer, 0, length);
        pkts[0] = pkt;
        return pkts;
    }

    protected abstract void doLogPacket(RawPacket var1, InetSocketAddress var2);

    public long getNumberOfBytesSent() {
        return this.numberOfBytesSent;
    }

    protected abstract boolean isSocketValid();

    public boolean removeTarget(InetAddress remoteAddr, int remotePort) {
        Iterator<InetSocketAddress> targetIter = this.targets.iterator();
        while (targetIter.hasNext()) {
            InetSocketAddress target = targetIter.next();
            if (!target.getAddress().equals(remoteAddr) || target.getPort() != remotePort) continue;
            targetIter.remove();
            return true;
        }
        return false;
    }

    public void removeTargets() {
        this.targets.clear();
    }

    private boolean send(RawPacket packet) {
        if (!this.isSocketValid()) {
            this.rawPacketPool.offer(packet);
            return false;
        }
        ++this.numberOfPackets;
        for (InetSocketAddress target : this.targets) {
            try {
                PacketLoggingService packetLogging;
                this.sendToTarget(packet, target);
                this.numberOfBytesSent += (long)packet.getLength();
                if (!RTPConnectorOutputStream.logPacket(this.numberOfPackets) || (packetLogging = LibJitsi.getPacketLoggingService()) == null || !packetLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.RTP)) continue;
                this.doLogPacket(packet, target);
            }
            catch (IOException ioe) {
                this.rawPacketPool.offer(packet);
                return false;
            }
        }
        this.rawPacketPool.offer(packet);
        return true;
    }

    protected abstract void sendToTarget(RawPacket var1, InetSocketAddress var2) throws IOException;

    public void setEnabled(boolean enabled) {
        if (logger.isDebugEnabled()) {
            logger.debug("setEnabled: " + enabled);
        }
        this.enabled = enabled;
    }

    public void setMaxPacketsPerMillis(int maxPackets, long perMillis) {
        if (this.maxPacketsPerMillisPolicy == null) {
            if (maxPackets > 0) {
                if (perMillis < 1L) {
                    throw new IllegalArgumentException("perMillis");
                }
                this.maxPacketsPerMillisPolicy = new MaxPacketsPerMillisPolicy(maxPackets, perMillis){

                    @Override
                    protected void send(RawPacket packet) {
                        RTPConnectorOutputStream.this.send(packet);
                    }
                };
            }
        } else {
            this.maxPacketsPerMillisPolicy.setMaxPacketsPerMillis(maxPackets, perMillis);
        }
    }

    public void setPriority(int priority) {
    }

    @Override
    public int write(byte[] buffer, int offset, int length) {
        if (logger.isDebugEnabled() && this.targets.isEmpty()) {
            logger.debug("Write called without targets!", new Throwable());
        }
        if (!this.enabled) {
            return length;
        }
        RawPacket[] pkts = this.createRawPacket(buffer, offset, length);
        boolean fail = false;
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket pkt = pkts[i];
            pkts[i] = null;
            if (pkt == null) continue;
            if (fail) {
                this.rawPacketPool.offer(pkt);
                continue;
            }
            if (this.maxPacketsPerMillisPolicy == null) {
                if (this.send(pkt)) continue;
                fail = true;
                continue;
            }
            this.maxPacketsPerMillisPolicy.write(pkt);
        }
        this.rawPacketArrayPool.offer(pkts);
        return fail ? -1 : length;
    }
}

