/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.protocol.xmpp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.GroupPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JinglePacketFactory;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jitsimeet.BundlePacketExtension;
import net.java.sip.communicator.util.Logger;
import org.jitsi.jicofo.MediaSSRCGroupMap;
import org.jitsi.jicofo.SSRCGroup;
import org.jitsi.protocol.xmpp.JingleRequestHandler;
import org.jitsi.protocol.xmpp.JingleSession;
import org.jitsi.protocol.xmpp.OperationSetJingle;
import org.jitsi.protocol.xmpp.XmppConnection;
import org.jitsi.protocol.xmpp.util.MediaSSRCMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperationSetJingle
implements OperationSetJingle {
    private static final Logger logger = Logger.getLogger(AbstractOperationSetJingle.class);
    protected Map<String, JingleSession> sessions = new HashMap<String, JingleSession>();
    protected JingleRequestHandler requestHandler;

    protected abstract String getOurJID();

    protected abstract XmppConnection getConnection();

    protected JingleSession getSession(String sid) {
        return this.sessions.get(sid);
    }

    @Override
    public void setRequestHandler(JingleRequestHandler jingleHandler) {
        this.requestHandler = jingleHandler;
    }

    @Override
    public void initiateSession(boolean useBundle, String address, List<ContentPacketExtension> contents) {
        logger.info((Object)("INVITE PEER: " + address));
        String sid = JingleIQ.generateSID();
        JingleSession session = new JingleSession(sid, address);
        this.sessions.put(sid, session);
        JingleIQ inviteIQ = JinglePacketFactory.createSessionInitiate((String)this.getOurJID(), (String)address, (String)sid, contents);
        if (useBundle) {
            GroupPacketExtension group = GroupPacketExtension.createBundleGroup(contents);
            inviteIQ.addExtension((PacketExtension)group);
            for (ContentPacketExtension content : contents) {
                content.addChildExtension((PacketExtension)new BundlePacketExtension());
            }
        }
        this.getConnection().sendPacket((Packet)inviteIQ);
    }

    protected void processJingleIQ(JingleIQ iq) {
        JingleSession session = this.getSession(iq.getSID());
        JingleAction action = iq.getAction();
        if (session == null) {
            logger.error((Object)("Action: " + action + ", no session found for SID " + iq.getSID()));
            return;
        }
        if (this.requestHandler == null) {
            logger.error((Object)"No request handler set.");
            return;
        }
        if (JingleAction.SESSION_ACCEPT.equals((Object)action)) {
            this.requestHandler.onSessionAccept(session, iq.getContentList());
        } else if (JingleAction.TRANSPORT_INFO.equals((Object)action)) {
            this.requestHandler.onTransportInfo(session, iq.getContentList());
        } else if (JingleAction.ADDSOURCE.equals((Object)action) || JingleAction.SOURCEADD.equals((Object)action)) {
            this.requestHandler.onAddSource(session, iq.getContentList());
        } else if (JingleAction.REMOVESOURCE.equals((Object)action) || JingleAction.SOURCEREMOVE.equals((Object)action)) {
            this.requestHandler.onRemoveSource(session, iq.getContentList());
        } else {
            logger.warn((Object)("unsupported action " + action));
        }
    }

    @Override
    public void sendAddSourceIQ(MediaSSRCMap ssrcs, MediaSSRCGroupMap ssrcGroupMap, JingleSession session) {
        RtpDescriptionPacketExtension rtpDesc;
        ContentPacketExtension content;
        JingleIQ addSourceIq = new JingleIQ();
        addSourceIq.setAction(JingleAction.SOURCEADD);
        addSourceIq.setFrom(this.getOurJID());
        addSourceIq.setType(IQ.Type.SET);
        for (String media : ssrcs.getMediaTypes()) {
            content = new ContentPacketExtension();
            content.setName(media);
            rtpDesc = new RtpDescriptionPacketExtension();
            rtpDesc.setMedia(media);
            content.addChildExtension((PacketExtension)rtpDesc);
            for (SourcePacketExtension ssrc : ssrcs.getSSRCsForMedia(media)) {
                try {
                    rtpDesc.addChildExtension((PacketExtension)ssrc.copy());
                }
                catch (Exception e) {
                    logger.error((Object)"Copy SSRC error", (Throwable)e);
                }
            }
            addSourceIq.addContent(content);
        }
        if (ssrcGroupMap != null) {
            for (String media : ssrcGroupMap.getMediaTypes()) {
                content = addSourceIq.getContentByName(media);
                if (content == null) {
                    logger.warn((Object)("No SSRCs to be added when group exists for media: " + media));
                    content = new ContentPacketExtension();
                    content.setName(media);
                    addSourceIq.addContent(content);
                    rtpDesc = new RtpDescriptionPacketExtension();
                    rtpDesc.setMedia(media);
                    content.addChildExtension((PacketExtension)rtpDesc);
                } else {
                    rtpDesc = (RtpDescriptionPacketExtension)content.getFirstChildOfType(RtpDescriptionPacketExtension.class);
                }
                for (SSRCGroup ssrcGroup : ssrcGroupMap.getSSRCGroupsForMedia(media)) {
                    try {
                        rtpDesc.addChildExtension((PacketExtension)ssrcGroup.getExtensionCopy());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Copy SSRC GROUP error", (Throwable)e);
                    }
                }
            }
        }
        String peerSid = session.getSessionID();
        addSourceIq.setTo(session.getAddress());
        addSourceIq.setSID(peerSid);
        logger.info((Object)("Notify add SSRC" + session.getAddress() + " SID: " + peerSid));
        this.getConnection().sendPacket((Packet)addSourceIq);
    }

    @Override
    public void sendRemoveSourceIQ(MediaSSRCMap ssrcs, MediaSSRCGroupMap ssrcGroupMap, JingleSession session) {
        RtpDescriptionPacketExtension rtpDesc;
        ContentPacketExtension content;
        JingleIQ removeSourceIq = new JingleIQ();
        removeSourceIq.setAction(JingleAction.SOURCEREMOVE);
        removeSourceIq.setFrom(this.getOurJID());
        removeSourceIq.setType(IQ.Type.SET);
        for (String media : ssrcs.getMediaTypes()) {
            content = new ContentPacketExtension();
            content.setName(media);
            rtpDesc = new RtpDescriptionPacketExtension();
            rtpDesc.setMedia(media);
            content.addChildExtension((PacketExtension)rtpDesc);
            for (SourcePacketExtension ssrc : ssrcs.getSSRCsForMedia(media)) {
                try {
                    rtpDesc.addChildExtension((PacketExtension)ssrc.copy());
                }
                catch (Exception e) {
                    logger.error((Object)"Copy SSRC error", (Throwable)e);
                }
            }
            removeSourceIq.addContent(content);
        }
        if (ssrcGroupMap != null) {
            for (String media : ssrcGroupMap.getMediaTypes()) {
                content = removeSourceIq.getContentByName(media);
                if (content == null) {
                    logger.warn((Object)("No SSRCs to be removed when group exists for media: " + media));
                    content = new ContentPacketExtension();
                    content.setName(media);
                    removeSourceIq.addContent(content);
                    rtpDesc = new RtpDescriptionPacketExtension();
                    rtpDesc.setMedia(media);
                    content.addChildExtension((PacketExtension)rtpDesc);
                } else {
                    rtpDesc = (RtpDescriptionPacketExtension)content.getFirstChildOfType(RtpDescriptionPacketExtension.class);
                }
                for (SSRCGroup ssrcGroup : ssrcGroupMap.getSSRCGroupsForMedia(media)) {
                    try {
                        rtpDesc.addChildExtension((PacketExtension)ssrcGroup.getExtensionCopy());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Copy SSRC GROUP error", (Throwable)e);
                    }
                }
            }
        }
        String peerSid = session.getSessionID();
        removeSourceIq.setTo(session.getAddress());
        removeSourceIq.setSID(peerSid);
        logger.info((Object)("Notify remove SSRC " + session.getAddress() + " SID: " + peerSid));
        XmppConnection connection = this.getConnection();
        connection.sendPacket((Packet)removeSourceIq);
    }

    @Override
    public void terminateSession(JingleSession session, Reason reason) {
        logger.info((Object)("Terminate session: " + session.getAddress()));
        JingleIQ terminate = JinglePacketFactory.createSessionTerminate((String)this.getOurJID(), (String)session.getAddress(), (String)session.getSessionID(), (Reason)reason, null);
        this.getConnection().sendPacket((Packet)terminate);
        this.sessions.remove(session.getSessionID());
    }
}

