/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import org.jitsi.jicofo.FocusBundleActivator;
import org.jitsi.jicofo.util.FocusAccountFactory;
import org.jitsi.jicofo.util.RegisterThread;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolProviderHandler
implements RegistrationStateChangeListener {
    private ProtocolProviderFactory xmppProviderFactory;
    private AccountID xmppAccount;
    private ProtocolProviderService protocolService;
    private RegistrationStateChangeListener regListener;

    public void start(String serverAddress, String xmppDomain, String xmppLoginPassword, String nickName, RegistrationStateChangeListener listener) {
        this.regListener = listener;
        this.xmppProviderFactory = ProtocolProviderFactory.getProtocolProviderFactory((BundleContext)FocusBundleActivator.bundleContext, (String)"Jabber");
        this.xmppAccount = xmppLoginPassword != null ? this.xmppProviderFactory.createAccount(FocusAccountFactory.createFocusAccountProperties(serverAddress, xmppDomain, nickName, xmppLoginPassword)) : this.xmppProviderFactory.createAccount(FocusAccountFactory.createFocusAccountProperties(serverAddress, xmppDomain, nickName));
        if (!this.xmppProviderFactory.loadAccount(this.xmppAccount)) {
            throw new RuntimeException("Failed to load account: " + this.xmppAccount);
        }
        ServiceReference protoRef = this.xmppProviderFactory.getProviderForAccount(this.xmppAccount);
        this.protocolService = (ProtocolProviderService)FocusBundleActivator.bundleContext.getService(protoRef);
        this.protocolService.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
    }

    public void stop() {
        this.protocolService.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        this.xmppProviderFactory.uninstallAccount(this.xmppAccount);
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (this.regListener != null) {
            this.regListener.registrationStateChanged(evt);
        }
    }

    public <T extends OperationSet> T getOperationSet(Class<T> opSetClass) {
        return (T)this.protocolService.getOperationSet(opSetClass);
    }

    public boolean isRegistered() {
        return this.protocolService.isRegistered();
    }

    public void register() {
        new RegisterThread(this.protocolService).start();
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.protocolService;
    }

    public String toString() {
        return this.protocolService != null ? this.protocolService.toString() : super.toString();
    }
}

