/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.java.sip.communicator.service.shutdown.ShutdownService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.jicofo.FocusBundleActivator;
import org.jitsi.jicofo.JitsiMeetConference;
import org.jitsi.jicofo.JitsiMeetServices;
import org.jitsi.jicofo.log.LogEventFactory;
import org.jitsi.jicofo.log.LogExtensionProvider;
import org.jitsi.protocol.JitsiMeetConfig;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.StringUtils;
import org.jitsi.videobridge.log.LoggingService;
import org.jivesoftware.smack.provider.ProviderManager;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusManager
implements JitsiMeetConference.ConferenceListener {
    private static final Logger logger = Logger.getLogger(FocusManager.class);
    public static final String IDLE_TIMEOUT_PROP_NAME = "org.jitsi.focus.IDLE_TIMEOUT";
    public static final long DEFAULT_IDLE_TIMEOUT = 15000L;
    public static final String HOSTNAME_PNAME = "org.jitsi.jicofo.HOSTNAME";
    public static final String XMPP_DOMAIN_PNAME = "org.jitsi.jicofo.XMPP_DOMAIN";
    public static final String FOCUS_USER_DOMAIN_PNAME = "org.jitsi.jicofo.FOCUS_USER_DOMAIN";
    public static final String FOCUS_USER_NAME_PNAME = "org.jitsi.jicofo.FOCUS_USER_NAME";
    public static final String FOCUS_USER_PASSWORD_PNAME = "org.jitsi.jicofo.FOCUS_USER_PASSWORD";
    private String hostName;
    private String focusUserDomain;
    private String focusUserPassword;
    private FocusExpireThread expireThread = new FocusExpireThread();
    private Map<String, JitsiMeetConference> conferences = new HashMap<String, JitsiMeetConference>();
    private JitsiMeetServices jitsiMeetServices;
    private boolean shutdownInProgress;

    public void start() {
        this.expireThread.start();
        ConfigurationService config = FocusBundleActivator.getConfigService();
        this.hostName = config.getString(HOSTNAME_PNAME);
        String xmppDomain = config.getString(XMPP_DOMAIN_PNAME);
        this.focusUserDomain = config.getString(FOCUS_USER_DOMAIN_PNAME);
        String focusUserName = config.getString(FOCUS_USER_NAME_PNAME);
        this.focusUserPassword = config.getString(FOCUS_USER_PASSWORD_PNAME);
        this.jitsiMeetServices = new JitsiMeetServices();
        this.jitsiMeetServices.start(this.hostName, xmppDomain, this.focusUserDomain, focusUserName, this.focusUserPassword);
        ProviderManager.getInstance().addExtensionProvider("log", "urn:xmpp:eventlog", (Object)new LogExtensionProvider());
        FocusBundleActivator.bundleContext.registerService(JitsiMeetServices.class, (Object)this.jitsiMeetServices, null);
    }

    public void stop() {
        this.expireThread.stop();
        this.jitsiMeetServices.stop();
    }

    public synchronized boolean conferenceRequest(String room, Map<String, String> properties) {
        if (StringUtils.isNullOrEmpty((String)room)) {
            return false;
        }
        if (this.shutdownInProgress && !this.conferences.containsKey(room)) {
            return false;
        }
        if (!this.conferences.containsKey(room)) {
            this.createConference(room, properties);
        }
        JitsiMeetConference conference = this.conferences.get(room);
        return conference.isInTheRoom();
    }

    private void createConference(String room, Map<String, String> properties) {
        JitsiMeetConfig config = new JitsiMeetConfig(properties);
        JitsiMeetConference conference = new JitsiMeetConference(room, this.hostName, this.focusUserDomain, this.focusUserPassword, this, config);
        try {
            this.conferences.put(room, conference);
            StringBuilder options = new StringBuilder();
            for (Map.Entry<String, String> option : properties.entrySet()) {
                options.append("\n    ").append(option.getKey()).append(": ").append(option.getValue());
            }
            logger.info((Object)("Created new focus for " + room + "@" + this.focusUserDomain + " conferences count: " + this.conferences.size() + " options:" + options.toString()));
            LoggingService loggingService = FocusBundleActivator.getLoggingService();
            if (loggingService != null) {
                loggingService.logEvent(LogEventFactory.focusCreated(room + "@" + this.focusUserDomain));
            }
            conference.start();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to start conference for room: " + room), (Throwable)e);
        }
    }

    @Override
    public synchronized void conferenceEnded(JitsiMeetConference conference) {
        String roomName = conference.getRoomName();
        this.conferences.remove(roomName);
        logger.info((Object)("Disposed conference for room: " + roomName + " conference count: " + this.conferences.size()));
        this.maybeDoShutdown();
    }

    public JitsiMeetConference getConference(String roomName) {
        return this.conferences.get(roomName);
    }

    public void enableGracefulShutdownMode() {
        if (!this.shutdownInProgress) {
            logger.info((Object)"Focus entered graceful shutdown mode");
        }
        this.shutdownInProgress = true;
        this.maybeDoShutdown();
    }

    private void maybeDoShutdown() {
        if (this.shutdownInProgress && this.conferences.size() == 0) {
            logger.info((Object)"Focus is shutting down NOW");
            ShutdownService shutdownService = (ShutdownService)ServiceUtils.getService((BundleContext)FocusBundleActivator.bundleContext, ShutdownService.class);
            shutdownService.beginShutdown();
        }
    }

    public int getConferenceCount() {
        return this.conferences.size();
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    public void userAuthenticated(String roomName, String realJid, String identity) {
        JitsiMeetConference conference = this.conferences.get(roomName);
        if (conference == null) {
            logger.error((Object)("Auth request - no active conference for room: " + roomName));
            return;
        }
        conference.userAuthenticated(realJid, identity);
    }

    class FocusExpireThread {
        private static final long POLL_INTERVAL = 5000L;
        private final long timeout;
        private Thread timeoutThread;
        private final Object sleepLock = new Object();
        private boolean enabled;

        public FocusExpireThread() {
            this.timeout = FocusBundleActivator.getConfigService().getLong(FocusManager.IDLE_TIMEOUT_PROP_NAME, 15000L);
        }

        void start() {
            if (this.timeoutThread != null) {
                throw new IllegalStateException();
            }
            this.timeoutThread = new Thread(new Runnable(){

                public void run() {
                    FocusExpireThread.this.expireLoop();
                }
            }, "FocusExpireThread");
            this.enabled = true;
            this.timeoutThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            if (this.timeoutThread == null) {
                return;
            }
            this.enabled = false;
            Object object = this.sleepLock;
            synchronized (object) {
                this.sleepLock.notifyAll();
            }
            try {
                if (Thread.currentThread() != this.timeoutThread) {
                    this.timeoutThread.join();
                }
                this.timeoutThread = null;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expireLoop() {
            while (this.enabled) {
                try {
                    Object object = this.sleepLock;
                    synchronized (object) {
                        this.sleepLock.wait(5000L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!this.enabled) break;
                for (JitsiMeetConference conference : new ArrayList(FocusManager.this.conferences.values())) {
                    long idleStamp = conference.getIdleTimestamp();
                    if (idleStamp == -1L || System.currentTimeMillis() - idleStamp <= this.timeout) continue;
                    logger.info((Object)("Focus idle timeout for " + conference.getRoomName()));
                    conference.stop();
                }
            }
        }
    }
}

