/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import java.util.HashMap;
import java.util.Map;
import net.java.sip.communicator.util.Logger;
import org.jitsi.impl.protocol.xmpp.XmppProtocolProvider;
import org.jitsi.jicofo.FocusBundleActivator;
import org.jitsi.protocol.xmpp.OperationSetSubscription;
import org.jitsi.protocol.xmpp.SubscriptionListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.pubsub.ItemPublishEvent;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.listener.ItemEventListener;

public class OpSetSubscriptionImpl
implements OperationSetSubscription,
ItemEventListener {
    private static final Logger logger = Logger.getLogger(OpSetSubscriptionImpl.class);
    public static final String PUBSUB_ADDRESS_PNAME = "org.jitsi.focus.pubsub.ADDRESS";
    private PubSubManager manager;
    private final String pubSubAddress;
    private String ourJid;
    private Map<String, SubscriptionListener> listenerMap = new HashMap<String, SubscriptionListener>();
    private final XmppProtocolProvider parentProvider;

    public OpSetSubscriptionImpl(XmppProtocolProvider parentProvider) {
        this.parentProvider = parentProvider;
        this.pubSubAddress = FocusBundleActivator.getConfigService().getString(PUBSUB_ADDRESS_PNAME);
    }

    private String getOurJid() {
        if (this.ourJid == null) {
            this.ourJid = this.parentProvider.getOurJid();
        }
        return this.ourJid;
    }

    private PubSubManager getManager() {
        if (this.manager == null) {
            this.manager = new PubSubManager((Connection)this.parentProvider.getConnection(), this.pubSubAddress);
        }
        return this.manager;
    }

    private boolean isSubscribed(String jid, Node node) throws XMPPException {
        for (Subscription subscription : node.getSubscriptions()) {
            if (!subscription.getJid().equals(jid)) continue;
            return true;
        }
        return false;
    }

    public void subscribe(String node, SubscriptionListener listener) {
        this.listenerMap.put(node, listener);
        PubSubManager manager = this.getManager();
        try {
            Node pubSubNode = manager.getNode(node);
            if (!this.isSubscribed(this.getOurJid(), pubSubNode)) {
                pubSubNode.addItemEventListener((ItemEventListener)this);
                pubSubNode.subscribe(this.parentProvider.getOurJid());
            }
        }
        catch (XMPPException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void unSubscribe(String node) {
        if (!this.listenerMap.containsKey(node)) {
            logger.warn((Object)("No PUBSUB listener for " + node));
            return;
        }
        PubSubManager manager = this.getManager();
        try {
            Node pubSubNode = manager.getNode(node);
            if (this.isSubscribed(this.getOurJid(), pubSubNode)) {
                pubSubNode.unsubscribe(this.getOurJid());
            }
        }
        catch (XMPPException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void handlePublishedItems(ItemPublishEvent event) {
        SubscriptionListener listener;
        String nodeId = event.getNodeId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PubSub update for node: " + nodeId));
        }
        if ((listener = this.listenerMap.get(nodeId)) != null) {
            for (Object item : event.getItems()) {
                if (!(item instanceof PayloadItem)) continue;
                PayloadItem payloadItem = (PayloadItem)item;
                listener.onSubscriptionUpdate(nodeId, payloadItem.getPayload());
            }
        }
    }
}

