/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.jitsi.impl.protocol.xmpp.ChatRoomImpl;
import org.jitsi.protocol.xmpp.XmppChatMember;
import org.jivesoftware.smackx.muc.Occupant;

public class ChatMemberImpl
implements XmppChatMember {
    private final String nickname;
    private final ChatRoomImpl chatRoom;
    private final String address;
    private String jabberId;
    private ChatRoomMemberRole role;

    public ChatMemberImpl(String participant, ChatRoomImpl chatRoom) {
        this.address = participant;
        this.nickname = participant.substring(participant.lastIndexOf("/") + 1);
        this.chatRoom = chatRoom;
    }

    public ChatRoom getChatRoom() {
        return this.chatRoom;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.chatRoom.getParentProvider();
    }

    public String getContactAddress() {
        return this.address;
    }

    public String getName() {
        return this.nickname;
    }

    public byte[] getAvatar() {
        return new byte[0];
    }

    public Contact getContact() {
        return null;
    }

    public ChatRoomMemberRole getRole() {
        if (this.role == null) {
            Occupant o = this.chatRoom.getOccupant(this);
            if (o == null) {
                return ChatRoomMemberRole.GUEST;
            }
            this.role = ChatRoomJabberImpl.smackRoleToScRole((String)o.getRole(), (String)o.getAffiliation());
        }
        return this.role;
    }

    public void setRole(ChatRoomMemberRole role) {
        throw new RuntimeException("Not implemented yet.");
    }

    public String getJabberID() {
        return this.jabberId;
    }

    void setJabberID(String jabberId) {
        this.jabberId = jabberId;
    }
}

