/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.java.sip.communicator.impl.protocol.jabber.AbstractContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactResourceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.jabber.MobileIndicator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.RootContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ServerStoredContactListJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.VCardTempXUpdatePresenceExtension;
import net.java.sip.communicator.impl.protocol.jabber.VolatileContactJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.AuthorizationResponse;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.ContactResourceEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.service.protocol.jabberconstants.JabberStatusEnum;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.packet.Nick;
import org.jivesoftware.smackx.packet.VCard;

public class OperationSetPersistentPresenceJabberImpl
extends AbstractOperationSetPersistentPresence<ProtocolProviderServiceJabberImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetPersistentPresenceJabberImpl.class);
    private String currentStatusMessage = "";
    private PresenceStatus currentStatus = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline");
    private static Map<String, Presence.Mode> scToJabberModesMappings = new Hashtable<String, Presence.Mode>();
    private static Map<String, Integer> statusToPriorityMappings;
    private final ServerStoredContactListJabberImpl ssContactList;
    private JabberSubscriptionListener subscribtionPacketListener = null;
    private int resourcePriorityAvailable = 30;
    private ContactChangesListener contactChangesListener = null;
    private VCardTempXUpdatePresenceExtension vCardTempXUpdatePresenceExtension = null;
    private final MobileIndicator mobileIndicator;
    private Presence currentPresence = null;
    private ContactJabberImpl localContact = null;

    public OperationSetPersistentPresenceJabberImpl(ProtocolProviderServiceJabberImpl provider, InfoRetreiver infoRetreiver) {
        super((ProtocolProviderService)provider);
        this.initializePriorities();
        this.ssContactList = new ServerStoredContactListJabberImpl(this, provider, infoRetreiver);
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).addRegistrationStateChangeListener(new RegistrationStateListener());
        this.mobileIndicator = new MobileIndicator((ProtocolProviderServiceJabberImpl)this.parentProvider, this.ssContactList);
    }

    public void addServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        this.ssContactList.addGroupListener(listener);
    }

    public void createServerStoredContactGroup(ContactGroup parent, String groupName) throws OperationFailedException {
        this.assertConnected();
        if (!parent.canContainSubgroups()) {
            throw new IllegalArgumentException("The specified contact group cannot contain child groups. Group:" + parent);
        }
        this.ssContactList.createGroup(groupName);
    }

    public synchronized ContactJabberImpl createVolatileContact(String id) {
        return this.createVolatileContact(id, null);
    }

    public synchronized ContactJabberImpl createVolatileContact(String id, String displayName) {
        return this.createVolatileContact(id, false, displayName);
    }

    public synchronized ContactJabberImpl createVolatileContact(String id, boolean isPrivateMessagingContact) {
        return this.createVolatileContact(id, isPrivateMessagingContact, null);
    }

    public synchronized ContactJabberImpl createVolatileContact(String id, boolean isPrivateMessagingContact, String displayName) {
        ContactJabberImpl sourceContact;
        ContactGroupJabberImpl notInContactListGroup = this.ssContactList.getNonPersistentGroup();
        if (notInContactListGroup != null && (sourceContact = notInContactListGroup.findContact(org.jivesoftware.smack.util.StringUtils.parseBareAddress((String)id))) != null) {
            return sourceContact;
        }
        sourceContact = this.ssContactList.createVolatileContact(id, isPrivateMessagingContact, displayName);
        if (isPrivateMessagingContact && org.jivesoftware.smack.util.StringUtils.parseResource((String)id) != null) {
            this.updateResources(sourceContact, false);
        }
        return sourceContact;
    }

    public Contact createUnresolvedContact(String address, String persistentData, ContactGroup parentGroup) {
        if (!(parentGroup instanceof ContactGroupJabberImpl) && !(parentGroup instanceof RootContactGroupJabberImpl)) {
            throw new IllegalArgumentException("Argument is not an jabber contact group (group=" + parentGroup + ")");
        }
        ContactJabberImpl contact = this.ssContactList.createUnresolvedContact(parentGroup, address);
        contact.setPersistentData(persistentData);
        return contact;
    }

    public Contact createUnresolvedContact(String address, String persistentData) {
        return this.createUnresolvedContact(address, persistentData, this.getServerStoredContactListRoot());
    }

    public ContactGroup createUnresolvedContactGroup(String groupUID, String persistentData, ContactGroup parentGroup) {
        return this.ssContactList.createUnresolvedContactGroup(groupUID);
    }

    public Contact findContactByID(String contactID) {
        return this.ssContactList.findContactById(contactID);
    }

    public String getCurrentStatusMessage() {
        return this.currentStatusMessage;
    }

    public Contact getLocalContact() {
        if (this.localContact != null) {
            return this.localContact;
        }
        final String id = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getAccountID().getUserID();
        this.localContact = new ContactJabberImpl(null, this.ssContactList, false, true);
        this.localContact.setLocal(true);
        this.localContact.updatePresenceStatus(this.currentStatus);
        this.localContact.setJid(((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID());
        Map<String, ContactResourceJabberImpl> rs = this.localContact.getResourcesMap();
        if (this.currentPresence != null) {
            rs.put(((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID(), this.createResource(this.currentPresence, ((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID(), (Contact)this.localContact));
        }
        Iterator<Presence> presenceIterator = this.ssContactList.getPresences(id);
        while (presenceIterator.hasNext()) {
            Presence p = presenceIterator.next();
            String fullJid = p.getFrom();
            rs.put(fullJid, this.createResource(p, p.getFrom(), (Contact)this.localContact));
        }
        PacketTypeFilter presenceFilter = new PacketTypeFilter(Presence.class);
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                String from = presence.getFrom();
                if (from == null || !org.jivesoftware.smack.util.StringUtils.parseBareAddress((String)from).equals(id)) {
                    return;
                }
                OperationSetPersistentPresenceJabberImpl.this.updateResource(OperationSetPersistentPresenceJabberImpl.this.localContact, null, presence);
            }
        }, (PacketFilter)presenceFilter);
        return this.localContact;
    }

    private ContactResourceJabberImpl createResource(Presence presence, String fullJid, Contact contact) {
        String resource = org.jivesoftware.smack.util.StringUtils.parseResource((String)fullJid);
        return new ContactResourceJabberImpl(fullJid, contact, resource, OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, (ProtocolProviderServiceJabberImpl)this.parentProvider), presence.getPriority(), this.mobileIndicator.isMobileResource(resource, fullJid));
    }

    private void clearLocalContactResources() {
        if (this.localContact != null) {
            this.removeResource(this.localContact, this.localContact.getAddress());
        }
        this.currentPresence = null;
        this.localContact = null;
    }

    public PresenceStatus getPresenceStatus() {
        return this.currentStatus;
    }

    public ContactGroup getServerStoredContactListRoot() {
        return this.ssContactList.getRootGroup();
    }

    public Iterator<PresenceStatus> getSupportedStatusSet() {
        return ((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getSupportedStatusSet();
    }

    public boolean isPrivateMessagingContact(String contactAddress) {
        return this.ssContactList.isPrivateMessagingContact(contactAddress);
    }

    public void moveContactToGroup(Contact contactToMove, ContactGroup newParent) throws OperationFailedException {
        this.assertConnected();
        if (!(contactToMove instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not an jabber contact." + contactToMove);
        }
        if (!(newParent instanceof AbstractContactGroupJabberImpl)) {
            throw new IllegalArgumentException("The specified group is not an jabber contact group." + newParent);
        }
        this.ssContactList.moveContact((ContactJabberImpl)contactToMove, (AbstractContactGroupJabberImpl)newParent);
    }

    public void publishPresenceStatus(PresenceStatus status, String statusMessage) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        JabberStatusEnum jabberStatusEnum = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum();
        boolean isValidStatus = false;
        Iterator supportedStatusIter = jabberStatusEnum.getSupportedStatusSet();
        while (supportedStatusIter.hasNext()) {
            if (!((PresenceStatus)supportedStatusIter.next()).equals((Object)status)) continue;
            isValidStatus = true;
            break;
        }
        if (!isValidStatus) {
            throw new IllegalArgumentException(status + " is not a valid Jabber status");
        }
        if (status.equals((Object)jabberStatusEnum.getStatus("Offline"))) {
            ((ProtocolProviderServiceJabberImpl)this.parentProvider).unregister();
            this.clearLocalContactResources();
        } else {
            Presence presence;
            this.currentPresence = presence = new Presence(Presence.Type.available);
            presence.setMode(OperationSetPersistentPresenceJabberImpl.presenceStatusToJabberMode(status));
            presence.setPriority(this.getPriorityForPresenceStatus(status.getStatusName()));
            if (status.equals((Object)jabberStatusEnum.getStatus("On the phone"))) {
                presence.setStatus("On the phone");
            } else if (status.equals((Object)jabberStatusEnum.getStatus("In a meeting"))) {
                presence.setStatus("In a meeting");
            } else {
                presence.setStatus(statusMessage);
            }
            ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendPacket((Packet)presence);
            if (this.localContact != null) {
                this.updateResource(this.localContact, ((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID(), presence);
            }
        }
        this.fireProviderStatusChangeEvent(this.currentStatus, status);
        String oldStatusMessage = this.getCurrentStatusMessage();
        if (!StringUtils.isEquals((String)oldStatusMessage, (String)statusMessage)) {
            this.currentStatusMessage = statusMessage;
            this.fireProviderStatusMessageChangeEvent(oldStatusMessage, this.getCurrentStatusMessage());
        }
    }

    public PresenceStatus queryContactStatus(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        XMPPConnection xmppConnection = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection();
        if (xmppConnection == null) {
            throw new IllegalArgumentException("The provider/account must be signed on in order to query the status of a contact in its roster");
        }
        Presence presence = xmppConnection.getRoster().getPresence(contactIdentifier);
        if (presence != null) {
            return OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, (ProtocolProviderServiceJabberImpl)this.parentProvider);
        }
        return ((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline");
    }

    public void removeServerStoredContactGroup(ContactGroup group) throws OperationFailedException {
        this.assertConnected();
        if (!(group instanceof ContactGroupJabberImpl)) {
            throw new IllegalArgumentException("The specified group is not an jabber contact group: " + group);
        }
        this.ssContactList.removeGroup((ContactGroupJabberImpl)group);
    }

    public void removeServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        this.ssContactList.removeGroupListener(listener);
    }

    public void renameServerStoredContactGroup(ContactGroup group, String newName) {
        this.assertConnected();
        if (!(group instanceof ContactGroupJabberImpl)) {
            throw new IllegalArgumentException("The specified group is not an jabber contact group: " + group);
        }
        this.ssContactList.renameGroup((ContactGroupJabberImpl)group, newName);
    }

    public void setAuthorizationHandler(AuthorizationHandler handler) {
        this.subscribtionPacketListener.setHandler(handler);
    }

    public void subscribe(ContactGroup parent, String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        if (!(parent instanceof ContactGroupJabberImpl)) {
            throw new IllegalArgumentException("Argument is not an jabber contact group (group=" + parent + ")");
        }
        this.ssContactList.addContact(parent, contactIdentifier);
    }

    public void subscribe(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        this.ssContactList.addContact(contactIdentifier);
    }

    public void unsubscribe(Contact contact) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        if (!(contact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("Argument is not an jabber contact (contact=" + contact + ")");
        }
        this.ssContactList.removeContact((ContactJabberImpl)contact);
    }

    public static PresenceStatus jabberStatusToPresenceStatus(Presence presence, ProtocolProviderServiceJabberImpl jabberProvider) {
        JabberStatusEnum jabberStatusEnum = jabberProvider.getJabberStatusEnum();
        if (presence.getMode() == null && presence.isAvailable()) {
            return jabberStatusEnum.getStatus("Available");
        }
        if (presence.getMode() == null && !presence.isAvailable()) {
            return jabberStatusEnum.getStatus("Offline");
        }
        Presence.Mode mode = presence.getMode();
        if (mode.equals((Object)Presence.Mode.available)) {
            return jabberStatusEnum.getStatus("Available");
        }
        if (mode.equals((Object)Presence.Mode.away)) {
            if (presence.getStatus() != null && presence.getStatus().contains("On the phone")) {
                return jabberStatusEnum.getStatus("On the phone");
            }
            if (presence.getStatus() != null && presence.getStatus().contains("In a meeting")) {
                return jabberStatusEnum.getStatus("In a meeting");
            }
            return jabberStatusEnum.getStatus("Away");
        }
        if (mode.equals((Object)Presence.Mode.chat)) {
            return jabberStatusEnum.getStatus("Free For Chat");
        }
        if (mode.equals((Object)Presence.Mode.dnd)) {
            return jabberStatusEnum.getStatus("Do Not Disturb");
        }
        if (mode.equals((Object)Presence.Mode.xa)) {
            return jabberStatusEnum.getStatus("Extended Away");
        }
        if (presence.isAway()) {
            return jabberStatusEnum.getStatus("Away");
        }
        if (presence.isAvailable()) {
            return jabberStatusEnum.getStatus("Available");
        }
        return jabberStatusEnum.getStatus("Offline");
    }

    public static Presence.Mode presenceStatusToJabberMode(PresenceStatus status) {
        return scToJabberModesMappings.get(status.getStatusName());
    }

    void assertConnected() throws IllegalStateException {
        if (this.parentProvider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the Jabber service before being able to communicate.");
        }
        if (!((ProtocolProviderServiceJabberImpl)this.parentProvider).isRegistered()) {
            if (this.currentStatus != null && this.currentStatus.isOnline()) {
                this.fireProviderStatusChangeEvent(this.currentStatus, (PresenceStatus)((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline"));
            }
            throw new IllegalStateException("The provider must be signed on the Jabber service before being able to communicate.");
        }
    }

    public void fireProviderStatusChangeEvent(PresenceStatus oldStatus, PresenceStatus newStatus) {
        if (!oldStatus.equals((Object)newStatus)) {
            this.currentStatus = newStatus;
            super.fireProviderStatusChangeEvent(oldStatus, newStatus);
            JabberStatusEnum.JabberPresenceStatus offlineStatus = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline");
            if (newStatus.equals((Object)offlineStatus)) {
                Iterator groupsIter = this.getServerStoredContactListRoot().subgroups();
                while (groupsIter.hasNext()) {
                    ContactGroup group = (ContactGroup)groupsIter.next();
                    Iterator contactsIter = group.contacts();
                    while (contactsIter.hasNext()) {
                        ContactJabberImpl contact = (ContactJabberImpl)((Object)contactsIter.next());
                        this.updateContactStatus(contact, (PresenceStatus)offlineStatus);
                    }
                }
                Iterator contactsIter = this.getServerStoredContactListRoot().contacts();
                while (contactsIter.hasNext()) {
                    ContactJabberImpl contact = (ContactJabberImpl)((Object)contactsIter.next());
                    this.updateContactStatus(contact, (PresenceStatus)offlineStatus);
                }
            }
        }
    }

    public void setDisplayName(Contact contact, String newName) throws IllegalArgumentException {
        this.assertConnected();
        if (!(contact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("Argument is not an jabber contact (contact=" + contact + ")");
        }
        RosterEntry entry = ((ContactJabberImpl)contact).getSourceEntry();
        if (entry != null) {
            entry.setName(newName);
        }
    }

    private boolean updateResources(ContactJabberImpl contact, boolean removeUnavailable) {
        if (!contact.isResolved() || contact instanceof VolatileContactJabberImpl && ((VolatileContactJabberImpl)contact).isPrivateMessagingContact()) {
            return false;
        }
        boolean eventFired = false;
        Map<String, ContactResourceJabberImpl> resources = contact.getResourcesMap();
        if (((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection() == null || !((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().isConnected()) {
            if (removeUnavailable) {
                Iterator<Map.Entry<String, ContactResourceJabberImpl>> iter = resources.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, ContactResourceJabberImpl> entry = iter.next();
                    iter.remove();
                    contact.fireContactResourceEvent(new ContactResourceEvent((Contact)contact, (ContactResource)entry.getValue(), 1));
                    eventFired = true;
                }
            }
            return eventFired;
        }
        Iterator it = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().getRoster().getPresences(contact.getAddress());
        while (it.hasNext()) {
            Presence presence = (Presence)it.next();
            eventFired = this.updateResource(contact, null, presence) || eventFired;
        }
        if (!removeUnavailable) {
            return eventFired;
        }
        for (String fullJid : resources.keySet()) {
            if (((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().getRoster().getPresenceResource(fullJid).isAvailable()) continue;
            eventFired = this.removeResource(contact, fullJid) || eventFired;
        }
        return eventFired;
    }

    private boolean updateResource(ContactJabberImpl contact, String fullJid, Presence presence) {
        String resource;
        if (fullJid == null) {
            fullJid = presence.getFrom();
        }
        if ((resource = org.jivesoftware.smack.util.StringUtils.parseResource((String)fullJid)) != null && resource.length() > 0) {
            Map<String, ContactResourceJabberImpl> resources = contact.getResourcesMap();
            ContactResourceJabberImpl contactResource = resources.get(fullJid);
            PresenceStatus newPresenceStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, (ProtocolProviderServiceJabberImpl)this.parentProvider);
            if (contactResource == null) {
                contactResource = this.createResource(presence, fullJid, (Contact)contact);
                resources.put(fullJid, contactResource);
                contact.fireContactResourceEvent(new ContactResourceEvent((Contact)contact, (ContactResource)contactResource, 0));
                return true;
            }
            boolean oldIndicator = contactResource.isMobile();
            boolean newIndicator = this.mobileIndicator.isMobileResource(resource, fullJid);
            int oldPriority = contactResource.getPriority();
            contactResource.setMobile(newIndicator);
            contactResource.setPriority(presence.getPriority());
            if (oldPriority != contactResource.getPriority()) {
                this.mobileIndicator.resourcesUpdated(contact);
            }
            if (contactResource.getPresenceStatus().getStatus() != newPresenceStatus.getStatus() || oldIndicator != newIndicator || oldPriority != contactResource.getPriority()) {
                contactResource.setPresenceStatus(newPresenceStatus);
                contact.fireContactResourceEvent(new ContactResourceEvent((Contact)contact, (ContactResource)contactResource, 2));
                return true;
            }
        }
        return false;
    }

    private boolean removeResource(ContactJabberImpl contact, String fullJid) {
        Map<String, ContactResourceJabberImpl> resources = contact.getResourcesMap();
        if (resources.containsKey(fullJid)) {
            ContactResource removedResource = resources.remove(fullJid);
            contact.fireContactResourceEvent(new ContactResourceEvent((Contact)contact, removedResource, 1));
            return true;
        }
        return false;
    }

    void firePresenceStatusChanged(Presence presence) {
        if (this.contactChangesListener != null) {
            this.contactChangesListener.firePresenceStatusChanged(presence);
        }
    }

    private void updateContactStatus(ContactJabberImpl contact, PresenceStatus newStatus) {
        boolean oldMobileIndicator = contact.isMobile();
        boolean resourceUpdated = this.updateResources(contact, true);
        this.mobileIndicator.resourcesUpdated(contact);
        PresenceStatus oldStatus = contact.getPresenceStatus();
        if (oldStatus.equals((Object)newStatus) && oldMobileIndicator == contact.isMobile()) {
            return;
        }
        contact.updatePresenceStatus(newStatus);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Will Dispatch the contact status event.");
        }
        this.fireContactPresenceStatusChangeEvent((Contact)contact, contact.getParentContactGroup(), oldStatus, newStatus, resourceUpdated);
    }

    public void createAccountPhotoPresenceInterceptor() {
        if (this.vCardTempXUpdatePresenceExtension == null) {
            byte[] avatar = null;
            try {
                VCard vCard = new VCard();
                vCard.load((Connection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection());
                avatar = vCard.getAvatar();
            }
            catch (XMPPException ex) {
                logger.info((Object)("Can not retrieve account avatar for " + ((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID() + ": " + ex.getMessage()));
            }
            this.vCardTempXUpdatePresenceExtension = new VCardTempXUpdatePresenceExtension(avatar);
            ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().addPacketInterceptor((PacketInterceptor)this.vCardTempXUpdatePresenceExtension, (PacketFilter)new PacketTypeFilter(Presence.class));
        }
    }

    public void updateAccountPhotoPresenceExtension(byte[] imageBytes) {
        try {
            if (this.vCardTempXUpdatePresenceExtension.updateImage(imageBytes)) {
                this.publishPresenceStatus(this.currentStatus, this.currentStatusMessage);
            }
        }
        catch (OperationFailedException ex) {
            logger.info((Object)"Can not send presence extension to broadcast photo update", (Throwable)ex);
        }
    }

    public void createContactPhotoPresenceListener() {
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                OperationSetPersistentPresenceJabberImpl.this.parseContactPhotoPresence(packet);
            }
        }, (PacketFilter)new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new PacketExtensionFilter("x", "vcard-temp:x:update")}));
    }

    public void parseContactPhotoPresence(Packet packet) {
        block7: {
            String userID = org.jivesoftware.smack.util.StringUtils.parseBareAddress((String)packet.getFrom());
            ContactJabberImpl sourceContact = this.ssContactList.findContactById(userID);
            if (sourceContact == null) {
                return;
            }
            byte[] currentAvatar = sourceContact.getImage(false);
            DefaultPacketExtension defaultPacketExtension = (DefaultPacketExtension)packet.getExtension("x", "vcard-temp:x:update");
            if (defaultPacketExtension != null) {
                try {
                    String packetPhotoSHA1 = defaultPacketExtension.getValue("photo");
                    if (packetPhotoSHA1 != null && !packetPhotoSHA1.equals(VCardTempXUpdatePresenceExtension.getImageSha1(currentAvatar))) {
                        byte[] newAvatar = null;
                        if (packetPhotoSHA1.length() != 0) {
                            VCard vCard = new VCard();
                            vCard.load((Connection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection(), userID);
                            newAvatar = vCard.getAvatar();
                        } else {
                            newAvatar = new byte[]{};
                        }
                        sourceContact.setImage(newAvatar);
                        this.fireContactPropertyChangeEvent("Image", (Contact)sourceContact, currentAvatar, newAvatar);
                    }
                }
                catch (XMPPException ex) {
                    logger.info((Object)("Cannot retrieve vCard from: " + packet.getFrom()));
                    if (!logger.isTraceEnabled()) break block7;
                    logger.trace((Object)"vCard retrieval exception was: ", (Throwable)ex);
                }
            }
        }
    }

    private void initializePriorities() {
        try {
            this.resourcePriorityAvailable = Integer.parseInt(((ProtocolProviderServiceJabberImpl)this.parentProvider).getAccountID().getAccountPropertyString((Object)"RESOURCE_PRIORITY"));
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"Wrong value for resource priority", (Throwable)ex);
        }
        this.addDefaultValue("Away", -5);
        this.addDefaultValue("Extended Away", -10);
        this.addDefaultValue("On the phone", -15);
        this.addDefaultValue("In a meeting", -16);
        this.addDefaultValue("Do Not Disturb", -20);
        this.addDefaultValue("Free For Chat", 5);
    }

    private void addDefaultValue(String statusName, int availableShift) {
        String resourcePriority = this.getAccountPriorityForStatus(statusName);
        if (resourcePriority != null) {
            try {
                OperationSetPersistentPresenceJabberImpl.addPresenceToPriorityMapping(statusName, Integer.parseInt(resourcePriority));
            }
            catch (NumberFormatException ex) {
                logger.error((Object)("Wrong value for resource priority for status: " + statusName), (Throwable)ex);
            }
        } else {
            int priority = this.resourcePriorityAvailable + availableShift;
            if (priority <= 0) {
                priority = this.resourcePriorityAvailable;
            }
            OperationSetPersistentPresenceJabberImpl.addPresenceToPriorityMapping(statusName, priority);
        }
    }

    private static void addPresenceToPriorityMapping(String statusName, int value) {
        statusToPriorityMappings.put(statusName.replaceAll(" ", "_").toUpperCase(), value);
    }

    private int getPriorityForPresenceStatus(String statusName) {
        Integer priority = statusToPriorityMappings.get(statusName.replaceAll(" ", "_").toUpperCase());
        if (priority == null) {
            return this.resourcePriorityAvailable;
        }
        return priority;
    }

    private String getAccountPriorityForStatus(String statusName) {
        return ((ProtocolProviderServiceJabberImpl)this.parentProvider).getAccountID().getAccountPropertyString((Object)("RESOURCE_PRIORITY_" + statusName.replaceAll(" ", "_").toUpperCase()));
    }

    public ServerStoredContactListJabberImpl getSsContactList() {
        return this.ssContactList;
    }

    static {
        scToJabberModesMappings.put("Away", Presence.Mode.away);
        scToJabberModesMappings.put("On the phone", Presence.Mode.away);
        scToJabberModesMappings.put("In a meeting", Presence.Mode.away);
        scToJabberModesMappings.put("Extended Away", Presence.Mode.xa);
        scToJabberModesMappings.put("Do Not Disturb", Presence.Mode.dnd);
        scToJabberModesMappings.put("Free For Chat", Presence.Mode.chat);
        scToJabberModesMappings.put("Available", Presence.Mode.available);
        statusToPriorityMappings = new Hashtable<String, Integer>();
    }

    private class ServerStoredListInit
    implements Runnable,
    PacketListener {
        private ServerStoredListInit() {
        }

        @Override
        public void run() {
            ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getConnection().removePacketListener((PacketListener)this);
            OperationSetPersistentPresenceJabberImpl.this.contactChangesListener = new ContactChangesListener();
            OperationSetPersistentPresenceJabberImpl.this.ssContactList.init(OperationSetPersistentPresenceJabberImpl.this.contactChangesListener);
            ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).startJingleNodesDiscovery();
        }

        public void processPacket(Packet packet) {
            if (packet.getError() != null) {
                return;
            }
            new Thread((Runnable)this, this.getClass().getName()).start();
        }
    }

    private class JabberSubscriptionListener
    implements PacketListener {
        private AuthorizationHandler handler = null;
        private Map<String, String> earlySubscriptions = new HashMap<String, String>();

        private JabberSubscriptionListener() {
        }

        private synchronized void setHandler(AuthorizationHandler handler) {
            this.handler = handler;
            this.handleEarlySubscribeReceived();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            Presence presence = (Presence)packet;
            if (presence == null) {
                return;
            }
            Presence.Type presenceType = presence.getType();
            String fromID = presence.getFrom();
            if (presenceType == Presence.Type.subscribe) {
                String displayName = null;
                Nick ext = (Nick)presence.getExtension("http://jabber.org/protocol/nick");
                if (ext != null) {
                    displayName = ext.getName();
                }
                JabberSubscriptionListener jabberSubscriptionListener = this;
                synchronized (jabberSubscriptionListener) {
                    if (this.handler == null) {
                        this.earlySubscriptions.put(fromID, displayName);
                        return;
                    }
                }
                this.handleSubscribeReceived(fromID, displayName);
            } else if (presenceType == Presence.Type.unsubscribed) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(fromID + " does not allow your subscription"));
                }
                if (this.handler == null) {
                    logger.warn((Object)("No to handle unsubscribed AuthorizationHandler for " + fromID));
                    return;
                }
                ContactJabberImpl contact = OperationSetPersistentPresenceJabberImpl.this.ssContactList.findContactById(fromID);
                if (contact != null) {
                    AuthorizationResponse response = new AuthorizationResponse(AuthorizationResponse.REJECT, "");
                    this.handler.processAuthorizationResponse(response, (Contact)contact);
                    try {
                        OperationSetPersistentPresenceJabberImpl.this.ssContactList.removeContact(contact);
                    }
                    catch (OperationFailedException e) {
                        logger.error((Object)"Cannot remove contact that unsubscribed.");
                    }
                }
            } else if (presenceType == Presence.Type.subscribed) {
                if (this.handler == null) {
                    logger.warn((Object)("No AuthorizationHandler to handle subscribed for " + fromID));
                    return;
                }
                ContactJabberImpl contact = OperationSetPersistentPresenceJabberImpl.this.ssContactList.findContactById(fromID);
                AuthorizationResponse response = new AuthorizationResponse(AuthorizationResponse.ACCEPT, "");
                this.handler.processAuthorizationResponse(response, (Contact)contact);
            }
        }

        private void handleEarlySubscribeReceived() {
            for (String from : this.earlySubscriptions.keySet()) {
                this.handleSubscribeReceived(from, this.earlySubscriptions.get(from));
            }
            this.earlySubscriptions.clear();
        }

        private void handleSubscribeReceived(final String fromID, final String displayName) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(fromID + " wants to add you to its contact list"));
                    }
                    ContactJabberImpl srcContact = OperationSetPersistentPresenceJabberImpl.this.ssContactList.findContactById(fromID);
                    Presence.Type responsePresenceType = null;
                    if (srcContact == null) {
                        srcContact = OperationSetPersistentPresenceJabberImpl.this.createVolatileContact(fromID, displayName);
                    } else if (srcContact.isPersistent()) {
                        responsePresenceType = Presence.Type.subscribed;
                    }
                    if (responsePresenceType == null) {
                        AuthorizationRequest req = new AuthorizationRequest();
                        AuthorizationResponse response = JabberSubscriptionListener.this.handler.processAuthorisationRequest(req, (Contact)srcContact);
                        if (response != null) {
                            if (response.getResponseCode().equals(AuthorizationResponse.ACCEPT)) {
                                responsePresenceType = Presence.Type.subscribed;
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)"Sending Accepted Subscription");
                                }
                            } else if (response.getResponseCode().equals(AuthorizationResponse.REJECT)) {
                                responsePresenceType = Presence.Type.unsubscribed;
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)"Sending Rejected Subscription");
                                }
                            }
                        }
                    }
                    if (responsePresenceType == null) {
                        return;
                    }
                    Presence responsePacket = new Presence(responsePresenceType);
                    responsePacket.setTo(fromID);
                    ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getConnection().sendPacket((Packet)responsePacket);
                }
            }).start();
        }
    }

    class ContactChangesListener
    implements RosterListener {
        private boolean storeEvents = false;
        private List<Presence> storedPresences = null;
        private final Map<String, TreeSet<Presence>> statuses = new Hashtable<String, TreeSet<Presence>>();

        ContactChangesListener() {
        }

        public void entriesAdded(Collection<String> addresses) {
        }

        public void entriesUpdated(Collection<String> addresses) {
        }

        public void entriesDeleted(Collection<String> addresses) {
        }

        public void rosterError(XMPPError error, Packet packet) {
        }

        public void presenceChanged(Presence presence) {
            this.firePresenceStatusChanged(presence);
        }

        void storeEvents() {
            this.storedPresences = new ArrayList<Presence>();
            this.storeEvents = true;
        }

        void processStoredEvents() {
            this.storeEvents = false;
            for (Presence p : this.storedPresences) {
                this.firePresenceStatusChanged(p);
            }
            this.storedPresences.clear();
            this.storedPresences = null;
        }

        void firePresenceStatusChanged(Presence presence) {
            if (this.storeEvents && this.storedPresences != null) {
                this.storedPresences.add(presence);
                return;
            }
            try {
                Presence currentPresence;
                TreeSet<Presence> userStats;
                String userID = org.jivesoftware.smack.util.StringUtils.parseBareAddress((String)presence.getFrom());
                OperationSetMultiUserChat mucOpSet = (OperationSetMultiUserChat)((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getOperationSet(OperationSetMultiUserChat.class);
                if (mucOpSet != null) {
                    List chatRooms = mucOpSet.getCurrentlyJoinedChatRooms();
                    for (ChatRoom chatRoom : chatRooms) {
                        if (!chatRoom.getName().equals(userID)) continue;
                        userID = presence.getFrom();
                        break;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Received a status update for buddy=" + userID));
                }
                if ((userStats = this.statuses.get(userID)) == null) {
                    userStats = new TreeSet<Presence>(new Comparator<Presence>(){

                        @Override
                        public int compare(Presence o1, Presence o2) {
                            int res = o2.getPriority() - o1.getPriority();
                            if (res == 0) {
                                res = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(o2, (ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getStatus() - OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(o1, (ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getStatus();
                            }
                            return res;
                        }
                    });
                    this.statuses.put(userID, userStats);
                } else {
                    String resource = org.jivesoftware.smack.util.StringUtils.parseResource((String)presence.getFrom());
                    Iterator<Presence> iter = userStats.iterator();
                    while (iter.hasNext()) {
                        Presence p = iter.next();
                        if (!org.jivesoftware.smack.util.StringUtils.parseResource((String)p.getFrom()).equals(resource)) continue;
                        iter.remove();
                    }
                }
                if (!OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, (ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).equals((Object)((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getJabberStatusEnum().getStatus("Offline"))) {
                    userStats.add(presence);
                }
                if (userStats.size() == 0) {
                    currentPresence = presence;
                    this.statuses.remove(userID);
                } else {
                    currentPresence = userStats.first();
                }
                ContactJabberImpl sourceContact = OperationSetPersistentPresenceJabberImpl.this.ssContactList.findContactById(userID);
                if (sourceContact == null) {
                    logger.warn((Object)("No source contact found for id=" + userID));
                    return;
                }
                sourceContact.setStatusMessage(currentPresence.getStatus());
                OperationSetPersistentPresenceJabberImpl.this.updateContactStatus(sourceContact, OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(currentPresence, (ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider));
            }
            catch (IllegalStateException ex) {
                logger.error((Object)"Failed changing status", (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)"Failed changing status", (Throwable)ex);
            }
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The Jabber provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERING) {
                ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getConnection().addPacketListener((PacketListener)new ServerStoredListInit(), (PacketFilter)new PacketTypeFilter(RosterPacket.class));
                if (OperationSetPersistentPresenceJabberImpl.this.subscribtionPacketListener == null) {
                    OperationSetPersistentPresenceJabberImpl.this.subscribtionPacketListener = new JabberSubscriptionListener();
                    ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getConnection().addPacketListener((PacketListener)OperationSetPersistentPresenceJabberImpl.this.subscribtionPacketListener, (PacketFilter)new PacketTypeFilter(Presence.class));
                }
            } else if (evt.getNewState() == RegistrationState.REGISTERED) {
                OperationSetPersistentPresenceJabberImpl.this.createContactPhotoPresenceListener();
                OperationSetPersistentPresenceJabberImpl.this.createAccountPhotoPresenceInterceptor();
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                PresenceStatus oldStatus = OperationSetPersistentPresenceJabberImpl.this.currentStatus;
                JabberStatusEnum.JabberPresenceStatus offlineStatus = ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getJabberStatusEnum().getStatus("Offline");
                OperationSetPersistentPresenceJabberImpl.this.currentStatus = (PresenceStatus)offlineStatus;
                OperationSetPersistentPresenceJabberImpl.this.clearLocalContactResources();
                OperationSetPersistentPresenceJabberImpl.this.fireProviderStatusChangeEvent(oldStatus, OperationSetPersistentPresenceJabberImpl.this.currentStatus);
                OperationSetPersistentPresenceJabberImpl.this.ssContactList.cleanup();
                OperationSetPersistentPresenceJabberImpl.this.subscribtionPacketListener = null;
                XMPPConnection connection = ((ProtocolProviderServiceJabberImpl)OperationSetPersistentPresenceJabberImpl.this.parentProvider).getConnection();
                if (connection != null) {
                    connection.getRoster().removeRosterListener((RosterListener)OperationSetPersistentPresenceJabberImpl.this.contactChangesListener);
                }
                OperationSetPersistentPresenceJabberImpl.this.contactChangesListener = null;
            }
        }
    }
}

