/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.recording;

import net.java.sip.communicator.impl.protocol.jabber.extensions.jirecon.JireconIq;
import org.jitsi.jicofo.FocusBundleActivator;
import org.jitsi.jicofo.recording.Recorder;
import org.jitsi.protocol.xmpp.OperationSetDirectSmackXmpp;
import org.jitsi.util.Logger;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;

public class JireconRecorder
extends Recorder {
    private static final Logger logger = Logger.getLogger(JireconRecorder.class);
    static final String MEDIA_RECORDING_TOKEN_PNAME = "org.jitsi.videobridge.MEDIA_RECORDING_TOKEN";
    private final String mucRoomJid;
    private final String token;
    private JireconIq.Status status = JireconIq.Status.UNDEFINED;
    private String recordingId;

    public JireconRecorder(String mucRoomJid, String recorderComponentJid, OperationSetDirectSmackXmpp xmpp) {
        super(recorderComponentJid, xmpp);
        this.mucRoomJid = mucRoomJid;
        this.token = FocusBundleActivator.getConfigService().getString(MEDIA_RECORDING_TOKEN_PNAME);
    }

    public boolean isRecording() {
        return JireconIq.Status.INITIATING == this.status || JireconIq.Status.STARTED == this.status;
    }

    public boolean setRecording(String from, String token, boolean doRecord, String path) {
        if (!StringUtils.isNullOrEmpty((String)this.token) && !this.token.equals(token)) {
            return false;
        }
        if (!this.isRecording() && doRecord) {
            JireconIq recording = new JireconIq();
            recording.setTo(this.recorderComponentJid);
            recording.setType(IQ.Type.SET);
            recording.setFrom(from);
            recording.setMucJid(this.mucRoomJid);
            recording.setAction(JireconIq.Action.START);
            recording.setOutput(path);
            Packet reply = this.xmpp.getXmppConnection().sendPacketAndGetReply((Packet)recording);
            if (reply instanceof JireconIq) {
                JireconIq recResponse = (JireconIq)reply;
                if (JireconIq.Status.INITIATING.equals((Object)recResponse.getStatus())) {
                    this.recordingId = recResponse.getRid();
                    logger.info((Object)("Received recording ID: " + this.recordingId));
                    this.status = JireconIq.Status.INITIATING;
                } else {
                    logger.error((Object)("Unexpected status received: " + recResponse.toXML()));
                }
            } else {
                logger.error((Object)("Unexpected response: " + reply.toXML()));
            }
        } else if (this.isRecording() && !doRecord) {
            JireconIq recording = new JireconIq();
            recording.setTo(this.recorderComponentJid);
            recording.setType(IQ.Type.SET);
            recording.setFrom(from);
            recording.setRid(this.recordingId);
            recording.setMucJid(this.mucRoomJid);
            recording.setAction(JireconIq.Action.STOP);
            this.xmpp.getXmppConnection().sendPacket((Packet)recording);
            this.status = JireconIq.Status.STOPPING;
        }
        return true;
    }

    public boolean accept(Packet packet) {
        return packet instanceof JireconIq;
    }

    public void processPacket(Packet packet) {
        JireconIq recording = (JireconIq)packet;
        if (JireconIq.Action.INFO != recording.getAction() && IQ.Type.RESULT == recording.getType() || StringUtils.isNullOrEmpty((String)recording.getRid())) {
            logger.warn((Object)("Discarded: " + recording.toXML()));
            return;
        }
        if (!recording.getRid().equals(this.recordingId)) {
            logger.warn((Object)("Received IQ for unknown session: " + recording.toXML()));
            return;
        }
        if (this.status != recording.getStatus()) {
            this.status = recording.getStatus();
            logger.info((Object)("Recording " + this.recordingId + " status: " + this.status));
            if (this.status == JireconIq.Status.STOPPED) {
                logger.info((Object)("Recording STOPPED: " + this.recordingId));
                this.recordingId = null;
            }
        } else {
            logger.info((Object)("Ignored status change: " + recording.toXML()));
        }
    }
}

