/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.util.Logger;
import org.jitsi.impl.protocol.xmpp.extensions.MuteIq;
import org.jitsi.impl.protocol.xmpp.extensions.MuteIqProvider;
import org.jitsi.jicofo.JitsiMeetConference;
import org.jitsi.protocol.xmpp.OperationSetDirectSmackXmpp;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.ProviderManager;

public class MeetExtensionsHandler
implements PacketFilter,
PacketListener {
    private static final Logger logger = Logger.getLogger(MeetExtensionsHandler.class);
    private final JitsiMeetConference conference;
    private OperationSetDirectSmackXmpp smackXmpp;

    public MeetExtensionsHandler(JitsiMeetConference conference) {
        this.conference = conference;
        MuteIqProvider muteIqProvider = new MuteIqProvider();
        muteIqProvider.registerMuteIqProvider(ProviderManager.getInstance());
    }

    public void init() {
        this.smackXmpp = (OperationSetDirectSmackXmpp)this.conference.getXmppProvider().getOperationSet(OperationSetDirectSmackXmpp.class);
        this.smackXmpp.addPacketHandler(this, this);
    }

    public void dispose() {
        if (this.smackXmpp != null) {
            this.smackXmpp.removePacketHandler(this);
            this.smackXmpp = null;
        }
    }

    public boolean accept(Packet packet) {
        return this.acceptMuteIq(packet) || this.acceptColibriIQ(packet);
    }

    public void processPacket(Packet packet) {
        if (this.smackXmpp == null) {
            logger.error((Object)"Not initialized");
            return;
        }
        if (packet instanceof ColibriConferenceIQ) {
            this.handleColibriIq((ColibriConferenceIQ)packet);
        } else if (packet instanceof MuteIq) {
            this.handleMuteIq((MuteIq)packet);
        } else {
            logger.error((Object)("Unexpected packet: " + packet.toXML()));
        }
    }

    private boolean acceptColibriIQ(Packet packet) {
        String bridgeJid = this.conference.getServices().getVideobridge();
        return packet instanceof ColibriConferenceIQ && (bridgeJid == null || !bridgeJid.equals(packet.getFrom())) && ((ColibriConferenceIQ)packet).getRecording() != null;
    }

    private void handleColibriIq(ColibriConferenceIQ colibriIQ) {
        ColibriConferenceIQ.Recording recording = colibriIQ.getRecording();
        boolean recordingState = this.conference.modifyRecordingState(colibriIQ.getFrom(), recording.getToken(), recording.getState(), recording.getDirectory());
        ColibriConferenceIQ response = new ColibriConferenceIQ();
        response.setType(IQ.Type.RESULT);
        response.setPacketID(colibriIQ.getPacketID());
        response.setTo(colibriIQ.getFrom());
        response.setFrom(colibriIQ.getTo());
        response.setRecording(new ColibriConferenceIQ.Recording(recordingState));
        this.smackXmpp.getXmppConnection().sendPacket((Packet)response);
    }

    private boolean acceptMuteIq(Packet packet) {
        return packet instanceof MuteIq;
    }

    private void handleMuteIq(MuteIq muteIq) {
        IQ result;
        Boolean doMute = muteIq.getMute();
        String jid = muteIq.getJid();
        if (doMute == null || StringUtils.isNullOrEmpty((String)jid)) {
            return;
        }
        if (this.conference.handleMuteRequest(muteIq.getFrom(), jid, doMute)) {
            result = IQ.createResultIQ((IQ)muteIq);
            if (!muteIq.getFrom().equals(jid)) {
                MuteIq muteStatusUpdate = new MuteIq();
                muteStatusUpdate.setType(IQ.Type.SET);
                muteStatusUpdate.setTo(jid);
                muteStatusUpdate.setMute(doMute);
                this.smackXmpp.getXmppConnection().sendPacket((Packet)muteStatusUpdate);
            }
        } else {
            result = IQ.createErrorResponse((IQ)muteIq, (XMPPError)new XMPPError(XMPPError.Condition.interna_server_error));
        }
        this.smackXmpp.getXmppConnection().sendPacket((Packet)result);
    }
}

