/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import org.jitsi.jicofo.SSRCGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaSSRCGroupMap {
    private final Map<String, List<SSRCGroup>> groupMap;

    public MediaSSRCGroupMap() {
        this.groupMap = new HashMap<String, List<SSRCGroup>>();
    }

    private MediaSSRCGroupMap(Map<String, List<SSRCGroup>> map) {
        this.groupMap = map;
    }

    public List<SSRCGroup> getSSRCGroupsForMedia(String media) {
        List<SSRCGroup> mediaGroups = this.groupMap.get(media);
        if (mediaGroups == null) {
            mediaGroups = new ArrayList<SSRCGroup>();
            this.groupMap.put(media, mediaGroups);
        }
        return mediaGroups;
    }

    public static MediaSSRCGroupMap getSSRCGroupsForContents(List<ContentPacketExtension> contents) {
        MediaSSRCGroupMap mediaSSRCGroupMap = new MediaSSRCGroupMap();
        for (ContentPacketExtension content : contents) {
            List<SSRCGroup> mediaGroups = mediaSSRCGroupMap.getSSRCGroupsForMedia(content.getName());
            mediaGroups.addAll(SSRCGroup.getSSRCGroupsForContent(content));
        }
        return mediaSSRCGroupMap;
    }

    public List<String> getMediaTypes() {
        return new ArrayList<String>(this.groupMap.keySet());
    }

    public void addSSRCGroup(String media, SSRCGroup ssrcGroup) {
        this.getSSRCGroupsForMedia(media).add(ssrcGroup);
    }

    public void addSSRCGroups(String media, List<SSRCGroup> ssrcGroups) {
        this.getSSRCGroupsForMedia(media).addAll(ssrcGroups);
    }

    public void add(MediaSSRCGroupMap ssrcGroups) {
        for (String media : ssrcGroups.getMediaTypes()) {
            this.addSSRCGroups(media, ssrcGroups.getSSRCGroupsForMedia(media));
        }
    }

    public boolean isEmpty() {
        for (String media : this.groupMap.keySet()) {
            if (this.getSSRCGroupsForMedia(media).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void remove(MediaSSRCGroupMap mapToRemove) {
        for (String media : mapToRemove.groupMap.keySet()) {
            List<SSRCGroup> groupList = this.getSSRCGroupsForMedia(media);
            ArrayList<SSRCGroup> toBeRemoved = new ArrayList<SSRCGroup>();
            for (SSRCGroup ssrcGroupToCheck : mapToRemove.groupMap.get(media)) {
                for (SSRCGroup ssrcGroup : groupList) {
                    if (!ssrcGroupToCheck.equals(ssrcGroup)) continue;
                    toBeRemoved.add(ssrcGroup);
                }
            }
            groupList.removeAll(toBeRemoved);
        }
    }

    public MediaSSRCGroupMap copy() {
        HashMap<String, List<SSRCGroup>> mapCopy = new HashMap<String, List<SSRCGroup>>();
        for (String media : this.groupMap.keySet()) {
            ArrayList listToCopy = new ArrayList(this.groupMap.get(media));
            ArrayList<SSRCGroup> listCopy = new ArrayList<SSRCGroup>(listToCopy.size());
            for (SSRCGroup group : listToCopy) {
                listCopy.add(group.copy());
            }
            mapCopy.put(media, listCopy);
        }
        return new MediaSSRCGroupMap(mapCopy);
    }
}

