/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.util.List;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.jicofo.BridgeSelector;
import org.jitsi.jicofo.ProtocolProviderHandler;
import org.jitsi.protocol.xmpp.OperationSetSimpleCaps;
import org.jitsi.protocol.xmpp.OperationSetSubscription;

public class JitsiMeetServices
implements RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(JitsiMeetServices.class);
    public static final String[] VIDEOBRIDGE_FEATURES = new String[]{"http://jitsi.org/protocol/colibri", "urn:xmpp:jingle:apps:dtls:0", "urn:xmpp:jingle:transports:ice-udp:1", "urn:xmpp:jingle:transports:raw-udp:1"};
    private static final String[] JIRECON_RECORDER_FEATURES = new String[]{"http://jitsi.org/protocol/jirecon"};
    private static final String[] SIP_GW_FEATURES = new String[]{"http://jitsi.org/protocol/jigasi", "urn:xmpp:rayo:0"};
    private static final String[] PUBSUB_FEATURES = new String[]{"http://jabber.org/protocol/pubsub", "http://jabber.org/protocol/pubsub#subscribe"};
    private OperationSetSimpleCaps capsOpSet;
    private String xmppDomain;
    private BridgeSelector bridgeSelector;
    private ProtocolProviderHandler protocolProviderHandler;
    private String jireconRecorder;
    private String sipGateway;

    public void start(String serverAddress, String xmppDomain, String xmppAuthDomain, String xmppUserName, String xmppLoginPassword) {
        if (this.protocolProviderHandler != null) {
            throw new IllegalStateException("Already started");
        }
        this.xmppDomain = xmppDomain;
        this.protocolProviderHandler = new ProtocolProviderHandler();
        this.protocolProviderHandler.start(serverAddress, xmppAuthDomain, xmppLoginPassword, xmppUserName, this);
        this.capsOpSet = this.protocolProviderHandler.getOperationSet(OperationSetSimpleCaps.class);
        this.bridgeSelector = new BridgeSelector((OperationSetSubscription)this.protocolProviderHandler.getProtocolProvider().getOperationSet(OperationSetSubscription.class));
        if (this.protocolProviderHandler.isRegistered()) {
            this.init();
        } else {
            this.protocolProviderHandler.register();
        }
    }

    public void stop() {
        if (this.protocolProviderHandler != null) {
            this.protocolProviderHandler.stop();
            this.protocolProviderHandler = null;
        }
    }

    public void init() {
        List<String> items = this.capsOpSet.getItems(this.xmppDomain);
        for (String item : items) {
            if (this.capsOpSet.hasFeatureSupport(item, VIDEOBRIDGE_FEATURES)) {
                logger.info((Object)("Discovered videobridge: " + item));
                this.bridgeSelector.addJvbAddress(item);
                continue;
            }
            if (this.jireconRecorder == null && this.capsOpSet.hasFeatureSupport(item, JIRECON_RECORDER_FEATURES)) {
                logger.info((Object)("Discovered Jirecon recorder: " + item));
                this.setJireconRecorder(item);
                continue;
            }
            if (this.sipGateway != null || !this.capsOpSet.hasFeatureSupport(item, SIP_GW_FEATURES)) continue;
            logger.info((Object)("Discovered SIP gateway: " + item));
            this.setSipGateway(item);
        }
    }

    public String getVideobridge() {
        return this.bridgeSelector.selectVideobridge();
    }

    private void setSipGateway(String sipGateway) {
        this.sipGateway = sipGateway;
    }

    public void setJireconRecorder(String jireconRecorder) {
        this.jireconRecorder = jireconRecorder;
    }

    public String getJireconRecorder() {
        return this.jireconRecorder;
    }

    public BridgeSelector getBridgeSelector() {
        return this.bridgeSelector;
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (RegistrationState.REGISTERED.equals((Object)evt.getNewState())) {
            this.init();
        }
    }

    public OperationSetSimpleCaps getCapsOpSet() {
        return this.capsOpSet;
    }
}

