/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtcpmuxPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SctpMapExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SourceGroupPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Base64;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.jicofo.BridgeSelector;
import org.jitsi.jicofo.ChatRoomRoleAndPresence;
import org.jitsi.jicofo.FocusBundleActivator;
import org.jitsi.jicofo.JitsiMeetServices;
import org.jitsi.jicofo.MediaSSRCGroupMap;
import org.jitsi.jicofo.MeetExtensionsHandler;
import org.jitsi.jicofo.Participant;
import org.jitsi.jicofo.ProtocolProviderHandler;
import org.jitsi.jicofo.SSRCGroup;
import org.jitsi.jicofo.log.LogEventFactory;
import org.jitsi.jicofo.log.LogPacketExtension;
import org.jitsi.jicofo.recording.JireconRecorder;
import org.jitsi.jicofo.recording.JvbRecorder;
import org.jitsi.jicofo.recording.Recorder;
import org.jitsi.jicofo.util.JingleOfferFactory;
import org.jitsi.protocol.JitsiMeetConfig;
import org.jitsi.protocol.xmpp.JingleRequestHandler;
import org.jitsi.protocol.xmpp.JingleSession;
import org.jitsi.protocol.xmpp.OperationSetColibriConference;
import org.jitsi.protocol.xmpp.OperationSetDirectSmackXmpp;
import org.jitsi.protocol.xmpp.OperationSetJingle;
import org.jitsi.protocol.xmpp.OperationSetSimpleCaps;
import org.jitsi.protocol.xmpp.XmppChatMember;
import org.jitsi.protocol.xmpp.util.MediaSSRCMap;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.StringUtils;
import org.jitsi.videobridge.log.LoggingService;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JitsiMeetConference
implements RegistrationStateChangeListener,
JingleRequestHandler {
    private static final Logger logger = Logger.getLogger(JitsiMeetConference.class);
    private static final String FOCUS_NICK = "focus";
    private final String roomName;
    private final String serverAddress;
    private final String xmppDomain;
    private final String xmppLoginPassword;
    private final ConferenceListener listener;
    private final JitsiMeetConfig config;
    private ProtocolProviderHandler protocolProviderHandler = new ProtocolProviderHandler();
    private OperationSetMultiUserChat chatOpSet;
    private ChatRoom chatRoom;
    private OperationSetJingle jingle;
    private OperationSetColibriConference colibri;
    private final List<Participant> participants = new CopyOnWriteArrayList<Participant>();
    private OperationSetSimpleCaps disco;
    private JitsiMeetServices services;
    private MeetExtensionsHandler meetExtensionsHandler;
    private Recorder recorder;
    private ChatRoomRoleAndPresence presenceHandler;
    private boolean started;
    private long idleTimestamp = -1L;
    private final PacketListener messageListener = new MessageListener();

    public JitsiMeetConference(String roomName, String serverAddress, String xmppDomain, String xmppLoginPassword, ConferenceListener listener, JitsiMeetConfig config) {
        this.roomName = roomName;
        this.serverAddress = serverAddress;
        this.xmppDomain = xmppDomain != null ? xmppDomain : serverAddress;
        this.xmppLoginPassword = xmppLoginPassword;
        this.listener = listener;
        this.config = config;
    }

    public JitsiMeetConference(String roomName, String serverAddress, ConferenceListener listener) {
        this(roomName, serverAddress, null, null, listener, new JitsiMeetConfig(new HashMap<String, String>()));
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.protocolProviderHandler.start(this.serverAddress, this.xmppDomain, this.xmppLoginPassword, FOCUS_NICK, this);
        this.colibri = this.protocolProviderHandler.getOperationSet(OperationSetColibriConference.class);
        this.colibri.setJitsiMeetConfig(this.config);
        this.jingle = this.protocolProviderHandler.getOperationSet(OperationSetJingle.class);
        this.jingle.setRequestHandler(this);
        this.chatOpSet = this.protocolProviderHandler.getOperationSet(OperationSetMultiUserChat.class);
        this.disco = this.protocolProviderHandler.getOperationSet(OperationSetSimpleCaps.class);
        this.meetExtensionsHandler = new MeetExtensionsHandler(this);
        this.services = (JitsiMeetServices)ServiceUtils.getService((BundleContext)FocusBundleActivator.bundleContext, JitsiMeetServices.class);
        if (!this.protocolProviderHandler.isRegistered()) {
            this.protocolProviderHandler.register();
        } else {
            this.joinTheRoom();
        }
        this.idleTimestamp = System.currentTimeMillis();
        this.started = true;
    }

    public boolean isInTheRoom() {
        return this.chatRoom != null && this.chatRoom.isJoined();
    }

    private void maybeJoinTheRoom() {
        if (this.chatRoom == null && this.protocolProviderHandler.isRegistered()) {
            logger.info((Object)("Registered: " + this.protocolProviderHandler));
            this.joinTheRoom();
        }
    }

    private void joinTheRoom() {
        logger.info((Object)("Joining the room: " + this.roomName));
        try {
            this.chatRoom = this.chatOpSet.findRoom(this.roomName);
            this.presenceHandler = new ChatRoomRoleAndPresence(this, this.chatRoom);
            this.presenceHandler.init();
            this.chatRoom.join();
            this.meetExtensionsHandler.init();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.stop();
        }
    }

    private OperationSetDirectSmackXmpp getDirectXmppOpSet() {
        return this.protocolProviderHandler.getOperationSet(OperationSetDirectSmackXmpp.class);
    }

    private Recorder getRecorder() {
        if (this.recorder == null) {
            OperationSetDirectSmackXmpp xmppOpSet = this.protocolProviderHandler.getOperationSet(OperationSetDirectSmackXmpp.class);
            String recorderService = this.services.getJireconRecorder();
            if (!StringUtils.isNullOrEmpty((String)recorderService)) {
                this.recorder = new JireconRecorder(this.getFocusJid(), this.services.getJireconRecorder(), xmppOpSet);
            } else {
                logger.warn((Object)"No recorder service discovered - using JVB");
                this.recorder = new JvbRecorder(this.colibri.getConferenceId(), this.services.getVideobridge(), xmppOpSet);
            }
        }
        return this.recorder;
    }

    private void leaveTheRoom() {
        if (this.chatRoom == null) {
            logger.error((Object)"Chat room already left!");
            return;
        }
        if (this.presenceHandler != null) {
            this.presenceHandler.dispose();
            this.presenceHandler = null;
        }
        this.chatRoom.leave();
        this.chatRoom = null;
    }

    protected void onMemberJoined(final ChatRoomMember chatRoomMember) {
        logger.info((Object)("Member " + chatRoomMember.getName() + " joined " + this.chatRoom.getName()));
        this.idleTimestamp = -1L;
        if (!this.initConference()) {
            return;
        }
        FocusBundleActivator.getSharedThreadPool().submit(new Runnable(){

            public void run() {
                JitsiMeetConference.this.inviteChatMember(chatRoomMember);
            }
        });
    }

    private void inviteChatMember(ChatRoomMember chatRoomMember) {
        if (JitsiMeetConference.isFocusMember(chatRoomMember)) {
            return;
        }
        if (this.findParticipantForChatMember(chatRoomMember) != null) {
            return;
        }
        logger.info((Object)("Inviting " + chatRoomMember.getContactAddress()));
        String address = chatRoomMember.getContactAddress();
        Participant newParticipant = new Participant((XmppChatMember)chatRoomMember);
        this.participants.add(newParticipant);
        newParticipant.setHasBundleSupport(this.disco.hasFeatureSupport(address, new String[]{"urn:ietf:rfc:5761", "urn:ietf:rfc:5888"}));
        newParticipant.setIsSipGateway(this.disco.hasFeatureSupport(address, new String[]{"http://jitsi.org/protocol/jigasi"}));
        logger.info((Object)(chatRoomMember.getContactAddress() + " has bundle ? " + newParticipant.hasBundleSupport()));
        try {
            List<ContentPacketExtension> offer = this.createOffer(newParticipant);
            this.jingle.initiateSession(newParticipant.hasBundleSupport(), address, offer);
        }
        catch (OperationFailedException e) {
            logger.error((Object)("Failed to invite " + chatRoomMember.getContactAddress()), (Throwable)e);
            this.participants.remove(newParticipant);
        }
    }

    private ColibriConferenceIQ allocateChannels(Participant peer, List<ContentPacketExtension> contents) throws OperationFailedException {
        BridgeSelector bridgeSelector = this.services.getBridgeSelector();
        Iterator<String> bridgesIterator = bridgeSelector.getPrioritizedBridgesList().iterator();
        if (StringUtils.isNullOrEmpty((String)this.colibri.getJitsiVideobridge())) {
            if (!bridgesIterator.hasNext()) {
                throw new OperationFailedException("Failed to allocate channels - no bridge configured", 1);
            }
            this.colibri.setJitsiVideobridge(bridgesIterator.next());
        }
        boolean conferenceExists = this.colibri.getConferenceId() != null;
        while (true) {
            try {
                LoggingService loggingService;
                String conferenceId;
                ColibriConferenceIQ peerChannels = this.colibri.createColibriChannels(peer.hasBundleSupport(), peer.getChatMember().getName(), true, contents);
                bridgeSelector.updateBridgeOperationalStatus(this.colibri.getJitsiVideobridge(), true);
                if (!conferenceExists && (conferenceId = this.colibri.getConferenceId()) != null && (loggingService = FocusBundleActivator.getLoggingService()) != null) {
                    loggingService.logEvent(LogEventFactory.conferenceRoom(conferenceId, this.roomName));
                }
                return peerChannels;
            }
            catch (OperationFailedException exc) {
                String faultyBridge = this.colibri.getJitsiVideobridge();
                logger.error((Object)("Failed to allocate channels using bridge: " + this.colibri.getJitsiVideobridge()), (Throwable)exc);
                bridgeSelector.updateBridgeOperationalStatus(faultyBridge, false);
                if (!StringUtils.isNullOrEmpty((String)this.colibri.getConferenceId())) {
                    logger.error((Object)"Bridge failure - stopping the conference");
                    this.stop();
                    continue;
                }
                if (!bridgesIterator.hasNext()) {
                    throw new OperationFailedException("Failed to allocate channels - all bridges are faulty", 1);
                }
                this.colibri.setJitsiVideobridge(bridgesIterator.next());
                continue;
            }
            break;
        }
    }

    private List<ContentPacketExtension> createOffer(Participant peer) throws OperationFailedException {
        ArrayList<ContentPacketExtension> contents = new ArrayList<ContentPacketExtension>();
        contents.add(JingleOfferFactory.createContentForMedia(MediaType.AUDIO));
        contents.add(JingleOfferFactory.createContentForMedia(MediaType.VIDEO));
        contents.add(JingleOfferFactory.createContentForMedia(MediaType.DATA));
        boolean useBundle = peer.hasBundleSupport();
        ColibriConferenceIQ peerChannels = this.allocateChannels(peer, contents);
        peer.setColibriChannelsInfo(peerChannels);
        for (ContentPacketExtension cpe : contents) {
            IceUdpTransportPacketExtension empty;
            IceUdpTransportPacketExtension transport;
            ColibriConferenceIQ.ChannelBundle bundle;
            ColibriConferenceIQ.Content colibriContent = peerChannels.getContent(cpe.getName());
            if (colibriContent == null) continue;
            for (ColibriConferenceIQ.Channel channel : colibriContent.getChannels()) {
                if (useBundle) {
                    bundle = peerChannels.getChannelBundle(channel.getChannelBundleId());
                    if (bundle == null) {
                        logger.error((Object)("No bundle for " + channel.getChannelBundleId()));
                        continue;
                    }
                    transport = bundle.getTransport();
                    if (!transport.isRtcpMux()) {
                        transport.addChildExtension((PacketExtension)new RtcpmuxPacketExtension());
                    }
                } else {
                    transport = channel.getTransport();
                }
                try {
                    empty = (IceUdpTransportPacketExtension)cpe.getFirstChildOfType(IceUdpTransportPacketExtension.class);
                    cpe.getChildExtensions().remove(empty);
                    cpe.addChildExtension((PacketExtension)IceUdpTransportPacketExtension.cloneTransportAndCandidates((IceUdpTransportPacketExtension)transport, (boolean)true));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            for (ColibriConferenceIQ.SctpConnection sctpConn : colibriContent.getSctpConnections()) {
                if (useBundle) {
                    bundle = peerChannels.getChannelBundle(sctpConn.getChannelBundleId());
                    if (bundle == null) {
                        logger.error((Object)("No bundle for " + sctpConn.getChannelBundleId()));
                        continue;
                    }
                    transport = bundle.getTransport();
                } else {
                    transport = sctpConn.getTransport();
                }
                try {
                    empty = (IceUdpTransportPacketExtension)cpe.getFirstChildOfType(IceUdpTransportPacketExtension.class);
                    cpe.getChildExtensions().remove(empty);
                    IceUdpTransportPacketExtension copy = IceUdpTransportPacketExtension.cloneTransportAndCandidates((IceUdpTransportPacketExtension)transport, (boolean)true);
                    SctpMapExtension sctpMap = new SctpMapExtension();
                    sctpMap.setPort(5000);
                    sctpMap.setProtocol(SctpMapExtension.Protocol.WEBRTC_CHANNEL);
                    sctpMap.setStreams(1024);
                    copy.addChildExtension((PacketExtension)sctpMap);
                    cpe.addChildExtension((PacketExtension)copy);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            RtpDescriptionPacketExtension rtpDescPe = JingleUtils.getRtpDescription((ContentPacketExtension)cpe);
            if (rtpDescPe == null) continue;
            if (useBundle) {
                rtpDescPe.addChildExtension((PacketExtension)new RtcpmuxPacketExtension());
            }
            List<SourcePacketExtension> mediaSources = this.getAllSSRCs(cpe.getName());
            for (SourcePacketExtension ssrc : mediaSources) {
                try {
                    rtpDescPe.addChildExtension((PacketExtension)ssrc.copy());
                }
                catch (Exception e) {
                    logger.error((Object)"Copy SSRC error", (Throwable)e);
                }
            }
            List<SourceGroupPacketExtension> sourceGroups = this.getAllSSRCGroups(cpe.getName());
            for (SourceGroupPacketExtension ssrcGroup : sourceGroups) {
                rtpDescPe.addChildExtension((PacketExtension)ssrcGroup);
            }
            for (ColibriConferenceIQ.Channel channel : colibriContent.getChannels()) {
                SourcePacketExtension ssrcPe = channel.getSources().size() > 0 ? (SourcePacketExtension)channel.getSources().get(0) : null;
                if (ssrcPe == null) continue;
                try {
                    String contentName = colibriContent.getName();
                    SourcePacketExtension ssrcCopy = ssrcPe.copy();
                    ssrcCopy.addParameter(new ParameterPacketExtension("cname", "mixed"));
                    ssrcCopy.addParameter(new ParameterPacketExtension("label", "mixedlabel" + contentName + "0"));
                    ssrcCopy.addParameter(new ParameterPacketExtension("msid", "mixedmslabel mixedlabel" + contentName + "0"));
                    ssrcCopy.addParameter(new ParameterPacketExtension("mslabel", "mixedmslabel"));
                    rtpDescPe.addChildExtension((PacketExtension)ssrcCopy);
                }
                catch (Exception e) {
                    logger.error((Object)"Copy SSRC error", (Throwable)e);
                }
            }
        }
        return contents;
    }

    private boolean initConference() {
        if (!this.checkAtLeastTwoParticipants()) {
            return false;
        }
        for (ChatRoomMember member : this.chatRoom.getMembers()) {
            this.inviteChatMember(member);
        }
        return true;
    }

    private boolean checkAtLeastTwoParticipants() {
        if (this.chatRoom.getMembersCount() >= 3) {
            return true;
        }
        int realCount = 0;
        for (ChatRoomMember member : this.chatRoom.getMembers()) {
            if (JitsiMeetConference.isFocusMember(member)) continue;
            ++realCount;
        }
        return realCount >= 2;
    }

    private boolean checkAtLeastOneHumanParticipants() {
        int humanCount = 0;
        for (Participant participant : this.participants) {
            if (JitsiMeetConference.isFocusMember(participant.getChatMember()) || participant.isSipGateway()) continue;
            ++humanCount;
        }
        return humanCount > 0;
    }

    static boolean isFocusMember(ChatRoomMember member) {
        return member.getName().equals(FOCUS_NICK);
    }

    boolean isSipGateway(ChatRoomMember member) {
        Participant participant = this.findParticipantForChatMember(member);
        return participant != null && participant.isSipGateway();
    }

    private void disposeConference() {
        if (this.recorder != null) {
            this.recorder.dispose();
            this.recorder = null;
        }
        this.meetExtensionsHandler.dispose();
        this.colibri.expireConference();
    }

    protected void onMemberKicked(ChatRoomMember chatRoomMember) {
        logger.info((Object)("Member " + chatRoomMember.getName() + " kicked !!! " + this.chatRoom.getName()));
        this.onMemberLeft(chatRoomMember);
    }

    protected synchronized void onMemberLeft(ChatRoomMember chatRoomMember) {
        logger.info((Object)("Member " + chatRoomMember.getName() + " left " + this.chatRoom.getName()));
        Participant leftPeer = this.findParticipantForChatMember(chatRoomMember);
        if (leftPeer != null) {
            JingleSession peerJingleSession = leftPeer.getJingleSession();
            if (peerJingleSession != null) {
                logger.info((Object)("Hanging up member " + chatRoomMember.getContactAddress()));
                this.removeSSRCs(peerJingleSession, leftPeer.getSSRCsCopy(), leftPeer.getSSRCGroupsCopy());
                ColibriConferenceIQ peerChannels = leftPeer.getColibriChannelsInfo();
                if (peerChannels != null) {
                    this.colibri.expireChannels(leftPeer.getColibriChannelsInfo());
                }
            }
            this.participants.remove(leftPeer);
        }
        if (!this.checkAtLeastOneHumanParticipants()) {
            for (Participant participant : this.participants) {
                try {
                    this.terminateParticipant(participant);
                }
                catch (OperationFailedException e) {
                    logger.error((Object)e, (Throwable)e);
                    this.stop();
                    break;
                }
            }
        }
        if (this.participants.size() == 0) {
            this.stop();
        }
    }

    synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.getDirectXmppOpSet().removePacketHandler(this.messageListener);
        this.disposeConference();
        this.leaveTheRoom();
        this.disposeAccount();
        this.listener.conferenceEnded(this);
        this.started = false;
    }

    private void disposeAccount() {
        this.jingle.setRequestHandler(null);
        this.protocolProviderHandler.stop();
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        logger.info((Object)("Reg state changed: " + evt));
        if (RegistrationState.REGISTERED.equals((Object)evt.getNewState())) {
            this.getDirectXmppOpSet().addPacketHandler(this.messageListener, (PacketFilter)new MessageTypeFilter(Message.Type.normal));
        }
        this.maybeJoinTheRoom();
    }

    private Participant findParticipantForJingleSession(JingleSession jingleSession) {
        for (Participant participant : this.participants) {
            if (!participant.getChatMember().getContactAddress().equals(jingleSession.getAddress())) continue;
            return participant;
        }
        return null;
    }

    private Participant findParticipantForChatMember(ChatRoomMember chatMember) {
        for (Participant participant : this.participants) {
            if (!participant.getChatMember().equals(chatMember)) continue;
            return participant;
        }
        return null;
    }

    private Participant findParticipantForJabberId(String jid) {
        for (Participant participant : this.participants) {
            String peerJid = participant.getChatMember().getJabberID();
            if (peerJid == null || !peerJid.equals(jid)) continue;
            return participant;
        }
        return null;
    }

    Participant findParticipantForRoomJid(String roomJid) {
        for (Participant participant : this.participants) {
            String peerRoomJid = participant.getJingleSession().getAddress();
            if (peerRoomJid == null || !peerRoomJid.equals(roomJid)) continue;
            return participant;
        }
        return null;
    }

    private Participant findParticipantForMucAddress(String mucAddress) {
        for (Participant participant : this.participants) {
            if (!participant.getChatMember().getContactAddress().equals(mucAddress)) continue;
            return participant;
        }
        return null;
    }

    private void terminateParticipant(Participant participant) throws OperationFailedException {
        JingleSession session = participant.getJingleSession();
        if (session != null) {
            this.jingle.terminateSession(session, Reason.EXPIRED);
        }
        this.chatRoom.kickParticipant((ChatRoomMember)participant.getChatMember(), "End of the conference");
    }

    @Override
    public void onSessionAccept(JingleSession peerJingleSession, List<ContentPacketExtension> answer) {
        Participant participant = this.findParticipantForJingleSession(peerJingleSession);
        if (participant.getJingleSession() != null) {
            logger.error((Object)("Reassigning jingle session for participant: " + peerJingleSession.getAddress()));
        }
        participant.setJingleSession(peerJingleSession);
        participant.addSSRCsFromContent(answer);
        participant.addSSRCGroupsFromContent(answer);
        this.colibri.updateSsrcGroupsInfo(participant.getSSRCGroupsCopy(), participant.getColibriChannelsInfo());
        logger.info((Object)("Got SSRCs from " + peerJingleSession.getAddress()));
        for (Participant peerToNotify : this.participants) {
            JingleSession jingleSessionToNotify = peerToNotify.getJingleSession();
            if (jingleSessionToNotify == null) {
                logger.warn((Object)("No jingle session yet for " + peerToNotify.getChatMember().getContactAddress()));
                peerToNotify.scheduleSSRCsToAdd(participant.getSSRCS());
                peerToNotify.scheduleSSRCGroupsToAdd(participant.getSSRCGroups());
                continue;
            }
            if (peerJingleSession.equals(jingleSessionToNotify)) continue;
            this.jingle.sendAddSourceIQ(participant.getSSRCS(), participant.getSSRCGroups(), jingleSessionToNotify);
        }
        if (participant.hasSsrcsToAdd()) {
            this.jingle.sendAddSourceIQ(participant.getSsrcsToAdd(), participant.getSSRCGroupsToAdd(), peerJingleSession);
            participant.clearSsrcsToAdd();
        }
        if (participant.hasSsrcsToRemove()) {
            this.jingle.sendRemoveSourceIQ(participant.getSsrcsToRemove(), participant.getSsrcGroupsToRemove(), peerJingleSession);
            participant.clearSsrcsToRemove();
        }
        this.onTransportInfo(peerJingleSession, answer);
    }

    @Override
    public void onTransportInfo(JingleSession session, List<ContentPacketExtension> contentList) {
        Participant participant = this.findParticipantForJingleSession(session);
        if (participant == null) {
            logger.error((Object)("Failed to process transport-info, no session for: " + session.getAddress()));
            return;
        }
        if (participant.hasBundleSupport()) {
            IceUdpTransportPacketExtension transport = null;
            for (ContentPacketExtension cpe : contentList) {
                IceUdpTransportPacketExtension contentTransport = (IceUdpTransportPacketExtension)cpe.getFirstChildOfType(IceUdpTransportPacketExtension.class);
                if (contentTransport == null) continue;
                transport = contentTransport;
                break;
            }
            if (transport == null) {
                logger.error((Object)("No valid transport suppied in transport-update from " + participant.getChatMember().getName()));
                return;
            }
            transport.addChildExtension((PacketExtension)new RtcpmuxPacketExtension());
            boolean initiator = true;
            this.colibri.updateBundleTransportInfo(initiator, transport, participant.getColibriChannelsInfo());
        } else {
            HashMap<String, IceUdpTransportPacketExtension> transportMap = new HashMap<String, IceUdpTransportPacketExtension>();
            for (ContentPacketExtension cpe : contentList) {
                IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)cpe.getFirstChildOfType(IceUdpTransportPacketExtension.class);
                if (transport == null) continue;
                transportMap.put(cpe.getName(), transport);
            }
            boolean initiator = true;
            this.colibri.updateTransportInfo(initiator, transportMap, participant.getColibriChannelsInfo());
        }
    }

    @Override
    public void onAddSource(JingleSession jingleSession, List<ContentPacketExtension> contents) {
        Participant participant = this.findParticipantForJingleSession(jingleSession);
        if (participant == null) {
            logger.error((Object)("Add-source: no peer state for " + jingleSession.getAddress()));
            return;
        }
        participant.addSSRCsFromContent(contents);
        participant.addSSRCGroupsFromContent(contents);
        MediaSSRCMap ssrcsToAdd = MediaSSRCMap.getSSRCsFromContent(contents);
        MediaSSRCGroupMap ssrcGroupsToAdd = MediaSSRCGroupMap.getSSRCGroupsForContents(contents);
        this.colibri.updateSsrcGroupsInfo(participant.getSSRCGroupsCopy(), participant.getColibriChannelsInfo());
        for (Participant peerToNotify : this.participants) {
            if (peerToNotify == participant) continue;
            JingleSession peerJingleSession = peerToNotify.getJingleSession();
            if (peerJingleSession == null) {
                logger.warn((Object)("Add source: no call for " + peerToNotify.getChatMember().getContactAddress()));
                peerToNotify.scheduleSSRCsToAdd(ssrcsToAdd);
                peerToNotify.scheduleSSRCGroupsToAdd(ssrcGroupsToAdd);
                continue;
            }
            this.jingle.sendAddSourceIQ(ssrcsToAdd, ssrcGroupsToAdd, peerJingleSession);
        }
    }

    @Override
    public void onRemoveSource(JingleSession sourceJingleSession, List<ContentPacketExtension> contents) {
        MediaSSRCMap ssrcsToRemove = MediaSSRCMap.getSSRCsFromContent(contents);
        MediaSSRCGroupMap ssrcGroupsToRemove = MediaSSRCGroupMap.getSSRCGroupsForContents(contents);
        this.removeSSRCs(sourceJingleSession, ssrcsToRemove, ssrcGroupsToRemove);
    }

    private void removeSSRCs(JingleSession sourceJingleSession, MediaSSRCMap ssrcsToRemove, MediaSSRCGroupMap ssrcGroupsToRemove) {
        Participant sourcePeer = this.findParticipantForJingleSession(sourceJingleSession);
        if (sourcePeer == null) {
            logger.error((Object)("Remove-source: no session for " + sourceJingleSession.getAddress()));
            return;
        }
        sourcePeer.removeSSRCs(ssrcsToRemove);
        sourcePeer.removeSSRCGroups(ssrcGroupsToRemove);
        this.colibri.updateSsrcGroupsInfo(ssrcGroupsToRemove, sourcePeer.getColibriChannelsInfo());
        logger.info((Object)("Remove SSRC " + sourceJingleSession.getAddress()));
        for (Participant peer : this.participants) {
            if (peer == sourcePeer) continue;
            JingleSession jingleSessionToNotify = peer.getJingleSession();
            if (jingleSessionToNotify == null) {
                logger.warn((Object)("Remove source: no jingle session for " + peer.getChatMember().getContactAddress()));
                peer.scheduleSSRCsToRemove(ssrcsToRemove);
                peer.scheduleSSRCGroupsToRemove(ssrcGroupsToRemove);
                continue;
            }
            this.jingle.sendRemoveSourceIQ(ssrcsToRemove, ssrcGroupsToRemove, jingleSessionToNotify);
        }
    }

    private List<SourcePacketExtension> getAllSSRCs(String media) {
        ArrayList<SourcePacketExtension> mediaSSRCs = new ArrayList<SourcePacketExtension>();
        for (Participant peer : this.participants) {
            List<SourcePacketExtension> peerSSRC = peer.getSSRCS().getSSRCsForMedia(media);
            if (peerSSRC == null) continue;
            mediaSSRCs.addAll(peerSSRC);
        }
        return mediaSSRCs;
    }

    private List<SourceGroupPacketExtension> getAllSSRCGroups(String media) {
        ArrayList<SourceGroupPacketExtension> ssrcGroups = new ArrayList<SourceGroupPacketExtension>();
        for (Participant peer : this.participants) {
            List<SSRCGroup> peerSSRCGroups = peer.getSSRCGroupsForMedia(media);
            for (SSRCGroup ssrcGroup : peerSSRCGroups) {
                try {
                    ssrcGroups.add(ssrcGroup.getExtensionCopy());
                }
                catch (Exception e) {
                    logger.error((Object)"Error copying source group extension");
                }
            }
        }
        return ssrcGroups;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public ProtocolProviderService getXmppProvider() {
        return this.protocolProviderHandler.getProtocolProvider();
    }

    public boolean modifyRecordingState(String from, String token, boolean state, String path) {
        ChatRoomMember member = this.findMember(from);
        if (member == null) {
            logger.error((Object)("No member found for address: " + from));
            return false;
        }
        if (ChatRoomMemberRole.MODERATOR.compareTo((Enum)member.getRole()) < 0) {
            logger.info((Object)("Recording - request denied, not a moderator: " + from));
            return false;
        }
        Recorder recorder = this.getRecorder();
        if (recorder == null) {
            return false;
        }
        boolean isTokenCorrect = recorder.setRecording(from, token, state, path);
        if (!isTokenCorrect) {
            logger.info((Object)("Incorrect recording token received ! Session: " + this.chatRoom.getName()));
        }
        return recorder.isRecording();
    }

    private ChatRoomMember findMember(String from) {
        for (ChatRoomMember member : this.chatRoom.getMembers()) {
            if (!member.getContactAddress().equals(from)) continue;
            return member;
        }
        return null;
    }

    public long getIdleTimestamp() {
        return this.idleTimestamp;
    }

    public String getFocusJid() {
        return this.chatRoom != null ? this.chatRoom.getName() + "/" + FOCUS_NICK : null;
    }

    public JitsiMeetServices getServices() {
        return this.services;
    }

    boolean handleMuteRequest(String fromJid, String toBeMutedJid, boolean doMute) {
        Participant principal = this.findParticipantForMucAddress(fromJid);
        if (principal == null) {
            logger.error((Object)("Failed to perform mute operation - " + fromJid + " not exists in the conference."));
            return false;
        }
        if (!fromJid.equals(toBeMutedJid) && ChatRoomMemberRole.MODERATOR.compareTo((Enum)principal.getChatMember().getRole()) < 0) {
            logger.error((Object)("Permission denied for mute operation from " + fromJid));
            return false;
        }
        Participant participant = this.findParticipantForMucAddress(toBeMutedJid);
        if (participant == null) {
            logger.error((Object)("Participant for jid: " + toBeMutedJid + " not found"));
            return false;
        }
        logger.info((Object)("Will " + (doMute ? "mute" : "unmute") + " " + toBeMutedJid + " on behalf of " + fromJid));
        boolean succeeded = this.colibri.muteParticipant(participant.getColibriChannelsInfo(), doMute);
        if (succeeded) {
            participant.setMuted(doMute);
        }
        return succeeded;
    }

    void userAuthenticated(String realJid, String identity) {
        logger.info((Object)("Authenticate request for: " + realJid + " as " + identity));
        Participant participant = this.findParticipantForJabberId(realJid);
        if (participant == null) {
            logger.error((Object)("Auth request - no member found for JID: " + realJid));
            return;
        }
        XmppChatMember chatMember = participant.getChatMember();
        if (chatMember == null) {
            logger.error((Object)("No chat member for JID: " + realJid));
            return;
        }
        if (participant.getAuthenticatedIdentity() != null) {
            logger.error((Object)(realJid + " already authenticated"));
            return;
        }
        participant.setAuthenticatedIdentity(identity);
        this.chatRoom.grantModerator(chatMember.getName());
    }

    private class MessageListener
    implements PacketListener {
        private LoggingService loggingService = null;
        private boolean loggingServiceSet = false;
        private static final String LOG_ID_PC_STATS = "PeerConnectionStats";

        private MessageListener() {
        }

        public void processPacket(Packet packet) {
            if (!(packet instanceof Message)) {
                return;
            }
            Message message = (Message)packet;
            LogPacketExtension log = null;
            for (PacketExtension ext : message.getExtensions()) {
                if (!(ext instanceof LogPacketExtension)) continue;
                log = (LogPacketExtension)ext;
                break;
            }
            if (log != null) {
                Participant participant = JitsiMeetConference.this.findParticipantForRoomJid(message.getFrom());
                if (participant != null) {
                    this.handleLogRequest(log, participant);
                } else {
                    logger.info((Object)("Ignoring log request from unknown JID: " + message.getFrom()));
                }
            }
        }

        private void handleLogRequest(LogPacketExtension log, Participant participant) {
            LoggingService loggingService = this.getLoggingService();
            if (loggingService != null) {
                if (LOG_ID_PC_STATS.equals(log.getID())) {
                    String content = this.getContent(log);
                    if (content != null) {
                        loggingService.logEvent(LogEventFactory.peerConnectionStats(JitsiMeetConference.this.colibri.getConferenceId(), participant.getChatMember().getName(), content));
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("Ignoring log request with an unknown ID:" + log.getID()));
                }
            }
        }

        private LoggingService getLoggingService() {
            if (!this.loggingServiceSet) {
                this.loggingServiceSet = true;
                this.loggingService = FocusBundleActivator.getLoggingService();
            }
            return this.loggingService;
        }

        private String getContent(LogPacketExtension log) {
            String messageBase64 = log.getMessage();
            byte[] messageBytes = Base64.decode((String)messageBase64);
            if (Boolean.parseBoolean(log.getTagValue("deflated"))) {
                Inflater inflater = new Inflater(true);
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                inflater.setInput(messageBytes);
                byte[] buf = new byte[10000];
                do {
                    try {
                        int len = inflater.inflate(buf);
                        result.write(buf, 0, len);
                    }
                    catch (DataFormatException dfe) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Failed to inflate log request content:" + dfe));
                        }
                        return null;
                    }
                } while (!inflater.finished());
                return result.toString();
            }
            return new String(messageBytes);
        }
    }

    public static interface ConferenceListener {
        public void conferenceEnded(JitsiMeetConference var1);
    }
}

